/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Longs;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.MutableDeletionInfo;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.WriteContext;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.lifecycle.Tracker;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.Cells;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowDiffListener;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.IndexRegistry;
import org.apache.cassandra.index.SecondaryIndexBuilder;
import org.apache.cassandra.index.internal.CassandraIndex;
import org.apache.cassandra.index.transactions.CleanupTransaction;
import org.apache.cassandra.index.transactions.CompactionTransaction;
import org.apache.cassandra.index.transactions.IndexTransaction;
import org.apache.cassandra.index.transactions.UpdateTransaction;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.notifications.INotification;
import org.apache.cassandra.notifications.INotificationConsumer;
import org.apache.cassandra.notifications.SSTableAddedNotification;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.Indexes;
import org.apache.cassandra.service.pager.SinglePartitionPager;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ExecutorUtils;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.concurrent.Refs;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecondaryIndexManager
implements IndexRegistry,
INotificationConsumer {
    private static final Logger logger = LoggerFactory.getLogger(SecondaryIndexManager.class);
    public static final int DEFAULT_PAGE_SIZE = 10000;
    private final Map<String, Index> indexes = Maps.newConcurrentMap();
    private final Set<String> needsFullRebuild = Sets.newConcurrentHashSet();
    private final Set<String> queryableIndexes = Sets.newConcurrentHashSet();
    private final Map<String, Index> writableIndexes = Maps.newConcurrentMap();
    private final Map<String, AtomicInteger> inProgressBuilds = Maps.newConcurrentMap();
    private static final ListeningExecutorService asyncExecutor = MoreExecutors.listeningDecorator((ExecutorService)new JMXEnabledThreadPoolExecutor(1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("SecondaryIndexManagement"), "internal"));
    private static final ListeningExecutorService blockingExecutor = MoreExecutors.newDirectExecutorService();
    public final ColumnFamilyStore baseCfs;
    private final Keyspace keyspace;

    public SecondaryIndexManager(ColumnFamilyStore baseCfs) {
        this.baseCfs = baseCfs;
        this.keyspace = baseCfs.keyspace;
        baseCfs.getTracker().subscribe(this);
    }

    public void reload() {
        Indexes tableIndexes = this.baseCfs.metadata().indexes;
        this.indexes.keySet().stream().filter(indexName -> !tableIndexes.has((String)indexName)).forEach(this::removeIndex);
        for (IndexMetadata tableIndex : tableIndexes) {
            this.addIndex(tableIndex, false);
        }
    }

    private Future<?> reloadIndex(IndexMetadata indexDef) {
        Index index = this.indexes.get(indexDef.name);
        Callable<?> reloadTask = index.getMetadataReloadTask(indexDef);
        return reloadTask == null ? Futures.immediateFuture(null) : blockingExecutor.submit(reloadTask);
    }

    private synchronized Future<?> createIndex(IndexMetadata indexDef, boolean isNewCF) {
        final Index index = this.createInstance(indexDef);
        index.register(this);
        if (this.writableIndexes.put(index.getIndexMetadata().name, index) == null) {
            logger.info("Index [{}] registered and writable.", (Object)index.getIndexMetadata().name);
        }
        this.markIndexesBuilding((Set<Index>)ImmutableSet.of((Object)index), true, isNewCF);
        Callable<?> initialBuildTask = null;
        if (this.indexes.containsKey(indexDef.name)) {
            try {
                initialBuildTask = index.getInitializationTask();
            }
            catch (Throwable t) {
                this.logAndMarkIndexesFailed(Collections.singleton(index), t, true);
                throw t;
            }
        }
        if (initialBuildTask == null) {
            this.markIndexBuilt(index, true);
            return Futures.immediateFuture(null);
        }
        final SettableFuture initialization = SettableFuture.create();
        Futures.addCallback((ListenableFuture)asyncExecutor.submit(initialBuildTask), (FutureCallback)new FutureCallback(){

            public void onFailure(Throwable t) {
                SecondaryIndexManager.this.logAndMarkIndexesFailed(Collections.singleton(index), t, true);
                initialization.setException(t);
            }

            public void onSuccess(Object o) {
                SecondaryIndexManager.this.markIndexBuilt(index, true);
                initialization.set(o);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return initialization;
    }

    public synchronized Future<?> addIndex(IndexMetadata indexDef, boolean isNewCF) {
        if (this.indexes.containsKey(indexDef.name)) {
            return this.reloadIndex(indexDef);
        }
        return this.createIndex(indexDef, isNewCF);
    }

    public boolean isIndexQueryable(Index index) {
        return this.queryableIndexes.contains(index.getIndexMetadata().name);
    }

    public boolean isIndexWritable(Index index) {
        return this.writableIndexes.containsKey(index.getIndexMetadata().name);
    }

    @VisibleForTesting
    public synchronized boolean isIndexBuilding(String indexName) {
        AtomicInteger counter = this.inProgressBuilds.get(indexName);
        return counter != null && counter.get() > 0;
    }

    public synchronized void removeIndex(String indexName) {
        Index index = this.unregisterIndex(indexName);
        if (null != index) {
            this.markIndexRemoved(indexName);
            this.executeBlocking(index.getInvalidateTask(), null);
        }
    }

    public Set<IndexMetadata> getDependentIndexes(ColumnMetadata column) {
        if (this.indexes.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<IndexMetadata> dependentIndexes = new HashSet<IndexMetadata>();
        for (Index index : this.indexes.values()) {
            if (!index.dependsOn(column)) continue;
            dependentIndexes.add(index.getIndexMetadata());
        }
        return dependentIndexes;
    }

    public void markAllIndexesRemoved() {
        this.getBuiltIndexNames().forEach(this::markIndexRemoved);
    }

    public void rebuildIndexesBlocking(Set<String> indexNames) {
        Set<Index> toRebuild = this.indexes.values().stream().filter(index -> indexNames.contains(index.getIndexMetadata().name)).filter(Index::shouldBuildBlocking).collect(Collectors.toSet());
        if (toRebuild.isEmpty()) {
            logger.info("No defined indexes with the supplied names: {}", (Object)Joiner.on((char)',').join(indexNames));
            return;
        }
        boolean needsFlush = false;
        Iterator iterator = toRebuild.iterator();
        while (iterator.hasNext()) {
            Index index2;
            String name = index2.getIndexMetadata().name;
            index2 = (Index)iterator.next();
            if (this.writableIndexes.put(name, index2) != null) continue;
            logger.info("Index [{}] became writable starting recovery.", (Object)name);
            needsFlush = true;
        }
        if (needsFlush) {
            this.baseCfs.forceBlockingFlush();
        }
        try (ColumnFamilyStore.RefViewFragment viewFragment = this.baseCfs.selectAndReference(View.selectFunction(SSTableSet.CANONICAL));
             Refs<SSTableReader> allSSTables = viewFragment.refs;){
            this.buildIndexesBlocking(allSSTables, toRebuild, true);
        }
    }

    public static boolean isIndexColumnFamilyStore(ColumnFamilyStore cfs) {
        return SecondaryIndexManager.isIndexColumnFamily(cfs.name);
    }

    public static boolean isIndexColumnFamily(String cfName) {
        return cfName.contains(".");
    }

    public static ColumnFamilyStore getParentCfs(ColumnFamilyStore cfs) {
        String parentCfs = SecondaryIndexManager.getParentCfsName(cfs.name);
        return cfs.keyspace.getColumnFamilyStore(parentCfs);
    }

    public static String getParentCfsName(String cfName) {
        assert (SecondaryIndexManager.isIndexColumnFamily(cfName));
        return StringUtils.substringBefore((String)cfName, (String)".");
    }

    public static String getIndexName(ColumnFamilyStore cfs) {
        return SecondaryIndexManager.getIndexName(cfs.name);
    }

    public static String getIndexName(String cfName) {
        assert (SecondaryIndexManager.isIndexColumnFamily(cfName));
        return StringUtils.substringAfter((String)cfName, (String)".");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildIndexesBlocking(Collection<SSTableReader> sstables, Set<Index> indexes, boolean isFullRebuild) {
        if (indexes.isEmpty()) {
            return;
        }
        this.markIndexesBuilding(indexes, isFullRebuild, false);
        Set builtIndexes = Sets.newConcurrentHashSet();
        Set unbuiltIndexes = Sets.newConcurrentHashSet();
        Exception accumulatedFail = null;
        try {
            logger.info("Submitting index {} of {} for data in {}", new Object[]{isFullRebuild ? "recovery" : "build", indexes.stream().map(i -> i.getIndexMetadata().name).collect(Collectors.joining(",")), sstables.stream().map(SSTable::toString).collect(Collectors.joining(","))});
            HashMap<Index.IndexBuildingSupport, Set> byType = new HashMap<Index.IndexBuildingSupport, Set>();
            for (Index index : indexes) {
                Index.IndexBuildingSupport buildOrRecoveryTask = isFullRebuild ? index.getBuildTaskSupport() : index.getRecoveryTaskSupport();
                Set stored = byType.computeIfAbsent(buildOrRecoveryTask, i -> new HashSet());
                stored.add(index);
            }
            ArrayList futures = new ArrayList(byType.size());
            byType.forEach((buildingSupport, groupedIndexes) -> {
                SecondaryIndexBuilder builder = buildingSupport.getIndexBuildTask(this.baseCfs, (Set<Index>)groupedIndexes, sstables);
                SettableFuture build = SettableFuture.create();
                Futures.addCallback(CompactionManager.instance.submitIndexBuild(builder), (FutureCallback)new FutureCallback((Set)groupedIndexes, unbuiltIndexes, build, isFullRebuild, builtIndexes){
                    final /* synthetic */ Set val$groupedIndexes;
                    final /* synthetic */ Set val$unbuiltIndexes;
                    final /* synthetic */ SettableFuture val$build;
                    final /* synthetic */ boolean val$isFullRebuild;
                    final /* synthetic */ Set val$builtIndexes;
                    {
                        this.val$groupedIndexes = set;
                        this.val$unbuiltIndexes = set2;
                        this.val$build = settableFuture;
                        this.val$isFullRebuild = bl;
                        this.val$builtIndexes = set3;
                    }

                    public void onFailure(Throwable t) {
                        SecondaryIndexManager.this.logAndMarkIndexesFailed(this.val$groupedIndexes, t, false);
                        this.val$unbuiltIndexes.addAll(this.val$groupedIndexes);
                        this.val$build.setException(t);
                    }

                    public void onSuccess(Object o) {
                        this.val$groupedIndexes.forEach(i -> SecondaryIndexManager.this.markIndexBuilt(i, this.val$isFullRebuild));
                        logger.info("Index build of {} completed", (Object)SecondaryIndexManager.this.getIndexNames(this.val$groupedIndexes));
                        this.val$builtIndexes.addAll(this.val$groupedIndexes);
                        this.val$build.set(o);
                    }
                }, (Executor)MoreExecutors.directExecutor());
                futures.add(build);
            });
            FBUtilities.waitOnFutures(futures);
        }
        catch (Exception e) {
            try {
                accumulatedFail = e;
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    Sets.SetView failedIndexes = Sets.difference(indexes, (Set)Sets.union((Set)builtIndexes, (Set)unbuiltIndexes));
                    if (!failedIndexes.isEmpty()) {
                        this.logAndMarkIndexesFailed((Set<Index>)failedIndexes, accumulatedFail, false);
                    }
                    this.flushIndexesBlocking(builtIndexes, (FutureCallback<Object>)new FutureCallback(builtIndexes){
                        String indexNames;
                        final /* synthetic */ Set val$builtIndexes;
                        {
                            this.val$builtIndexes = set;
                            this.indexNames = StringUtils.join((Iterable)this.val$builtIndexes.stream().map(i -> i.getIndexMetadata().name).collect(Collectors.toList()), (char)',');
                        }

                        public void onFailure(Throwable ignored) {
                            logger.info("Index flush of {} failed", (Object)this.indexNames);
                        }

                        public void onSuccess(Object ignored) {
                            logger.info("Index flush of {} completed", (Object)this.indexNames);
                        }
                    });
                    throw throwable;
                }
                catch (Exception e2) {
                    if (accumulatedFail == null) throw e2;
                    accumulatedFail.addSuppressed(e2);
                    throw throwable;
                }
            }
        }
        try {
            Sets.SetView failedIndexes = Sets.difference(indexes, (Set)Sets.union((Set)builtIndexes, (Set)unbuiltIndexes));
            if (!failedIndexes.isEmpty()) {
                this.logAndMarkIndexesFailed((Set<Index>)failedIndexes, accumulatedFail, false);
            }
            this.flushIndexesBlocking(builtIndexes, (FutureCallback<Object>)new /* invalid duplicate definition of identical inner class */);
            return;
        }
        catch (Exception e) {
            if (accumulatedFail == null) throw e;
            accumulatedFail.addSuppressed(e);
            return;
        }
    }

    private String getIndexNames(Set<Index> indexes) {
        List indexNames = indexes.stream().map(i -> i.getIndexMetadata().name).collect(Collectors.toList());
        return StringUtils.join(indexNames, (char)',');
    }

    private synchronized void markIndexesBuilding(Set<Index> indexes, boolean isFullRebuild, boolean isNewCF) {
        String keyspaceName = this.baseCfs.keyspace.getName();
        indexes.forEach(index -> {
            String indexName = index.getIndexMetadata().name;
            AtomicInteger counter = this.inProgressBuilds.computeIfAbsent(indexName, ignored -> new AtomicInteger(0));
            if (counter.get() > 0 && isFullRebuild) {
                throw new IllegalStateException(String.format("Cannot rebuild index %s as another index build for the same index is currently in progress.", indexName));
            }
        });
        indexes.forEach(index -> {
            String indexName = index.getIndexMetadata().name;
            AtomicInteger counter = this.inProgressBuilds.computeIfAbsent(indexName, ignored -> new AtomicInteger(0));
            if (isFullRebuild) {
                this.needsFullRebuild.remove(indexName);
            }
            if (counter.getAndIncrement() == 0 && DatabaseDescriptor.isDaemonInitialized() && !isNewCF) {
                SystemKeyspace.setIndexRemoved(keyspaceName, indexName);
            }
        });
    }

    private synchronized void markIndexBuilt(Index index, boolean isFullRebuild) {
        AtomicInteger counter;
        String indexName = index.getIndexMetadata().name;
        if (isFullRebuild) {
            if (this.queryableIndexes.add(indexName)) {
                logger.info("Index [{}] became queryable after successful build.", (Object)indexName);
            }
            if (this.writableIndexes.put(indexName, index) == null) {
                logger.info("Index [{}] became writable after successful build.", (Object)indexName);
            }
        }
        if ((counter = this.inProgressBuilds.get(indexName)) != null) {
            assert (counter.get() > 0);
            if (counter.decrementAndGet() == 0) {
                this.inProgressBuilds.remove(indexName);
                if (!this.needsFullRebuild.contains(indexName) && DatabaseDescriptor.isDaemonInitialized()) {
                    SystemKeyspace.setIndexBuilt(this.baseCfs.keyspace.getName(), indexName);
                }
            }
        }
    }

    private synchronized void markIndexFailed(Index index, boolean isInitialBuild) {
        String indexName = index.getIndexMetadata().name;
        AtomicInteger counter = this.inProgressBuilds.get(indexName);
        if (counter != null) {
            assert (counter.get() > 0);
            counter.decrementAndGet();
            if (DatabaseDescriptor.isDaemonInitialized()) {
                SystemKeyspace.setIndexRemoved(this.baseCfs.keyspace.getName(), indexName);
            }
            this.needsFullRebuild.add(indexName);
            if (!index.getSupportedLoadTypeOnFailure(isInitialBuild).supportsWrites() && this.writableIndexes.remove(indexName) != null) {
                logger.info("Index [{}] became not-writable because of failed build.", (Object)indexName);
            }
            if (!index.getSupportedLoadTypeOnFailure(isInitialBuild).supportsReads() && this.queryableIndexes.remove(indexName)) {
                logger.info("Index [{}] became not-queryable because of failed build.", (Object)indexName);
            }
        }
    }

    private void logAndMarkIndexesFailed(Set<Index> indexes, Throwable indexBuildFailure, boolean isInitialBuild) {
        JVMStabilityInspector.inspectThrowable(indexBuildFailure);
        if (indexBuildFailure != null) {
            logger.warn("Index build of {} failed. Please run full index rebuild to fix it.", (Object)this.getIndexNames(indexes), (Object)indexBuildFailure);
        } else {
            logger.warn("Index build of {} failed. Please run full index rebuild to fix it.", (Object)this.getIndexNames(indexes));
        }
        indexes.forEach(i -> this.markIndexFailed((Index)i, isInitialBuild));
    }

    private synchronized void markIndexRemoved(String indexName) {
        SystemKeyspace.setIndexRemoved(this.baseCfs.keyspace.getName(), indexName);
        this.queryableIndexes.remove(indexName);
        this.writableIndexes.remove(indexName);
        this.needsFullRebuild.remove(indexName);
        this.inProgressBuilds.remove(indexName);
    }

    public Index getIndexByName(String indexName) {
        return this.indexes.get(indexName);
    }

    private Index createInstance(IndexMetadata indexDef) {
        Index newIndex;
        if (indexDef.isCustom()) {
            assert (indexDef.options != null);
            String className = indexDef.options.get("class_name");
            assert (!Strings.isNullOrEmpty((String)className));
            try {
                Class indexClass = FBUtilities.classForName(className, "Index");
                Constructor ctor = indexClass.getConstructor(ColumnFamilyStore.class, IndexMetadata.class);
                newIndex = (Index)ctor.newInstance(this.baseCfs, indexDef);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            newIndex = CassandraIndex.newIndex(this.baseCfs, indexDef);
        }
        return newIndex;
    }

    public void truncateAllIndexesBlocking(long truncatedAt) {
        this.executeAllBlocking(this.indexes.values().stream(), index -> index.getTruncateTask(truncatedAt), null);
    }

    public void dropAllIndexes() {
        this.markAllIndexesRemoved();
        this.invalidateAllIndexesBlocking();
    }

    @VisibleForTesting
    public void invalidateAllIndexesBlocking() {
        this.executeAllBlocking(this.indexes.values().stream(), Index::getInvalidateTask, null);
    }

    public void flushAllIndexesBlocking() {
        this.flushIndexesBlocking((Set<Index>)ImmutableSet.copyOf(this.indexes.values()));
    }

    public void flushIndexesBlocking(Set<Index> indexes) {
        this.flushIndexesBlocking(indexes, null);
    }

    public void flushAllNonCFSBackedIndexesBlocking() {
        this.executeAllBlocking(this.indexes.values().stream().filter(index -> !index.getBackingTable().isPresent()), Index::getBlockingFlushTask, null);
    }

    public void executePreJoinTasksBlocking(boolean hadBootstrap) {
        logger.info("Executing pre-join{} tasks for: {}", (Object)(hadBootstrap ? " post-bootstrap" : ""), (Object)this.baseCfs);
        this.executeAllBlocking(this.indexes.values().stream(), index -> index.getPreJoinTask(hadBootstrap), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushIndexesBlocking(Set<Index> indexes, FutureCallback<Object> callback) {
        if (indexes.isEmpty()) {
            return;
        }
        ArrayList wait = new ArrayList();
        ArrayList nonCfsIndexes = new ArrayList();
        Tracker tracker = this.baseCfs.getTracker();
        synchronized (tracker) {
            indexes.forEach(index -> index.getBackingTable().map(cfs -> wait.add(cfs.forceFlush())).orElseGet(() -> nonCfsIndexes.add(index)));
        }
        this.executeAllBlocking(nonCfsIndexes.stream(), Index::getBlockingFlushTask, callback);
        FBUtilities.waitOnFutures(wait);
    }

    public List<String> getBuiltIndexNames() {
        HashSet<String> allIndexNames = new HashSet<String>();
        this.indexes.values().stream().map(i -> i.getIndexMetadata().name).forEach(allIndexNames::add);
        return SystemKeyspace.getBuiltIndexes(this.baseCfs.keyspace.getName(), allIndexNames);
    }

    public Set<ColumnFamilyStore> getAllIndexColumnFamilyStores() {
        HashSet<ColumnFamilyStore> backingTables = new HashSet<ColumnFamilyStore>();
        this.indexes.values().forEach(index -> index.getBackingTable().ifPresent(backingTables::add));
        return backingTables;
    }

    public boolean hasIndexes() {
        return !this.indexes.isEmpty();
    }

    public void indexPartition(DecoratedKey key, Set<Index> indexes, int pageSize) {
        if (logger.isTraceEnabled()) {
            logger.trace("Indexing partition {}", (Object)this.baseCfs.metadata().partitionKeyType.getString(key.getKey()));
        }
        if (!indexes.isEmpty()) {
            SinglePartitionReadCommand cmd = SinglePartitionReadCommand.fullPartitionRead(this.baseCfs.metadata(), FBUtilities.nowInSeconds(), key);
            int nowInSec = cmd.nowInSec();
            boolean readStatic = false;
            SinglePartitionPager pager = new SinglePartitionPager(cmd, null, ProtocolVersion.CURRENT);
            while (!pager.isExhausted()) {
                ReadExecutionController controller = cmd.executionController();
                Throwable throwable = null;
                try {
                    WriteContext ctx = this.keyspace.getWriteHandler().createContextForIndexing();
                    Throwable throwable2 = null;
                    try {
                        UnfilteredPartitionIterator page = pager.fetchPageUnfiltered(this.baseCfs.metadata(), pageSize, controller);
                        Throwable throwable3 = null;
                        try {
                            if (!page.hasNext()) break;
                            UnfilteredRowIterator partition = (UnfilteredRowIterator)page.next();
                            Throwable throwable4 = null;
                            try {
                                Set<Index.Indexer> indexers = indexes.stream().map(index -> index.indexerFor(key, partition.columns(), nowInSec, ctx, IndexTransaction.Type.UPDATE)).filter(Objects::nonNull).collect(Collectors.toSet());
                                if (!readStatic && partition.isEmpty() && partition.staticRow().isEmpty()) break;
                                indexers.forEach(Index.Indexer::begin);
                                if (!readStatic) {
                                    if (!partition.staticRow().isEmpty()) {
                                        indexers.forEach(indexer -> indexer.insertRow(partition.staticRow()));
                                    }
                                    indexers.forEach(i -> i.partitionDelete(partition.partitionLevelDeletion()));
                                    readStatic = true;
                                }
                                MutableDeletionInfo.Builder deletionBuilder = MutableDeletionInfo.builder(partition.partitionLevelDeletion(), this.baseCfs.getComparator(), false);
                                while (partition.hasNext()) {
                                    Unfiltered unfilteredRow = (Unfiltered)partition.next();
                                    if (unfilteredRow.isRow()) {
                                        Row row = (Row)unfilteredRow;
                                        indexers.forEach(indexer -> indexer.insertRow(row));
                                        continue;
                                    }
                                    assert (unfilteredRow.isRangeTombstoneMarker());
                                    RangeTombstoneMarker marker = (RangeTombstoneMarker)unfilteredRow;
                                    deletionBuilder.add(marker);
                                }
                                MutableDeletionInfo deletionInfo = deletionBuilder.build();
                                if (deletionInfo.hasRanges()) {
                                    Iterator<RangeTombstone> iter = deletionInfo.rangeIterator(false);
                                    while (iter.hasNext()) {
                                        RangeTombstone rt = iter.next();
                                        indexers.forEach(indexer -> indexer.rangeTombstone(rt));
                                    }
                                }
                                indexers.forEach(Index.Indexer::finish);
                            }
                            catch (Throwable throwable5) {
                                throwable4 = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (partition == null) continue;
                                if (throwable4 != null) {
                                    try {
                                        partition.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable4.addSuppressed(throwable6);
                                    }
                                    continue;
                                }
                                partition.close();
                            }
                        }
                        catch (Throwable throwable7) {
                            throwable3 = throwable7;
                            throw throwable7;
                        }
                        finally {
                            if (page == null) continue;
                            if (throwable3 != null) {
                                try {
                                    page.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable3.addSuppressed(throwable8);
                                }
                                continue;
                            }
                            page.close();
                        }
                    }
                    catch (Throwable throwable9) {
                        throwable2 = throwable9;
                        throw throwable9;
                    }
                    finally {
                        if (ctx == null) continue;
                        if (throwable2 != null) {
                            try {
                                ctx.close();
                            }
                            catch (Throwable throwable10) {
                                throwable2.addSuppressed(throwable10);
                            }
                            continue;
                        }
                        ctx.close();
                    }
                }
                catch (Throwable throwable11) {
                    throwable = throwable11;
                    throw throwable11;
                }
                finally {
                    if (controller == null) continue;
                    if (throwable != null) {
                        try {
                            controller.close();
                        }
                        catch (Throwable throwable12) {
                            throwable.addSuppressed(throwable12);
                        }
                        continue;
                    }
                    controller.close();
                }
            }
        }
    }

    public int calculateIndexingPageSize() {
        if (Boolean.getBoolean("cassandra.force_default_indexing_page_size")) {
            return 10000;
        }
        double targetPageSizeInBytes = 3.3554432E7;
        double meanPartitionSize = this.baseCfs.getMeanPartitionSize();
        if (meanPartitionSize <= 0.0) {
            return 10000;
        }
        int meanCellsPerPartition = this.baseCfs.getMeanEstimatedCellPerPartitionCount();
        if (meanCellsPerPartition <= 0) {
            return 10000;
        }
        int columnsPerRow = this.baseCfs.metadata().regularColumns().size();
        if (columnsPerRow <= 0) {
            return 10000;
        }
        int meanRowsPerPartition = meanCellsPerPartition / columnsPerRow;
        double meanRowSize = meanPartitionSize / (double)meanRowsPerPartition;
        int pageSize = (int)Math.max(1.0, Math.min(10000.0, targetPageSizeInBytes / meanRowSize));
        logger.trace("Calculated page size {} for indexing {}.{} ({}/{}/{}/{})", new Object[]{pageSize, this.baseCfs.metadata.keyspace, this.baseCfs.metadata.name, meanPartitionSize, meanCellsPerPartition, meanRowsPerPartition, meanRowSize});
        return pageSize;
    }

    public void deletePartition(UnfilteredRowIterator partition, int nowInSec) {
        CleanupTransaction indexTransaction = this.newCleanupTransaction(partition.partitionKey(), partition.columns(), nowInSec);
        indexTransaction.start();
        indexTransaction.onPartitionDeletion(new DeletionTime(FBUtilities.timestampMicros(), nowInSec));
        indexTransaction.commit();
        while (partition.hasNext()) {
            Unfiltered unfiltered = (Unfiltered)partition.next();
            if (unfiltered.kind() != Unfiltered.Kind.ROW) continue;
            indexTransaction = this.newCleanupTransaction(partition.partitionKey(), partition.columns(), nowInSec);
            indexTransaction.start();
            indexTransaction.onRowDelete((Row)unfiltered);
            indexTransaction.commit();
        }
    }

    public Index getBestIndexFor(RowFilter rowFilter) {
        Index selected;
        if (this.indexes.isEmpty() || rowFilter.isEmpty()) {
            return null;
        }
        HashSet searchableIndexes = new HashSet();
        for (RowFilter.Expression expression : rowFilter) {
            if (expression.isCustom()) {
                RowFilter.CustomExpression customExpression = (RowFilter.CustomExpression)expression;
                logger.trace("Command contains a custom index expression, using target index {}", (Object)customExpression.getTargetIndex().name);
                Tracing.trace("Command contains a custom index expression, using target index {}", (Object)customExpression.getTargetIndex().name);
                return this.indexes.get(customExpression.getTargetIndex().name);
            }
            if (expression.isUserDefined()) continue;
            this.indexes.values().stream().filter(index -> index.supportsExpression(expression.column(), expression.operator())).forEach(searchableIndexes::add);
        }
        if (searchableIndexes.isEmpty()) {
            logger.trace("No applicable indexes found");
            Tracing.trace("No applicable indexes found");
            return null;
        }
        Index index2 = selected = searchableIndexes.size() == 1 ? (Index)Iterables.getOnlyElement(searchableIndexes) : (Index)searchableIndexes.stream().min((a, b) -> Longs.compare((long)a.getEstimatedResultRows(), (long)b.getEstimatedResultRows())).orElseThrow(() -> new AssertionError((Object)"Could not select most selective index"));
        if (Tracing.isTracing()) {
            Tracing.trace("Index mean cardinalities are {}. Scanning with {}.", (Object)searchableIndexes.stream().map(i -> i.getIndexMetadata().name + ':' + i.getEstimatedResultRows()).collect(Collectors.joining(",")), (Object)selected.getIndexMetadata().name);
        }
        return selected;
    }

    @Override
    public Optional<Index> getBestIndexFor(RowFilter.Expression expression) {
        return this.indexes.values().stream().filter(i -> i.supportsExpression(expression.column(), expression.operator())).findFirst();
    }

    @Override
    public void validate(PartitionUpdate update) throws InvalidRequestException {
        for (Index index : this.indexes.values()) {
            index.validate(update);
        }
    }

    @Override
    public void registerIndex(Index index) {
        String name = index.getIndexMetadata().name;
        this.indexes.put(name, index);
        logger.trace("Registered index {}", (Object)name);
    }

    @Override
    public void unregisterIndex(Index index) {
        this.unregisterIndex(index.getIndexMetadata().name);
    }

    private Index unregisterIndex(String name) {
        Index removed = this.indexes.remove(name);
        logger.trace(removed == null ? "Index {} was not registered" : "Removed index {} from registry", (Object)name);
        return removed;
    }

    @Override
    public Index getIndex(IndexMetadata metadata) {
        return this.indexes.get(metadata.name);
    }

    @Override
    public Collection<Index> listIndexes() {
        return ImmutableSet.copyOf(this.indexes.values());
    }

    public UpdateTransaction newUpdateTransaction(PartitionUpdate update, WriteContext ctx, int nowInSec) {
        if (!this.hasIndexes()) {
            return UpdateTransaction.NO_OP;
        }
        ArrayList<Index.Indexer> idxrs = new ArrayList<Index.Indexer>();
        for (Index i : this.writableIndexes.values()) {
            Index.Indexer idxr = i.indexerFor(update.partitionKey(), update.columns(), nowInSec, ctx, IndexTransaction.Type.UPDATE);
            if (idxr == null) continue;
            idxrs.add(idxr);
        }
        if (idxrs.size() == 0) {
            return UpdateTransaction.NO_OP;
        }
        return new WriteTimeTransaction(idxrs.toArray(new Index.Indexer[idxrs.size()]));
    }

    public CompactionTransaction newCompactionTransaction(DecoratedKey key, RegularAndStaticColumns regularAndStaticColumns, int versions, int nowInSec) {
        return new IndexGCTransaction(key, regularAndStaticColumns, this.keyspace, versions, nowInSec, this.writableIndexes.values());
    }

    public CleanupTransaction newCleanupTransaction(DecoratedKey key, RegularAndStaticColumns regularAndStaticColumns, int nowInSec) {
        if (!this.hasIndexes()) {
            return CleanupTransaction.NO_OP;
        }
        return new CleanupGCTransaction(key, regularAndStaticColumns, this.keyspace, nowInSec, this.writableIndexes.values());
    }

    private void executeBlocking(Callable<?> task, FutureCallback<Object> callback) {
        if (null != task) {
            ListenableFuture f = blockingExecutor.submit(task);
            if (callback != null) {
                Futures.addCallback((ListenableFuture)f, callback, (Executor)MoreExecutors.directExecutor());
            }
            FBUtilities.waitOnFuture(f);
        }
    }

    private void executeAllBlocking(Stream<Index> indexers, Function<Index, Callable<?>> function, FutureCallback<Object> callback) {
        if (function == null) {
            logger.error("failed to flush indexes: {} because flush task is missing.", indexers);
            return;
        }
        ArrayList waitFor = new ArrayList();
        indexers.forEach(indexer -> {
            Callable task = (Callable)function.apply((Index)indexer);
            if (null != task) {
                ListenableFuture f = blockingExecutor.submit(task);
                if (callback != null) {
                    Futures.addCallback((ListenableFuture)f, (FutureCallback)callback, (Executor)MoreExecutors.directExecutor());
                }
                waitFor.add(f);
            }
        });
        FBUtilities.waitOnFutures(waitFor);
    }

    @Override
    public void handleNotification(INotification notification, Object sender) {
        SSTableAddedNotification notice;
        if (!this.indexes.isEmpty() && notification instanceof SSTableAddedNotification && !(notice = (SSTableAddedNotification)notification).memtable().isPresent()) {
            this.buildIndexesBlocking(Lists.newArrayList(notice.added), this.indexes.values().stream().filter(Index::shouldBuildBlocking).collect(Collectors.toSet()), false);
        }
    }

    @VisibleForTesting
    public static void shutdownAndWait(long timeout, TimeUnit units) throws InterruptedException, TimeoutException {
        ExecutorUtils.shutdown(new ExecutorService[]{asyncExecutor, blockingExecutor});
        ExecutorUtils.awaitTermination(timeout, units, new ExecutorService[]{asyncExecutor, blockingExecutor});
    }

    private static final class CleanupGCTransaction
    implements CleanupTransaction {
        private final DecoratedKey key;
        private final RegularAndStaticColumns columns;
        private final Keyspace keyspace;
        private final int nowInSec;
        private final Collection<Index> indexes;
        private Row row;
        private DeletionTime partitionDelete;

        private CleanupGCTransaction(DecoratedKey key, RegularAndStaticColumns columns, Keyspace keyspace, int nowInSec, Collection<Index> indexes) {
            this.key = key;
            this.columns = columns;
            this.keyspace = keyspace;
            this.indexes = indexes;
            this.nowInSec = nowInSec;
        }

        @Override
        public void start() {
        }

        @Override
        public void onPartitionDeletion(DeletionTime deletionTime) {
            this.partitionDelete = deletionTime;
        }

        @Override
        public void onRowDelete(Row row) {
            this.row = row;
        }

        @Override
        public void commit() {
            if (this.row == null && this.partitionDelete == null) {
                return;
            }
            try (WriteContext ctx = this.keyspace.getWriteHandler().createContextForIndexing();){
                for (Index index : this.indexes) {
                    Index.Indexer indexer = index.indexerFor(this.key, this.columns, this.nowInSec, ctx, IndexTransaction.Type.CLEANUP);
                    if (indexer == null) continue;
                    indexer.begin();
                    if (this.partitionDelete != null) {
                        indexer.partitionDelete(this.partitionDelete);
                    }
                    if (this.row != null) {
                        indexer.removeRow(this.row);
                    }
                    indexer.finish();
                }
            }
        }
    }

    private static final class IndexGCTransaction
    implements CompactionTransaction {
        private final DecoratedKey key;
        private final RegularAndStaticColumns columns;
        private final Keyspace keyspace;
        private final int versions;
        private final int nowInSec;
        private final Collection<Index> indexes;
        private Row[] rows;

        private IndexGCTransaction(DecoratedKey key, RegularAndStaticColumns columns, Keyspace keyspace, int versions, int nowInSec, Collection<Index> indexes) {
            this.key = key;
            this.columns = columns;
            this.keyspace = keyspace;
            this.versions = versions;
            this.indexes = indexes;
            this.nowInSec = nowInSec;
        }

        @Override
        public void start() {
            if (this.versions > 0) {
                this.rows = new Row[this.versions];
            }
        }

        @Override
        public void onRowMerge(Row merged, Row ... versions) {
            final Row.Builder[] builders = new Row.Builder[versions.length];
            RowDiffListener diffListener = new RowDiffListener(){

                @Override
                public void onPrimaryKeyLivenessInfo(int i, Clustering<?> clustering, LivenessInfo merged, LivenessInfo original) {
                    if (!(original == null || merged != null && merged.isLive(nowInSec))) {
                        this.getBuilder(i, clustering).addPrimaryKeyLivenessInfo(original);
                    }
                }

                @Override
                public void onDeletion(int i, Clustering<?> clustering, Row.Deletion merged, Row.Deletion original) {
                }

                @Override
                public void onComplexDeletion(int i, Clustering<?> clustering, ColumnMetadata column, DeletionTime merged, DeletionTime original) {
                }

                @Override
                public void onCell(int i, Clustering<?> clustering, Cell<?> merged, Cell<?> original) {
                    if (!(original == null || merged != null && merged.isLive(nowInSec))) {
                        this.getBuilder(i, clustering).addCell(original);
                    }
                }

                private Row.Builder getBuilder(int index, Clustering<?> clustering) {
                    if (builders[index] == null) {
                        builders[index] = BTreeRow.sortedBuilder();
                        builders[index].newRow(clustering);
                    }
                    return builders[index];
                }
            };
            Rows.diff(diffListener, merged, versions);
            for (int i = 0; i < builders.length; ++i) {
                if (builders[i] == null) continue;
                this.rows[i] = builders[i].build();
            }
        }

        @Override
        public void commit() {
            if (this.rows == null) {
                return;
            }
            try (WriteContext ctx = this.keyspace.getWriteHandler().createContextForIndexing();){
                for (Index index : this.indexes) {
                    Index.Indexer indexer = index.indexerFor(this.key, this.columns, this.nowInSec, ctx, IndexTransaction.Type.COMPACTION);
                    if (indexer == null) continue;
                    indexer.begin();
                    for (Row row : this.rows) {
                        if (row == null) continue;
                        indexer.removeRow(row);
                    }
                    indexer.finish();
                }
            }
        }
    }

    private static final class WriteTimeTransaction
    implements UpdateTransaction {
        private final Index.Indexer[] indexers;

        private WriteTimeTransaction(Index.Indexer ... indexers) {
            for (Index.Indexer indexer : indexers) {
                assert (indexer != null);
            }
            this.indexers = indexers;
        }

        @Override
        public void start() {
            for (Index.Indexer indexer : this.indexers) {
                indexer.begin();
            }
        }

        @Override
        public void onPartitionDeletion(DeletionTime deletionTime) {
            for (Index.Indexer indexer : this.indexers) {
                indexer.partitionDelete(deletionTime);
            }
        }

        @Override
        public void onRangeTombstone(RangeTombstone tombstone) {
            for (Index.Indexer indexer : this.indexers) {
                indexer.rangeTombstone(tombstone);
            }
        }

        @Override
        public void onInserted(Row row) {
            for (Index.Indexer indexer : this.indexers) {
                indexer.insertRow(row);
            }
        }

        @Override
        public void onUpdated(Row existing, Row updated) {
            final Row.Builder toRemove = BTreeRow.sortedBuilder();
            toRemove.newRow((Clustering<?>)existing.clustering());
            toRemove.addPrimaryKeyLivenessInfo(existing.primaryKeyLivenessInfo());
            toRemove.addRowDeletion(existing.deletion());
            final Row.Builder toInsert = BTreeRow.sortedBuilder();
            toInsert.newRow((Clustering<?>)updated.clustering());
            toInsert.addPrimaryKeyLivenessInfo(updated.primaryKeyLivenessInfo());
            toInsert.addRowDeletion(updated.deletion());
            RowDiffListener diffListener = new RowDiffListener(){

                @Override
                public void onPrimaryKeyLivenessInfo(int i, Clustering<?> clustering, LivenessInfo merged, LivenessInfo original) {
                }

                @Override
                public void onDeletion(int i, Clustering<?> clustering, Row.Deletion merged, Row.Deletion original) {
                }

                @Override
                public void onComplexDeletion(int i, Clustering<?> clustering, ColumnMetadata column, DeletionTime merged, DeletionTime original) {
                }

                @Override
                public void onCell(int i, Clustering<?> clustering, Cell<?> merged, Cell<?> original) {
                    if (merged != null && !merged.equals(original)) {
                        toInsert.addCell(merged);
                    }
                    if (merged == null || original != null && this.shouldCleanupOldValue(original, merged)) {
                        toRemove.addCell(original);
                    }
                }
            };
            Rows.diff(diffListener, updated, existing);
            Row oldRow = toRemove.build();
            Row newRow = toInsert.build();
            for (Index.Indexer indexer : this.indexers) {
                indexer.updateRow(oldRow, newRow);
            }
        }

        @Override
        public void commit() {
            for (Index.Indexer indexer : this.indexers) {
                indexer.finish();
            }
        }

        private <V1, V2> boolean shouldCleanupOldValue(Cell<V1> oldCell, Cell<V2> newCell) {
            return !Cells.valueEqual(oldCell, newCell) || oldCell.timestamp() != newCell.timestamp();
        }
    }
}

