/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.repair;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.repair.CassandraValidationIterator;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.repair.TableRepairManager;
import org.apache.cassandra.repair.ValidationPartitionIterator;

public class CassandraTableRepairManager
implements TableRepairManager {
    private final ColumnFamilyStore cfs;

    public CassandraTableRepairManager(ColumnFamilyStore cfs) {
        this.cfs = cfs;
    }

    @Override
    public ValidationPartitionIterator getValidationIterator(Collection<Range<Token>> ranges, UUID parentId, UUID sessionID, boolean isIncremental, int nowInSec) throws IOException {
        return new CassandraValidationIterator(this.cfs, ranges, parentId, sessionID, isIncremental, nowInSec);
    }

    @Override
    public Future<?> submitValidation(Callable<Object> validation) {
        return CompactionManager.instance.submitValidation(validation);
    }

    @Override
    public void incrementalSessionCompleted(UUID sessionID) {
        CompactionManager.instance.submitBackground(this.cfs);
    }

    @Override
    public synchronized void snapshot(String name, final Collection<Range<Token>> ranges, boolean force) {
        if (force || !this.cfs.snapshotExists(name)) {
            this.cfs.snapshot(name, new Predicate<SSTableReader>(){

                public boolean apply(SSTableReader sstable) {
                    return sstable != null && !sstable.metadata().isIndex() && ((AbstractBounds)new Bounds<Token>(sstable.first.getToken(), sstable.last.getToken())).intersects(ranges);
                }
            }, true, false);
        }
    }
}

