/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import org.apache.cassandra.db.AbstractArrayClusteringPrefix;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.utils.ObjectSizes;

public class ArrayClustering
extends AbstractArrayClusteringPrefix
implements Clustering<byte[]> {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new ArrayClustering(EMPTY_VALUES_ARRAY));

    public ArrayClustering(byte[] ... values) {
        super(ClusteringPrefix.Kind.CLUSTERING, values);
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + ObjectSizes.sizeOfArray(this.values) + (long)((byte[][])this.values).length;
    }

    @Override
    public long unsharedHeapSizeExcludingData() {
        return EMPTY_SIZE + ObjectSizes.sizeOfArray(this.values);
    }

    public static ArrayClustering make(byte[] ... values) {
        return new ArrayClustering(values);
    }
}

