/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringJoiner;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.ColumnSubselection;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.CassandraVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnFilter {
    private static final Logger logger = LoggerFactory.getLogger(ColumnFilter.class);
    public static final ColumnFilter NONE = ColumnFilter.selection(RegularAndStaticColumns.NONE);
    public static final Serializer serializer = new Serializer();
    @VisibleForTesting
    final boolean fetchAllRegulars;
    private final boolean fetchAllStatics;
    @VisibleForTesting
    final RegularAndStaticColumns fetched;
    private final RegularAndStaticColumns queried;
    private final SortedSetMultimap<ColumnIdentifier, ColumnSubselection> subSelections;

    private ColumnFilter(boolean fetchAllRegulars, boolean fetchAllStatics, TableMetadata metadata, RegularAndStaticColumns queried, SortedSetMultimap<ColumnIdentifier, ColumnSubselection> subSelections) {
        assert (!fetchAllRegulars || metadata != null);
        assert (fetchAllRegulars || queried != null);
        assert (!fetchAllStatics || fetchAllRegulars);
        this.fetchAllRegulars = fetchAllRegulars;
        boolean bl = this.fetchAllStatics = fetchAllStatics || fetchAllRegulars && queried == null;
        if (fetchAllRegulars) {
            RegularAndStaticColumns all = metadata.regularAndStaticColumns();
            this.fetched = all.statics.isEmpty() || queried == null || fetchAllStatics ? all : new RegularAndStaticColumns(queried.statics, all.regulars);
        } else {
            this.fetched = queried;
        }
        this.queried = queried;
        this.subSelections = subSelections;
    }

    private ColumnFilter(boolean fetchAllRegulars, boolean fetchAllStatics, RegularAndStaticColumns fetched, RegularAndStaticColumns queried, SortedSetMultimap<ColumnIdentifier, ColumnSubselection> subSelections) {
        assert (!fetchAllRegulars || fetched != null);
        assert (fetchAllRegulars || queried != null);
        assert (!fetchAllStatics || fetchAllRegulars);
        this.fetchAllRegulars = fetchAllRegulars;
        this.fetchAllStatics = fetchAllStatics || fetchAllRegulars && queried == null;
        this.fetched = fetchAllRegulars ? fetched : queried;
        this.queried = queried;
        this.subSelections = subSelections;
    }

    private static boolean shouldFetchAllStatics() {
        if (Gossiper.instance.isUpgradingFromVersionLowerThan(CassandraVersion.CASSANDRA_4_0)) {
            logger.trace("ColumnFilter conversion has been applied so that all static columns will be fetched because there are pre 4.0 nodes in the cluster");
            return true;
        }
        return false;
    }

    private static boolean shouldQueriedBeNull() {
        if (Gossiper.instance.isUpgradingFromVersionLowerThan(CassandraVersion.CASSANDRA_3_4)) {
            logger.trace("ColumnFilter conversion has been applied so that all columns will be queried because there are pre 3.4 nodes in the cluster");
            return true;
        }
        return false;
    }

    public static ColumnFilter all(TableMetadata metadata) {
        return new ColumnFilter(true, true, metadata, null, null);
    }

    public static ColumnFilter selection(RegularAndStaticColumns columns) {
        return new ColumnFilter(false, false, (TableMetadata)null, columns, null);
    }

    public static ColumnFilter selection(TableMetadata metadata, RegularAndStaticColumns queried) {
        return new ColumnFilter(true, ColumnFilter.shouldFetchAllStatics(), metadata, ColumnFilter.shouldQueriedBeNull() ? null : queried, null);
    }

    public RegularAndStaticColumns fetchedColumns() {
        return this.fetched;
    }

    public RegularAndStaticColumns queriedColumns() {
        return this.queried == null ? this.fetched : this.queried;
    }

    public boolean fetchesAllColumns(boolean isStatic) {
        return isStatic ? this.queried == null || this.fetchAllStatics : this.fetchAllRegulars;
    }

    public boolean allFetchedColumnsAreQueried() {
        return !this.fetchAllRegulars || this.queried == null;
    }

    public boolean fetches(ColumnMetadata column) {
        if (column.isStatic()) {
            return this.fetchAllStatics || this.queried == null || this.queried.contains(column);
        }
        return this.fetchAllRegulars || this.queried.contains(column);
    }

    public boolean fetchedColumnIsQueried(ColumnMetadata column) {
        return !this.fetchAllRegulars || this.queried == null || this.queried.contains(column);
    }

    public boolean fetchedCellIsQueried(ColumnMetadata column, CellPath path) {
        assert (path != null);
        if (!this.fetchedColumnIsQueried(column)) {
            return false;
        }
        if (this.subSelections == null) {
            return true;
        }
        SortedSet s = this.subSelections.get((Object)column.name);
        if (s.isEmpty()) {
            return true;
        }
        for (ColumnSubselection subSel : s) {
            if (subSel.compareInclusionOf(path) != 0) continue;
            return true;
        }
        return false;
    }

    public Tester newTester(ColumnMetadata column) {
        if (this.subSelections == null || !column.isComplex()) {
            return null;
        }
        SortedSet s = this.subSelections.get((Object)column.name);
        if (s.isEmpty()) {
            return null;
        }
        return new Tester(!column.isStatic() && this.fetchAllRegulars || column.isStatic() && this.fetchAllStatics, s.iterator());
    }

    public Iterator<Cell<?>> filterComplexCells(ColumnMetadata column, Iterator<Cell<?>> cells) {
        Tester tester = this.newTester(column);
        if (tester == null) {
            return cells;
        }
        return Iterators.filter(cells, cell -> tester.fetchedCellIsQueried(cell.path()));
    }

    public static Builder allRegularColumnsBuilder(TableMetadata metadata) {
        return new Builder(metadata);
    }

    public static Builder selectionBuilder() {
        return new Builder(null);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ColumnFilter)) {
            return false;
        }
        ColumnFilter otherCf = (ColumnFilter)other;
        return otherCf.fetchAllRegulars == this.fetchAllRegulars && otherCf.fetchAllStatics == this.fetchAllStatics && Objects.equals(otherCf.fetched, this.fetched) && Objects.equals(otherCf.queried, this.queried) && Objects.equals(otherCf.subSelections, this.subSelections);
    }

    public String toString() {
        String prefix = "";
        if (this.fetchAllRegulars && this.queried == null) {
            return "*/*";
        }
        if (this.fetchAllRegulars && this.fetchAllStatics) {
            prefix = "*/";
        }
        if (this.fetchAllRegulars && !this.fetchAllStatics) {
            prefix = this.queried.statics.isEmpty() ? "<all regulars>/" : String.format("<all regulars>+%s/", this.toString(this.queried.statics.selectOrderIterator(), false));
        }
        return prefix + this.toString(this.queried.selectOrderIterator(), false);
    }

    public String toCQLString() {
        if (this.queried == null || this.queried.isEmpty()) {
            return "*";
        }
        return this.toString(this.queried.selectOrderIterator(), true);
    }

    private String toString(Iterator<ColumnMetadata> columns, boolean cql) {
        StringJoiner joiner;
        StringJoiner stringJoiner = joiner = cql ? new StringJoiner(", ") : new StringJoiner(", ", "[", "]");
        while (columns.hasNext()) {
            SortedSet s;
            ColumnMetadata column = columns.next();
            String columnName = cql ? column.name.toCQLString() : String.valueOf(column.name);
            SortedSet sortedSet = s = this.subSelections != null ? this.subSelections.get((Object)column.name) : Collections.emptySortedSet();
            if (s.isEmpty()) {
                joiner.add(columnName);
                continue;
            }
            s.forEach(subSel -> joiner.add(String.format("%s%s", columnName, subSel)));
        }
        return joiner.toString();
    }

    public static class Serializer {
        private static final int FETCH_ALL_MASK = 1;
        private static final int HAS_QUERIED_MASK = 2;
        private static final int HAS_SUB_SELECTIONS_MASK = 4;

        private static int makeHeaderByte(ColumnFilter selection) {
            return (selection.fetchAllRegulars ? 1 : 0) | (selection.queried != null ? 2 : 0) | (selection.subSelections != null ? 4 : 0);
        }

        public void serialize(ColumnFilter selection, DataOutputPlus out, int version) throws IOException {
            out.writeByte(Serializer.makeHeaderByte(selection));
            if (version >= 11 && selection.fetchAllRegulars) {
                Columns.serializer.serialize(selection.fetched.statics, out);
                Columns.serializer.serialize(selection.fetched.regulars, out);
            }
            if (selection.queried != null) {
                Columns.serializer.serialize(((ColumnFilter)selection).queried.statics, out);
                Columns.serializer.serialize(((ColumnFilter)selection).queried.regulars, out);
            }
            if (selection.subSelections != null) {
                out.writeUnsignedVInt(selection.subSelections.size());
                for (ColumnSubselection subSel : selection.subSelections.values()) {
                    ColumnSubselection.serializer.serialize(subSel, out, version);
                }
            }
        }

        public ColumnFilter deserialize(DataInputPlus in, int version, TableMetadata metadata) throws IOException {
            Columns regulars;
            Columns statics;
            int header = in.readUnsignedByte();
            boolean isFetchAll = (header & 1) != 0;
            boolean hasQueried = (header & 2) != 0;
            boolean hasSubSelections = (header & 4) != 0;
            RegularAndStaticColumns fetched = null;
            RegularAndStaticColumns queried = null;
            if (isFetchAll) {
                if (version >= 11) {
                    statics = Columns.serializer.deserializeStatics(in, metadata);
                    regulars = Columns.serializer.deserializeRegulars(in, metadata);
                    fetched = new RegularAndStaticColumns(statics, regulars);
                } else {
                    fetched = metadata.regularAndStaticColumns();
                }
            }
            if (hasQueried) {
                statics = Columns.serializer.deserializeStatics(in, metadata);
                regulars = Columns.serializer.deserializeRegulars(in, metadata);
                queried = new RegularAndStaticColumns(statics, regulars);
            }
            TreeMultimap subSelections = null;
            if (hasSubSelections) {
                subSelections = TreeMultimap.create(Comparator.naturalOrder(), Comparator.naturalOrder());
                int size = (int)in.readUnsignedVInt();
                for (int i = 0; i < size; ++i) {
                    ColumnSubselection subSel = ColumnSubselection.serializer.deserialize(in, version, metadata);
                    subSelections.put((Object)subSel.column().name, (Object)subSel);
                }
            }
            return new ColumnFilter(isFetchAll, isFetchAll && ColumnFilter.shouldFetchAllStatics(), fetched, (RegularAndStaticColumns)(isFetchAll && ColumnFilter.shouldQueriedBeNull() ? null : queried), (SortedSetMultimap)subSelections);
        }

        public long serializedSize(ColumnFilter selection, int version) {
            long size = 1L;
            if (version >= 11 && selection.fetchAllRegulars) {
                size += Columns.serializer.serializedSize(selection.fetched.statics);
                size += Columns.serializer.serializedSize(selection.fetched.regulars);
            }
            if (selection.queried != null) {
                size += Columns.serializer.serializedSize(((ColumnFilter)selection).queried.statics);
                size += Columns.serializer.serializedSize(((ColumnFilter)selection).queried.regulars);
            }
            if (selection.subSelections != null) {
                size += (long)TypeSizes.sizeofUnsignedVInt(selection.subSelections.size());
                for (ColumnSubselection subSel : selection.subSelections.values()) {
                    size += ColumnSubselection.serializer.serializedSize(subSel, version);
                }
            }
            return size;
        }
    }

    public static class Builder {
        private final TableMetadata metadata;
        private RegularAndStaticColumns.Builder queriedBuilder;
        private List<ColumnSubselection> subSelections;
        private Set<ColumnMetadata> fullySelectedComplexColumns;

        private Builder(TableMetadata metadata) {
            this.metadata = metadata;
        }

        public Builder add(ColumnMetadata c) {
            if (c.isComplex() && c.type.isMultiCell()) {
                if (this.fullySelectedComplexColumns == null) {
                    this.fullySelectedComplexColumns = new HashSet<ColumnMetadata>();
                }
                this.fullySelectedComplexColumns.add(c);
            }
            return this.addInternal(c);
        }

        public Builder addAll(Iterable<ColumnMetadata> columns) {
            for (ColumnMetadata column : columns) {
                this.add(column);
            }
            return this;
        }

        private Builder addInternal(ColumnMetadata c) {
            if (c.isPrimaryKeyColumn()) {
                return this;
            }
            if (this.queriedBuilder == null) {
                this.queriedBuilder = RegularAndStaticColumns.builder();
            }
            this.queriedBuilder.add(c);
            return this;
        }

        private Builder addSubSelection(ColumnSubselection subSelection) {
            ColumnMetadata column = subSelection.column();
            assert (column.isComplex() && column.type.isMultiCell());
            this.addInternal(column);
            if (this.subSelections == null) {
                this.subSelections = new ArrayList<ColumnSubselection>();
            }
            this.subSelections.add(subSelection);
            return this;
        }

        public Builder slice(ColumnMetadata c, CellPath from, CellPath to) {
            return this.addSubSelection(ColumnSubselection.slice(c, from, to));
        }

        public Builder select(ColumnMetadata c, CellPath elt) {
            return this.addSubSelection(ColumnSubselection.element(c, elt));
        }

        public ColumnFilter build() {
            RegularAndStaticColumns queried;
            boolean isFetchAll = this.metadata != null;
            RegularAndStaticColumns regularAndStaticColumns = queried = this.queriedBuilder == null ? null : this.queriedBuilder.build();
            if (!isFetchAll && queried == null) {
                queried = RegularAndStaticColumns.NONE;
            }
            TreeMultimap s = null;
            if (this.subSelections != null) {
                s = TreeMultimap.create(Comparator.naturalOrder(), Comparator.naturalOrder());
                for (ColumnSubselection subSelection : this.subSelections) {
                    if (this.fullySelectedComplexColumns != null && this.fullySelectedComplexColumns.contains(subSelection.column())) continue;
                    s.put((Object)subSelection.column().name, (Object)subSelection);
                }
            }
            return new ColumnFilter(isFetchAll, isFetchAll && ColumnFilter.shouldFetchAllStatics(), this.metadata, (RegularAndStaticColumns)(isFetchAll && ColumnFilter.shouldQueriedBeNull() ? null : queried), (SortedSetMultimap)s);
        }
    }

    public static class Tester {
        private final boolean isFetched;
        private ColumnSubselection current;
        private final Iterator<ColumnSubselection> iterator;

        private Tester(boolean isFetched, Iterator<ColumnSubselection> iterator) {
            this.isFetched = isFetched;
            this.iterator = iterator;
        }

        public boolean fetches(CellPath path) {
            return this.isFetched || this.hasSubselection(path);
        }

        public boolean fetchedCellIsQueried(CellPath path) {
            return !this.isFetched || this.hasSubselection(path);
        }

        private boolean hasSubselection(CellPath path) {
            while (this.current != null || this.iterator.hasNext()) {
                int cmp;
                if (this.current == null) {
                    this.current = this.iterator.next();
                }
                if ((cmp = this.current.compareInclusionOf(path)) == 0) {
                    return true;
                }
                if (cmp < 0) {
                    return false;
                }
                this.current = null;
            }
            return false;
        }
    }
}

