/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import javax.annotation.Nullable;
import org.apache.cassandra.exceptions.UnknownTableException;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;

public interface TableMetadataProvider {
    @Nullable
    public TableMetadata getTableMetadata(TableId var1);

    default public TableMetadata getExistingTableMetadata(TableId id) throws UnknownTableException {
        TableMetadata metadata = this.getTableMetadata(id);
        if (metadata != null) {
            return metadata;
        }
        String message = String.format("Couldn't find table with id %s. If a table was just created, this is likely due to the schemanot being fully propagated.  Please wait for schema agreement on table creation.", id);
        throw new UnknownTableException(message, id);
    }
}

