/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseNotifier;
import io.netty.util.concurrent.SucceededFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.net.AsyncPromise;
import org.apache.cassandra.net.FutureCombiner;
import org.apache.cassandra.net.InboundConnectionInitiator;
import org.apache.cassandra.net.InboundConnectionSettings;
import org.apache.cassandra.utils.FBUtilities;

class InboundSockets {
    private final List<InboundSocket> sockets;

    InboundSockets(InboundConnectionSettings template) {
        this(InboundSockets.withDefaultBindAddresses(template));
    }

    InboundSockets(List<InboundConnectionSettings> templates) {
        this.sockets = InboundSockets.bindings(templates);
    }

    private static List<InboundConnectionSettings> withDefaultBindAddresses(InboundConnectionSettings template) {
        ImmutableList.Builder templates = ImmutableList.builder();
        templates.add((Object)template.withBindAddress(FBUtilities.getLocalAddressAndPort()));
        if (InboundSockets.shouldListenOnBroadcastAddress()) {
            templates.add((Object)template.withBindAddress(FBUtilities.getBroadcastAddressAndPort()));
        }
        return templates.build();
    }

    private static List<InboundSocket> bindings(List<InboundConnectionSettings> templates) {
        ImmutableList.Builder sockets = ImmutableList.builder();
        for (InboundConnectionSettings template : templates) {
            InboundSockets.addBindings(template, (ImmutableList.Builder<InboundSocket>)sockets);
        }
        return sockets.build();
    }

    private static void addBindings(InboundConnectionSettings template, ImmutableList.Builder<InboundSocket> out) {
        InboundConnectionSettings settings = template.withDefaults();
        InboundConnectionSettings legacySettings = template.withLegacyDefaults();
        if (settings.encryption.enable_legacy_ssl_storage_port) {
            out.add((Object)new InboundSocket(legacySettings));
            if (settings.bindAddress.equals(legacySettings.bindAddress)) {
                return;
            }
        }
        out.add((Object)new InboundSocket(settings));
    }

    public Future<Void> open(Consumer<ChannelPipeline> pipelineInjector) {
        ArrayList<Future> opening = new ArrayList<Future>();
        for (InboundSocket socket : this.sockets) {
            opening.add(socket.open(pipelineInjector));
        }
        return new FutureCombiner(opening);
    }

    public Future<Void> open() {
        ArrayList<Future> opening = new ArrayList<Future>();
        for (InboundSocket socket : this.sockets) {
            opening.add(socket.open());
        }
        return new FutureCombiner(opening);
    }

    public boolean isListening() {
        for (InboundSocket socket : this.sockets) {
            if (!socket.isOpen()) continue;
            return true;
        }
        return false;
    }

    public Future<Void> close(Consumer<? super ExecutorService> shutdownExecutors) {
        ArrayList<Future> closing = new ArrayList<Future>();
        for (InboundSocket address : this.sockets) {
            closing.add(address.close(shutdownExecutors));
        }
        return new FutureCombiner(closing);
    }

    public Future<Void> close() {
        return this.close(e -> {});
    }

    private static boolean shouldListenOnBroadcastAddress() {
        return DatabaseDescriptor.shouldListenOnBroadcastAddress() && !FBUtilities.getLocalAddressAndPort().equals(FBUtilities.getBroadcastAddressAndPort());
    }

    @VisibleForTesting
    public List<InboundSocket> sockets() {
        return this.sockets;
    }

    @VisibleForTesting
    static class InboundSocket {
        public final InboundConnectionSettings settings;
        private volatile Channel listen;
        private volatile ChannelFuture binding;
        private boolean closedWithoutOpening;
        private final ChannelGroup connections;
        private final DefaultEventExecutor executor;

        private InboundSocket(InboundConnectionSettings settings) {
            this.settings = settings;
            this.executor = new DefaultEventExecutor((ThreadFactory)new NamedThreadFactory("Listen-" + settings.bindAddress));
            this.connections = new DefaultChannelGroup(settings.bindAddress.toString(), (EventExecutor)this.executor);
        }

        private Future<Void> open() {
            return this.open(pipeline -> {});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Future<Void> open(Consumer<ChannelPipeline> pipelineInjector) {
            InboundSocket inboundSocket = this;
            synchronized (inboundSocket) {
                if (this.listen != null) {
                    return new SucceededFuture((EventExecutor)GlobalEventExecutor.INSTANCE, null);
                }
                if (this.binding != null) {
                    return this.binding;
                }
                if (this.closedWithoutOpening) {
                    throw new IllegalStateException();
                }
                this.binding = InboundConnectionInitiator.bind(this.settings, this.connections, pipelineInjector);
            }
            return this.binding.addListener(ignore -> {
                InboundSocket inboundSocket = this;
                synchronized (inboundSocket) {
                    if (this.binding.isSuccess()) {
                        this.listen = this.binding.channel();
                    }
                    this.binding = null;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Future<Void> close(Consumer<? super ExecutorService> shutdownExecutors) {
            AsyncPromise done = AsyncPromise.uncancellable((EventExecutor)GlobalEventExecutor.INSTANCE);
            Runnable close = () -> {
                ArrayList<Object> closing = new ArrayList<Object>();
                if (this.listen != null) {
                    closing.add(this.listen.close());
                }
                closing.add(this.connections.close());
                new FutureCombiner(closing).addListener(future -> {
                    this.executor.shutdownGracefully();
                    shutdownExecutors.accept((ExecutorService)this.executor);
                }).addListener((GenericFutureListener)new PromiseNotifier(new Promise[]{done}));
            };
            InboundSocket inboundSocket = this;
            synchronized (inboundSocket) {
                if (this.listen == null && this.binding == null) {
                    this.closedWithoutOpening = true;
                    return new SucceededFuture((EventExecutor)GlobalEventExecutor.INSTANCE, null);
                }
                if (this.listen != null) {
                    close.run();
                } else {
                    this.binding.cancel(true);
                    this.binding.addListener(future -> close.run());
                }
                return done;
            }
        }

        public boolean isOpen() {
            return this.listen != null && this.listen.isOpen();
        }
    }
}

