/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht.tokenallocator;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.dht.tokenallocator.ReplicationStrategy;
import org.apache.cassandra.dht.tokenallocator.TokenAllocator;
import org.apache.cassandra.dht.tokenallocator.TokenAllocatorFactory;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.NetworkTopologyStrategy;
import org.apache.cassandra.locator.SimpleStrategy;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAllocation {
    private static final Logger logger = LoggerFactory.getLogger(TokenAllocation.class);

    public static Collection<Token> allocateTokens(TokenMetadata tokenMetadata, AbstractReplicationStrategy rs, InetAddressAndPort endpoint, int numTokens) {
        TokenMetadata tokenMetadataCopy = tokenMetadata.cloneOnlyTokenMap();
        StrategyAdapter strategy = TokenAllocation.getStrategy(tokenMetadataCopy, rs, endpoint);
        Collection<Token> tokens = TokenAllocation.create(tokenMetadata, strategy).addUnit(endpoint, numTokens);
        tokens = TokenAllocation.adjustForCrossDatacenterClashes(tokenMetadata, strategy, tokens);
        if (logger.isWarnEnabled()) {
            logger.warn("Selected tokens {}", tokens);
            SummaryStatistics os = TokenAllocation.replicatedOwnershipStats(tokenMetadataCopy, rs, endpoint);
            tokenMetadataCopy.updateNormalTokens(tokens, endpoint);
            SummaryStatistics ns = TokenAllocation.replicatedOwnershipStats(tokenMetadataCopy, rs, endpoint);
            logger.warn("Replicated node load in datacenter before allocation {}", (Object)TokenAllocation.statToString(os));
            logger.warn("Replicated node load in datacenter after allocation {}", (Object)TokenAllocation.statToString(ns));
            if (ns.getStandardDeviation() > os.getStandardDeviation()) {
                logger.warn("Unexpected growth in standard deviation after allocation.");
            }
        }
        return tokens;
    }

    public static Collection<Token> allocateTokens(TokenMetadata tokenMetadata, int replicas, InetAddressAndPort endpoint, int numTokens) {
        TokenMetadata tokenMetadataCopy = tokenMetadata.cloneOnlyTokenMap();
        StrategyAdapter strategy = TokenAllocation.getStrategy(tokenMetadataCopy, replicas, endpoint);
        Collection<Token> tokens = TokenAllocation.create(tokenMetadata, strategy).addUnit(endpoint, numTokens);
        tokens = TokenAllocation.adjustForCrossDatacenterClashes(tokenMetadata, strategy, tokens);
        logger.warn("Selected tokens {}", tokens);
        return tokens;
    }

    private static Collection<Token> adjustForCrossDatacenterClashes(TokenMetadata tokenMetadata, StrategyAdapter strategy, Collection<Token> tokens) {
        ArrayList filtered = Lists.newArrayListWithCapacity((int)tokens.size());
        for (Token t : tokens) {
            while (tokenMetadata.getEndpoint(t) != null) {
                InetAddressAndPort other = tokenMetadata.getEndpoint(t);
                if (strategy.inAllocationRing(other)) {
                    throw new ConfigurationException(String.format("Allocated token %s already assigned to node %s. Is another node also allocating tokens?", t, other));
                }
                t = t.increaseSlightly();
            }
            filtered.add(t);
        }
        return filtered;
    }

    public static Map<InetAddressAndPort, Double> evaluateReplicatedOwnership(TokenMetadata tokenMetadata, AbstractReplicationStrategy rs) {
        HashMap ownership = Maps.newHashMap();
        ArrayList<Token> sortedTokens = tokenMetadata.sortedTokens();
        Iterator it = sortedTokens.iterator();
        Token current = (Token)it.next();
        while (it.hasNext()) {
            Token next = (Token)it.next();
            TokenAllocation.addOwnership(tokenMetadata, rs, current, next, ownership);
            current = next;
        }
        TokenAllocation.addOwnership(tokenMetadata, rs, current, (Token)sortedTokens.get(0), ownership);
        return ownership;
    }

    static void addOwnership(TokenMetadata tokenMetadata, AbstractReplicationStrategy rs, Token current, Token next, Map<InetAddressAndPort, Double> ownership) {
        double size = current.size(next);
        Token representative = current.getPartitioner().midpoint(current, next);
        Iterator<InetAddressAndPort> iterator = rs.calculateNaturalReplicas(representative, tokenMetadata).endpoints().iterator();
        while (iterator.hasNext()) {
            InetAddressAndPort n;
            Double v = ownership.get(n = iterator.next());
            ownership.put(n, v != null ? v + size : size);
        }
    }

    public static String statToString(SummaryStatistics stat) {
        return String.format("max %.2f min %.2f stddev %.4f", stat.getMax() / stat.getMean(), stat.getMin() / stat.getMean(), stat.getStandardDeviation());
    }

    public static SummaryStatistics replicatedOwnershipStats(TokenMetadata tokenMetadata, AbstractReplicationStrategy rs, InetAddressAndPort endpoint) {
        SummaryStatistics stat = new SummaryStatistics();
        StrategyAdapter strategy = TokenAllocation.getStrategy(tokenMetadata, rs, endpoint);
        for (Map.Entry<InetAddressAndPort, Double> en : TokenAllocation.evaluateReplicatedOwnership(tokenMetadata, rs).entrySet()) {
            if (!strategy.inAllocationRing(en.getKey())) continue;
            stat.addValue(en.getValue() / (double)tokenMetadata.getTokens(en.getKey()).size());
        }
        return stat;
    }

    static TokenAllocator<InetAddressAndPort> create(TokenMetadata tokenMetadata, StrategyAdapter strategy) {
        TreeMap<Token, InetAddressAndPort> sortedTokens = new TreeMap<Token, InetAddressAndPort>();
        for (Map.Entry<Token, InetAddressAndPort> en : tokenMetadata.getNormalAndBootstrappingTokenToEndpointMap().entrySet()) {
            if (!strategy.inAllocationRing(en.getValue())) continue;
            sortedTokens.put(en.getKey(), en.getValue());
        }
        return TokenAllocatorFactory.createTokenAllocator(sortedTokens, strategy, tokenMetadata.partitioner);
    }

    static StrategyAdapter getStrategy(TokenMetadata tokenMetadata, AbstractReplicationStrategy rs, InetAddressAndPort endpoint) {
        if (rs instanceof NetworkTopologyStrategy) {
            return TokenAllocation.getStrategy(tokenMetadata, (NetworkTopologyStrategy)rs, rs.snitch, endpoint);
        }
        if (rs instanceof SimpleStrategy) {
            return TokenAllocation.getStrategy(tokenMetadata, (SimpleStrategy)rs, endpoint);
        }
        throw new ConfigurationException("Token allocation does not support replication strategy " + rs.getClass().getSimpleName());
    }

    static StrategyAdapter getStrategy(TokenMetadata tokenMetadata, SimpleStrategy rs, InetAddressAndPort endpoint) {
        final int replicas = rs.getReplicationFactor().allReplicas;
        return new StrategyAdapter(){

            @Override
            public int replicas() {
                return replicas;
            }

            @Override
            public Object getGroup(InetAddressAndPort unit) {
                return unit;
            }

            @Override
            public boolean inAllocationRing(InetAddressAndPort other) {
                return true;
            }
        };
    }

    static StrategyAdapter getStrategy(TokenMetadata tokenMetadata, NetworkTopologyStrategy rs, IEndpointSnitch snitch, InetAddressAndPort endpoint) {
        String dc = snitch.getDatacenter(endpoint);
        int replicas = rs.getReplicationFactor((String)dc).allReplicas;
        return TokenAllocation.getStrategy(tokenMetadata, replicas, snitch, endpoint);
    }

    static StrategyAdapter getStrategy(TokenMetadata tokenMetadata, int replicas, InetAddressAndPort endpoint) {
        return TokenAllocation.getStrategy(tokenMetadata, replicas, DatabaseDescriptor.getEndpointSnitch(), endpoint);
    }

    static StrategyAdapter getStrategy(TokenMetadata tokenMetadata, final int replicas, final IEndpointSnitch snitch, InetAddressAndPort endpoint) {
        int racks;
        final String dc = snitch.getDatacenter(endpoint);
        if (replicas == 0 || replicas == 1) {
            return new StrategyAdapter(){

                @Override
                public int replicas() {
                    return 1;
                }

                @Override
                public Object getGroup(InetAddressAndPort unit) {
                    return unit;
                }

                @Override
                public boolean inAllocationRing(InetAddressAndPort other) {
                    return dc.equals(snitch.getDatacenter(other));
                }
            };
        }
        TokenMetadata.Topology topology = tokenMetadata.getTopology();
        int n = racks = topology.getDatacenterRacks().get((Object)dc) != null && ((ImmutableMultimap)topology.getDatacenterRacks().get((Object)dc)).containsKey((Object)snitch.getRack(endpoint)) ? ((ImmutableMultimap)topology.getDatacenterRacks().get((Object)dc)).asMap().size() : 1;
        if (racks > replicas) {
            return new StrategyAdapter(){

                @Override
                public int replicas() {
                    return replicas;
                }

                @Override
                public Object getGroup(InetAddressAndPort unit) {
                    return snitch.getRack(unit);
                }

                @Override
                public boolean inAllocationRing(InetAddressAndPort other) {
                    return dc.equals(snitch.getDatacenter(other));
                }
            };
        }
        if (racks == replicas) {
            final String rack = snitch.getRack(endpoint);
            return new StrategyAdapter(){

                @Override
                public int replicas() {
                    return 1;
                }

                @Override
                public Object getGroup(InetAddressAndPort unit) {
                    return unit;
                }

                @Override
                public boolean inAllocationRing(InetAddressAndPort other) {
                    return dc.equals(snitch.getDatacenter(other)) && rack.equals(snitch.getRack(other));
                }
            };
        }
        if (racks == 1) {
            return new StrategyAdapter(){

                @Override
                public int replicas() {
                    return replicas;
                }

                @Override
                public Object getGroup(InetAddressAndPort unit) {
                    return unit;
                }

                @Override
                public boolean inAllocationRing(InetAddressAndPort other) {
                    return dc.equals(snitch.getDatacenter(other));
                }
            };
        }
        throw new ConfigurationException(String.format("Token allocation failed: the number of racks %d in datacenter %s is lower than its replication factor %d.", racks, dc, replicas));
    }

    static interface StrategyAdapter
    extends ReplicationStrategy<InetAddressAndPort> {
        public boolean inAllocationRing(InetAddressAndPort var1);
    }
}

