/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.SinglePartitionReadQuery;
import org.apache.cassandra.db.VirtualTableReadQuery;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterators;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.virtual.VirtualKeyspaceRegistry;
import org.apache.cassandra.db.virtual.VirtualTable;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ClientState;

public class VirtualTableSinglePartitionReadQuery
extends VirtualTableReadQuery
implements SinglePartitionReadQuery {
    private final DecoratedKey partitionKey;
    private final ClusteringIndexFilter clusteringIndexFilter;

    public static VirtualTableSinglePartitionReadQuery create(TableMetadata metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DecoratedKey partitionKey, ClusteringIndexFilter clusteringIndexFilter) {
        return new VirtualTableSinglePartitionReadQuery(metadata, nowInSec, columnFilter, rowFilter, limits, partitionKey, clusteringIndexFilter);
    }

    private VirtualTableSinglePartitionReadQuery(TableMetadata metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DecoratedKey partitionKey, ClusteringIndexFilter clusteringIndexFilter) {
        super(metadata, nowInSec, columnFilter, rowFilter, limits);
        this.partitionKey = partitionKey;
        this.clusteringIndexFilter = clusteringIndexFilter;
    }

    @Override
    protected void appendCQLWhereClause(StringBuilder sb) {
        String filterString;
        sb.append(" WHERE ");
        sb.append(ColumnMetadata.toCQLString(this.metadata().partitionKeyColumns())).append(" = ");
        DataRange.appendKeyString(sb, this.metadata().partitionKeyType, this.partitionKey().getKey());
        if (!this.rowFilter().isEmpty()) {
            sb.append(" AND ").append(this.rowFilter());
        }
        if (!(filterString = this.clusteringIndexFilter().toCQLString(this.metadata())).isEmpty()) {
            sb.append(" AND ").append(filterString);
        }
    }

    @Override
    public ClusteringIndexFilter clusteringIndexFilter() {
        return this.clusteringIndexFilter;
    }

    @Override
    public boolean selectsFullPartition() {
        return this.clusteringIndexFilter.selectsAllPartition() && !this.rowFilter().hasExpressionOnClusteringOrRegularColumns();
    }

    @Override
    public DecoratedKey partitionKey() {
        return this.partitionKey;
    }

    @Override
    public SinglePartitionReadQuery withUpdatedLimit(DataLimits newLimits) {
        return new VirtualTableSinglePartitionReadQuery(this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), newLimits, this.partitionKey(), this.clusteringIndexFilter);
    }

    @Override
    public SinglePartitionReadQuery forPaging(Clustering lastReturned, DataLimits limits) {
        return new VirtualTableSinglePartitionReadQuery(this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), limits, this.partitionKey(), lastReturned == null ? this.clusteringIndexFilter : this.clusteringIndexFilter.forPaging(this.metadata().comparator, lastReturned, false));
    }

    @Override
    protected UnfilteredPartitionIterator queryVirtualTable() {
        VirtualTable view = VirtualKeyspaceRegistry.instance.getTableNullable(this.metadata().id);
        return view.select(this.partitionKey, this.clusteringIndexFilter, this.columnFilter());
    }

    public static class Group
    extends SinglePartitionReadQuery.Group<VirtualTableSinglePartitionReadQuery> {
        public static Group create(TableMetadata metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, List<DecoratedKey> partitionKeys, ClusteringIndexFilter clusteringIndexFilter) {
            ArrayList<VirtualTableSinglePartitionReadQuery> queries = new ArrayList<VirtualTableSinglePartitionReadQuery>(partitionKeys.size());
            for (DecoratedKey partitionKey : partitionKeys) {
                queries.add(VirtualTableSinglePartitionReadQuery.create(metadata, nowInSec, columnFilter, rowFilter, limits, partitionKey, clusteringIndexFilter));
            }
            return new Group((List<VirtualTableSinglePartitionReadQuery>)queries, limits);
        }

        public Group(List<VirtualTableSinglePartitionReadQuery> queries, DataLimits limits) {
            super(queries, limits);
        }

        public static Group one(VirtualTableSinglePartitionReadQuery query) {
            return new Group(Collections.singletonList(query), query.limits());
        }

        @Override
        public PartitionIterator execute(ConsistencyLevel consistency, ClientState clientState, long queryStartNanoTime) throws RequestExecutionException {
            if (this.queries.size() == 1) {
                return ((VirtualTableSinglePartitionReadQuery)this.queries.get(0)).execute(consistency, clientState, queryStartNanoTime);
            }
            return PartitionIterators.concat(this.queries.stream().map(q -> q.execute(consistency, clientState, queryStartNanoTime)).collect(Collectors.toList()));
        }
    }
}

