/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemKeyspaceMigrator40 {
    static final String legacyPeersName = String.format("%s.%s", "system", "peers");
    static final String peersName = String.format("%s.%s", "system", "peers_v2");
    static final String legacyPeerEventsName = String.format("%s.%s", "system", "peer_events");
    static final String peerEventsName = String.format("%s.%s", "system", "peer_events_v2");
    static final String legacyTransferredRangesName = String.format("%s.%s", "system", "transferred_ranges");
    static final String transferredRangesName = String.format("%s.%s", "system", "transferred_ranges_v2");
    static final String legacyAvailableRangesName = String.format("%s.%s", "system", "available_ranges");
    static final String availableRangesName = String.format("%s.%s", "system", "available_ranges_v2");
    private static final Logger logger = LoggerFactory.getLogger(SystemKeyspaceMigrator40.class);

    private SystemKeyspaceMigrator40() {
    }

    public static void migrate() {
        SystemKeyspaceMigrator40.migratePeers();
        SystemKeyspaceMigrator40.migratePeerEvents();
        SystemKeyspaceMigrator40.migrateTransferredRanges();
        SystemKeyspaceMigrator40.migrateAvailableRanges();
    }

    private static void migratePeers() {
        ColumnFamilyStore newPeers = Keyspace.open("system").getColumnFamilyStore("peers_v2");
        if (!newPeers.isEmpty()) {
            return;
        }
        logger.info("{} table was empty, migrating legacy {}, if this fails you should fix the issue and then truncate {} to have it try again.", new Object[]{peersName, legacyPeersName, peersName});
        String query = String.format("SELECT * FROM %s", legacyPeersName);
        String insert = String.format("INSERT INTO %s ( peer, peer_port, data_center, host_id, preferred_ip, preferred_port, rack, release_version, native_address, native_port, schema_version, tokens)  values ( ?, ?, ? , ? , ?, ?, ?, ?, ?, ?, ?, ?)", peersName);
        UntypedResultSet rows = QueryProcessor.executeInternalWithPaging(query, 1000, new Object[0]);
        int transferred = 0;
        logger.info("Migrating rows from legacy {} to {}", (Object)legacyPeersName, (Object)peersName);
        for (UntypedResultSet.Row row : rows) {
            logger.debug("Transferring row {}", (Object)transferred);
            QueryProcessor.executeInternal(insert, row.has("peer") ? row.getInetAddress("peer") : null, DatabaseDescriptor.getStoragePort(), row.has("data_center") ? row.getString("data_center") : null, row.has("host_id") ? row.getUUID("host_id") : null, row.has("preferred_ip") ? row.getInetAddress("preferred_ip") : null, DatabaseDescriptor.getStoragePort(), row.has("rack") ? row.getString("rack") : null, row.has("release_version") ? row.getString("release_version") : null, row.has("rpc_address") ? row.getInetAddress("rpc_address") : null, DatabaseDescriptor.getNativeTransportPort(), row.has("schema_version") ? row.getUUID("schema_version") : null, row.has("tokens") ? row.getSet("tokens", UTF8Type.instance) : null);
            ++transferred;
        }
        logger.info("Migrated {} rows from legacy {} to {}", new Object[]{transferred, legacyPeersName, peersName});
    }

    private static void migratePeerEvents() {
        ColumnFamilyStore newPeerEvents = Keyspace.open("system").getColumnFamilyStore("peer_events_v2");
        if (!newPeerEvents.isEmpty()) {
            return;
        }
        logger.info("{} table was empty, migrating legacy {} to {}", new Object[]{peerEventsName, legacyPeerEventsName, peerEventsName});
        String query = String.format("SELECT * FROM %s", legacyPeerEventsName);
        String insert = String.format("INSERT INTO %s ( peer, peer_port, hints_dropped)  values ( ?, ?, ? )", peerEventsName);
        UntypedResultSet rows = QueryProcessor.executeInternalWithPaging(query, 1000, new Object[0]);
        int transferred = 0;
        for (UntypedResultSet.Row row : rows) {
            logger.debug("Transferring row {}", (Object)transferred);
            QueryProcessor.executeInternal(insert, row.has("peer") ? row.getInetAddress("peer") : null, DatabaseDescriptor.getStoragePort(), row.has("hints_dropped") ? row.getMap("hints_dropped", UUIDType.instance, Int32Type.instance) : null);
            ++transferred;
        }
        logger.info("Migrated {} rows from legacy {} to {}", new Object[]{transferred, legacyPeerEventsName, peerEventsName});
    }

    static void migrateTransferredRanges() {
        ColumnFamilyStore newTransferredRanges = Keyspace.open("system").getColumnFamilyStore("transferred_ranges_v2");
        if (!newTransferredRanges.isEmpty()) {
            return;
        }
        logger.info("{} table was empty, migrating legacy {} to {}", new Object[]{transferredRangesName, legacyTransferredRangesName, transferredRangesName});
        String query = String.format("SELECT * FROM %s", legacyTransferredRangesName);
        String insert = String.format("INSERT INTO %s (operation, peer, peer_port, keyspace_name, ranges)  values ( ?, ?, ? , ?, ?)", transferredRangesName);
        UntypedResultSet rows = QueryProcessor.executeInternalWithPaging(query, 1000, new Object[0]);
        int transferred = 0;
        for (UntypedResultSet.Row row : rows) {
            logger.debug("Transferring row {}", (Object)transferred);
            QueryProcessor.executeInternal(insert, row.has("operation") ? row.getString("operation") : null, row.has("peer") ? row.getInetAddress("peer") : null, DatabaseDescriptor.getStoragePort(), row.has("keyspace_name") ? row.getString("keyspace_name") : null, row.has("ranges") ? row.getSet("ranges", BytesType.instance) : null);
            ++transferred;
        }
        logger.info("Migrated {} rows from legacy {} to {}", new Object[]{transferred, legacyTransferredRangesName, transferredRangesName});
    }

    static void migrateAvailableRanges() {
        ColumnFamilyStore newAvailableRanges = Keyspace.open("system").getColumnFamilyStore("available_ranges_v2");
        if (!newAvailableRanges.isEmpty()) {
            return;
        }
        logger.info("{} table was empty, migrating legacy {} to {}", new Object[]{availableRangesName, legacyAvailableRangesName, availableRangesName});
        String query = String.format("SELECT * FROM %s", legacyAvailableRangesName);
        String insert = String.format("INSERT INTO %s (keyspace_name, full_ranges, transient_ranges)  values ( ?, ?, ? )", availableRangesName);
        UntypedResultSet rows = QueryProcessor.executeInternalWithPaging(query, 1000, new Object[0]);
        int transferred = 0;
        for (UntypedResultSet.Row row : rows) {
            logger.debug("Transferring row {}", (Object)transferred);
            String keyspace = row.getString("keyspace_name");
            Set ranges = Optional.ofNullable(row.getSet("ranges", BytesType.instance)).orElse(Collections.emptySet());
            QueryProcessor.executeInternal(insert, keyspace, ranges, Collections.emptySet());
            ++transferred;
        }
        logger.info("Migrated {} rows from legacy {} to {}", new Object[]{transferred, legacyAvailableRangesName, availableRangesName});
    }
}

