/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.carrotsearch.hppc.ObjectIntHashMap;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.Endpoints;
import org.apache.cassandra.locator.NetworkTopologyStrategy;
import org.apache.cassandra.locator.Replicas;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.transport.ProtocolException;

public final class ConsistencyLevel
extends Enum<ConsistencyLevel> {
    public static final /* enum */ ConsistencyLevel ANY = new ConsistencyLevel(0);
    public static final /* enum */ ConsistencyLevel ONE = new ConsistencyLevel(1);
    public static final /* enum */ ConsistencyLevel TWO = new ConsistencyLevel(2);
    public static final /* enum */ ConsistencyLevel THREE = new ConsistencyLevel(3);
    public static final /* enum */ ConsistencyLevel QUORUM = new ConsistencyLevel(4);
    public static final /* enum */ ConsistencyLevel ALL = new ConsistencyLevel(5);
    public static final /* enum */ ConsistencyLevel LOCAL_QUORUM = new ConsistencyLevel(6, true);
    public static final /* enum */ ConsistencyLevel EACH_QUORUM = new ConsistencyLevel(7);
    public static final /* enum */ ConsistencyLevel SERIAL = new ConsistencyLevel(8);
    public static final /* enum */ ConsistencyLevel LOCAL_SERIAL = new ConsistencyLevel(9);
    public static final /* enum */ ConsistencyLevel LOCAL_ONE = new ConsistencyLevel(10, true);
    public static final /* enum */ ConsistencyLevel NODE_LOCAL = new ConsistencyLevel(11, true);
    public final int code;
    private final boolean isDCLocal;
    private static final ConsistencyLevel[] codeIdx;
    private static final /* synthetic */ ConsistencyLevel[] $VALUES;

    public static ConsistencyLevel[] values() {
        return (ConsistencyLevel[])$VALUES.clone();
    }

    public static ConsistencyLevel valueOf(String name) {
        return Enum.valueOf(ConsistencyLevel.class, name);
    }

    private ConsistencyLevel(int code) {
        this(code, false);
    }

    private ConsistencyLevel(int code, boolean isDCLocal) {
        this.code = code;
        this.isDCLocal = isDCLocal;
    }

    public static ConsistencyLevel fromCode(int code) {
        if (code < 0 || code >= codeIdx.length) {
            throw new ProtocolException(String.format("Unknown code %d for a consistency level", code));
        }
        return codeIdx[code];
    }

    public static int quorumFor(Keyspace keyspace) {
        return keyspace.getReplicationStrategy().getReplicationFactor().allReplicas / 2 + 1;
    }

    public static int localQuorumFor(Keyspace keyspace, String dc) {
        return keyspace.getReplicationStrategy() instanceof NetworkTopologyStrategy ? ((NetworkTopologyStrategy)keyspace.getReplicationStrategy()).getReplicationFactor((String)dc).allReplicas / 2 + 1 : ConsistencyLevel.quorumFor(keyspace);
    }

    public static int localQuorumForOurDc(Keyspace keyspace) {
        return ConsistencyLevel.localQuorumFor(keyspace, DatabaseDescriptor.getLocalDataCenter());
    }

    public static ObjectIntHashMap<String> eachQuorumForRead(Keyspace keyspace) {
        AbstractReplicationStrategy strategy = keyspace.getReplicationStrategy();
        if (strategy instanceof NetworkTopologyStrategy) {
            NetworkTopologyStrategy npStrategy = (NetworkTopologyStrategy)strategy;
            ObjectIntHashMap perDc = new ObjectIntHashMap((npStrategy.getDatacenters().size() + 1) * 4 / 3);
            for (String dc : npStrategy.getDatacenters()) {
                perDc.put((Object)dc, ConsistencyLevel.localQuorumFor(keyspace, dc));
            }
            return perDc;
        }
        ObjectIntHashMap perDc = new ObjectIntHashMap(1);
        perDc.put((Object)DatabaseDescriptor.getLocalDataCenter(), ConsistencyLevel.quorumFor(keyspace));
        return perDc;
    }

    public static ObjectIntHashMap<String> eachQuorumForWrite(Keyspace keyspace, Endpoints<?> pendingWithDown) {
        ObjectIntHashMap<String> perDc = ConsistencyLevel.eachQuorumForRead(keyspace);
        Replicas.addToCountPerDc(perDc, pendingWithDown, 1);
        return perDc;
    }

    public int blockFor(Keyspace keyspace) {
        switch (this) {
            case ONE: 
            case LOCAL_ONE: {
                return 1;
            }
            case ANY: {
                return 1;
            }
            case TWO: {
                return 2;
            }
            case THREE: {
                return 3;
            }
            case QUORUM: 
            case SERIAL: {
                return ConsistencyLevel.quorumFor(keyspace);
            }
            case ALL: {
                return keyspace.getReplicationStrategy().getReplicationFactor().allReplicas;
            }
            case LOCAL_QUORUM: 
            case LOCAL_SERIAL: {
                return ConsistencyLevel.localQuorumForOurDc(keyspace);
            }
            case EACH_QUORUM: {
                if (keyspace.getReplicationStrategy() instanceof NetworkTopologyStrategy) {
                    NetworkTopologyStrategy strategy = (NetworkTopologyStrategy)keyspace.getReplicationStrategy();
                    int n = 0;
                    for (String dc : strategy.getDatacenters()) {
                        n += ConsistencyLevel.localQuorumFor(keyspace, dc);
                    }
                    return n;
                }
                return ConsistencyLevel.quorumFor(keyspace);
            }
        }
        throw new UnsupportedOperationException("Invalid consistency level: " + this.toString());
    }

    public int blockForWrite(Keyspace keyspace, Endpoints<?> pending) {
        assert (pending != null);
        int blockFor = this.blockFor(keyspace);
        switch (this) {
            case ANY: {
                break;
            }
            case LOCAL_ONE: 
            case LOCAL_QUORUM: 
            case LOCAL_SERIAL: {
                blockFor += Replicas.countInOurDc(pending).allReplicas();
                break;
            }
            case ONE: 
            case TWO: 
            case THREE: 
            case QUORUM: 
            case SERIAL: 
            case ALL: 
            case EACH_QUORUM: {
                blockFor += pending.size();
            }
        }
        return blockFor;
    }

    public boolean satisfies(ConsistencyLevel other, Keyspace keyspace) {
        return this.blockFor(keyspace) >= other.blockFor(keyspace);
    }

    public boolean isDatacenterLocal() {
        return this.isDCLocal;
    }

    public void validateForRead(String keyspaceName) throws InvalidRequestException {
        switch (this) {
            case ANY: {
                throw new InvalidRequestException("ANY ConsistencyLevel is only supported for writes");
            }
        }
    }

    public void validateForWrite(String keyspaceName) throws InvalidRequestException {
        switch (this) {
            case SERIAL: 
            case LOCAL_SERIAL: {
                throw new InvalidRequestException("You must use conditional updates for serializable writes");
            }
        }
    }

    public void validateForCasCommit(String keyspaceName) throws InvalidRequestException {
        switch (this) {
            case EACH_QUORUM: {
                this.requireNetworkTopologyStrategy(keyspaceName);
                break;
            }
            case SERIAL: 
            case LOCAL_SERIAL: {
                throw new InvalidRequestException((Object)((Object)this) + " is not supported as conditional update commit consistency. Use ANY if you mean \"make sure it is accepted but I don't care how many replicas commit it for non-SERIAL reads\"");
            }
        }
    }

    public void validateForCas() throws InvalidRequestException {
        if (!this.isSerialConsistency()) {
            throw new InvalidRequestException("Invalid consistency for conditional update. Must be one of SERIAL or LOCAL_SERIAL");
        }
    }

    public boolean isSerialConsistency() {
        return this == SERIAL || this == LOCAL_SERIAL;
    }

    public void validateCounterForWrite(TableMetadata metadata) throws InvalidRequestException {
        if (this == ANY) {
            throw new InvalidRequestException("Consistency level ANY is not yet supported for counter table " + metadata.name);
        }
        if (this.isSerialConsistency()) {
            throw new InvalidRequestException("Counter operations are inherently non-serializable");
        }
    }

    private void requireNetworkTopologyStrategy(String keyspaceName) throws InvalidRequestException {
        AbstractReplicationStrategy strategy = Keyspace.open(keyspaceName).getReplicationStrategy();
        if (!(strategy instanceof NetworkTopologyStrategy)) {
            throw new InvalidRequestException(String.format("consistency level %s not compatible with replication strategy (%s)", new Object[]{this, strategy.getClass().getName()}));
        }
    }

    static {
        $VALUES = new ConsistencyLevel[]{ANY, ONE, TWO, THREE, QUORUM, ALL, LOCAL_QUORUM, EACH_QUORUM, SERIAL, LOCAL_SERIAL, LOCAL_ONE, NODE_LOCAL};
        int maxCode = -1;
        for (ConsistencyLevel cl : ConsistencyLevel.values()) {
            maxCode = Math.max(maxCode, cl.code);
        }
        codeIdx = new ConsistencyLevel[maxCode + 1];
        for (ConsistencyLevel cl : ConsistencyLevel.values()) {
            if (codeIdx[cl.code] != null) {
                throw new IllegalStateException("Duplicate code");
            }
            ConsistencyLevel.codeIdx[cl.code] = cl;
        }
    }
}

