/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringBoundOrBoundary;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class ClusteringBoundary
extends ClusteringBoundOrBoundary {
    protected ClusteringBoundary(ClusteringPrefix.Kind kind, ByteBuffer[] values) {
        super(kind, values);
    }

    @Override
    public ClusteringPrefix minimize() {
        if (!ByteBufferUtil.canMinimize(this.values)) {
            return this;
        }
        return new ClusteringBoundary(this.kind, ByteBufferUtil.minimizeBuffers(this.values));
    }

    public static ClusteringBoundary create(ClusteringPrefix.Kind kind, ByteBuffer[] values) {
        assert (kind.isBoundary());
        return new ClusteringBoundary(kind, values);
    }

    @Override
    public ClusteringBoundary invert() {
        return ClusteringBoundary.create(this.kind().invert(), this.values);
    }

    @Override
    public ClusteringBoundary copy(AbstractAllocator allocator) {
        return (ClusteringBoundary)super.copy(allocator);
    }

    public ClusteringBound openBound(boolean reversed) {
        return ClusteringBound.create(this.kind.openBoundOfBoundary(reversed), this.values);
    }

    public ClusteringBound closeBound(boolean reversed) {
        return ClusteringBound.create(this.kind.closeBoundOfBoundary(reversed), this.values);
    }
}

