/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.CQLFragmentParser;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.CqlParser;
import org.apache.cassandra.cql3.QualifiedName;
import org.apache.cassandra.cql3.statements.schema.AlterSchemaStatement;
import org.apache.cassandra.cql3.statements.schema.TableAttributes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.AlreadyExistsException;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.reads.repair.ReadRepairStrategy;
import org.apache.cassandra.transport.Event;

public final class CreateTableStatement
extends AlterSchemaStatement {
    private final String tableName;
    private final Map<ColumnIdentifier, CQL3Type.Raw> rawColumns;
    private final Set<ColumnIdentifier> staticColumns;
    private final List<ColumnIdentifier> partitionKeyColumns;
    private final List<ColumnIdentifier> clusteringColumns;
    private final LinkedHashMap<ColumnIdentifier, Boolean> clusteringOrder;
    private final TableAttributes attrs;
    private final boolean ifNotExists;

    public CreateTableStatement(String keyspaceName, String tableName, Map<ColumnIdentifier, CQL3Type.Raw> rawColumns, Set<ColumnIdentifier> staticColumns, List<ColumnIdentifier> partitionKeyColumns, List<ColumnIdentifier> clusteringColumns, LinkedHashMap<ColumnIdentifier, Boolean> clusteringOrder, TableAttributes attrs, boolean ifNotExists) {
        super(keyspaceName);
        this.tableName = tableName;
        this.rawColumns = rawColumns;
        this.staticColumns = staticColumns;
        this.partitionKeyColumns = partitionKeyColumns;
        this.clusteringColumns = clusteringColumns;
        this.clusteringOrder = clusteringOrder;
        this.attrs = attrs;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public Keyspaces apply(Keyspaces schema) {
        KeyspaceMetadata keyspace = schema.getNullable(this.keyspaceName);
        if (null == keyspace) {
            throw CreateTableStatement.ire("Keyspace '%s' doesn't exist", this.keyspaceName);
        }
        if (keyspace.hasTable(this.tableName)) {
            if (this.ifNotExists) {
                return schema;
            }
            throw new AlreadyExistsException(this.keyspaceName, this.tableName);
        }
        TableMetadata table = this.builder(keyspace.types).build();
        table.validate();
        if (keyspace.createReplicationStrategy().hasTransientReplicas() && table.params.readRepair != ReadRepairStrategy.NONE) {
            throw CreateTableStatement.ire("read_repair must be set to 'NONE' for transiently replicated keyspaces", new Object[0]);
        }
        return schema.withAddedOrUpdated(keyspace.withSwapped(keyspace.tables.with(table)));
    }

    @Override
    Event.SchemaChange schemaChangeEvent(Keyspaces.KeyspacesDiff diff) {
        return new Event.SchemaChange(Event.SchemaChange.Change.CREATED, Event.SchemaChange.Target.TABLE, this.keyspaceName, this.tableName);
    }

    @Override
    public void authorize(ClientState client) {
        client.ensureKeyspacePermission(this.keyspaceName, Permission.CREATE);
    }

    @Override
    Set<IResource> createdResources(Keyspaces.KeyspacesDiff diff) {
        return ImmutableSet.of((Object)DataResource.table(this.keyspaceName, this.tableName));
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.CREATE_TABLE, this.keyspaceName, this.tableName);
    }

    public String toString() {
        return String.format("%s (%s, %s)", this.getClass().getSimpleName(), this.keyspaceName, this.tableName);
    }

    public TableMetadata.Builder builder(Types types) {
        int i;
        this.attrs.validate();
        TableParams params = this.attrs.asNewTableParams();
        TreeMap<ColumnIdentifier, CQL3Type> columns = new TreeMap<ColumnIdentifier, CQL3Type>(Comparator.comparing(o -> o.bytes));
        this.rawColumns.forEach((column, type) -> columns.put((ColumnIdentifier)column, type.prepare(this.keyspaceName, types)));
        columns.forEach((column, type) -> {
            if (type.isUDT() && type.getType().isMultiCell()) {
                ((UserType)type.getType()).fieldTypes().forEach(field -> {
                    if (field.isMultiCell()) {
                        throw CreateTableStatement.ire("Non-frozen UDTs with nested non-frozen collections are not supported", new Object[0]);
                    }
                });
            }
        });
        HashSet primaryKeyColumns = new HashSet();
        Iterables.concat(this.partitionKeyColumns, this.clusteringColumns).forEach(column -> {
            CQL3Type type = (CQL3Type)columns.get(column);
            if (null == type) {
                throw CreateTableStatement.ire("Unknown column '%s' referenced in PRIMARY KEY for table '%s'", column, this.tableName);
            }
            if (!primaryKeyColumns.add(column)) {
                throw CreateTableStatement.ire("Duplicate column '%s' in PRIMARY KEY clause for table '%s'", column, this.tableName);
            }
            if (type.getType().isMultiCell()) {
                if (type.isCollection()) {
                    throw CreateTableStatement.ire("Invalid non-frozen collection type %s for PRIMARY KEY column '%s'", type, column);
                }
                throw CreateTableStatement.ire("Invalid non-frozen user-defined type %s for PRIMARY KEY column '%s'", type, column);
            }
            if (type.getType().isCounter()) {
                throw CreateTableStatement.ire("counter type is not supported for PRIMARY KEY column '%s'", column);
            }
            if (type.getType().referencesDuration()) {
                throw CreateTableStatement.ire("duration type is not supported for PRIMARY KEY column '%s'", column);
            }
            if (this.staticColumns.contains(column)) {
                throw CreateTableStatement.ire("Static column '%s' cannot be part of the PRIMARY KEY", column);
            }
        });
        ArrayList partitionKeyTypes = new ArrayList();
        ArrayList clusteringTypes = new ArrayList();
        this.partitionKeyColumns.forEach(column -> {
            CQL3Type type = (CQL3Type)columns.remove(column);
            partitionKeyTypes.add(type.getType());
        });
        this.clusteringColumns.forEach(column -> {
            CQL3Type type = (CQL3Type)columns.remove(column);
            boolean reverse = this.clusteringOrder.getOrDefault(column, true) == false;
            clusteringTypes.add(reverse ? ReversedType.getInstance(type.getType()) : type.getType());
        });
        if (this.clusteringOrder.size() > this.clusteringColumns.size()) {
            throw CreateTableStatement.ire("Only clustering columns can be defined in CLUSTERING ORDER directive", new Object[0]);
        }
        int n = 0;
        for (ColumnIdentifier id : this.clusteringOrder.keySet()) {
            ColumnIdentifier c;
            if (!id.equals(c = this.clusteringColumns.get(n))) {
                if (this.clusteringOrder.containsKey(c)) {
                    throw CreateTableStatement.ire("The order of columns in the CLUSTERING ORDER directive must match that of the clustering columns (%s must appear before %s)", c, id);
                }
                throw CreateTableStatement.ire("Missing CLUSTERING ORDER for column %s", c);
            }
            ++n;
        }
        if (this.clusteringColumns.isEmpty() && !this.staticColumns.isEmpty()) {
            throw CreateTableStatement.ire("Static columns are only useful (and thus allowed) if the table has at least one clustering column", new Object[0]);
        }
        boolean hasCounters = this.rawColumns.values().stream().anyMatch(CQL3Type.Raw::isCounter);
        if (hasCounters) {
            if (columns.values().stream().anyMatch(t -> !t.getType().isCounter())) {
                throw CreateTableStatement.ire("Cannot mix counter and non counter columns in the same table", new Object[0]);
            }
            if (params.defaultTimeToLive > 0) {
                throw CreateTableStatement.ire("Cannot set %s on a table with counters", new Object[]{TableParams.Option.DEFAULT_TIME_TO_LIVE});
            }
        }
        TableMetadata.Builder builder = TableMetadata.builder(this.keyspaceName, this.tableName);
        if (this.attrs.hasProperty("id").booleanValue()) {
            builder.id(this.attrs.getId());
        }
        builder.isCounter(hasCounters).params(params);
        for (i = 0; i < this.partitionKeyColumns.size(); ++i) {
            builder.addPartitionKeyColumn(this.partitionKeyColumns.get(i), (AbstractType)partitionKeyTypes.get(i));
        }
        for (i = 0; i < this.clusteringColumns.size(); ++i) {
            builder.addClusteringColumn(this.clusteringColumns.get(i), (AbstractType)clusteringTypes.get(i));
        }
        columns.forEach((column, type) -> {
            if (this.staticColumns.contains(column)) {
                builder.addStaticColumn((ColumnIdentifier)column, (AbstractType)type.getType());
            } else {
                builder.addRegularColumn((ColumnIdentifier)column, (AbstractType)type.getType());
            }
        });
        return builder;
    }

    public static TableMetadata.Builder parse(String cql, String keyspace) {
        return CQLFragmentParser.parseAny(CqlParser::createTableStatement, cql, "CREATE TABLE").keyspace(keyspace).prepare(null).builder(Types.none());
    }

    public static final class Raw
    extends CQLStatement.Raw {
        private final QualifiedName name;
        private final boolean ifNotExists;
        private final Map<ColumnIdentifier, CQL3Type.Raw> rawColumns = new HashMap<ColumnIdentifier, CQL3Type.Raw>();
        private final Set<ColumnIdentifier> staticColumns = new HashSet<ColumnIdentifier>();
        private final List<ColumnIdentifier> clusteringColumns = new ArrayList<ColumnIdentifier>();
        private List<ColumnIdentifier> partitionKeyColumns;
        private final LinkedHashMap<ColumnIdentifier, Boolean> clusteringOrder = new LinkedHashMap();
        public final TableAttributes attrs = new TableAttributes();

        public Raw(QualifiedName name, boolean ifNotExists) {
            this.name = name;
            this.ifNotExists = ifNotExists;
        }

        @Override
        public CreateTableStatement prepare(ClientState state) {
            String keyspaceName;
            String string = keyspaceName = this.name.hasKeyspace() ? this.name.getKeyspace() : state.getKeyspace();
            if (null == this.partitionKeyColumns) {
                throw AlterSchemaStatement.ire("No PRIMARY KEY specifed for table '%s' (exactly one required)", this.name);
            }
            return new CreateTableStatement(keyspaceName, this.name.getName(), this.rawColumns, this.staticColumns, this.partitionKeyColumns, this.clusteringColumns, this.clusteringOrder, this.attrs, this.ifNotExists);
        }

        public String keyspace() {
            return this.name.getKeyspace();
        }

        public Raw keyspace(String keyspace) {
            this.name.setKeyspace(keyspace, true);
            return this;
        }

        public String table() {
            return this.name.getName();
        }

        public void addColumn(ColumnIdentifier column, CQL3Type.Raw type, boolean isStatic) {
            if (null != this.rawColumns.put(column, type)) {
                throw AlterSchemaStatement.ire("Duplicate column '%s' declaration for table '%s'", column, this.name);
            }
            if (isStatic) {
                this.staticColumns.add(column);
            }
        }

        public void setPartitionKeyColumn(ColumnIdentifier column) {
            this.setPartitionKeyColumns(Collections.singletonList(column));
        }

        public void setPartitionKeyColumns(List<ColumnIdentifier> columns) {
            if (null != this.partitionKeyColumns) {
                throw AlterSchemaStatement.ire("Multiple PRIMARY KEY specified for table '%s' (exactly one required)", this.name);
            }
            this.partitionKeyColumns = columns;
        }

        public void markClusteringColumn(ColumnIdentifier column) {
            this.clusteringColumns.add(column);
        }

        public void extendClusteringOrder(ColumnIdentifier column, boolean ascending) {
            if (null != this.clusteringOrder.put(column, ascending)) {
                throw AlterSchemaStatement.ire("Duplicate column '%s' in CLUSTERING ORDER BY clause for table '%s'", column, this.name);
            }
        }
    }
}

