/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.cql3.statements.UpdatesCollector;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.virtual.VirtualMutation;
import org.apache.cassandra.schema.TableMetadata;

final class SingleTableUpdatesCollector
implements UpdatesCollector {
    private final TableMetadata metadata;
    private final RegularAndStaticColumns updatedColumns;
    private final int updatedRows;
    private final Map<ByteBuffer, PartitionUpdate.Builder> puBuilders = new HashMap<ByteBuffer, PartitionUpdate.Builder>();
    private ConsistencyLevel counterConsistencyLevel = null;

    SingleTableUpdatesCollector(TableMetadata metadata, RegularAndStaticColumns updatedColumns, int updatedRows) {
        this.metadata = metadata;
        this.updatedColumns = updatedColumns;
        this.updatedRows = updatedRows;
    }

    @Override
    public PartitionUpdate.Builder getPartitionUpdateBuilder(TableMetadata metadata, DecoratedKey dk, ConsistencyLevel consistency) {
        if (metadata.isCounter()) {
            this.counterConsistencyLevel = consistency;
        }
        return this.puBuilders.computeIfAbsent(dk.getKey(), k -> new PartitionUpdate.Builder(metadata, dk, this.updatedColumns, this.updatedRows));
    }

    @Override
    public List<IMutation> toMutations() {
        ArrayList<IMutation> ms = new ArrayList<IMutation>();
        for (PartitionUpdate.Builder builder : this.puBuilders.values()) {
            IMutation mutation = this.metadata.isVirtual() ? new VirtualMutation(builder.build()) : (this.metadata.isCounter() ? new CounterMutation(new Mutation(builder.build()), this.counterConsistencyLevel) : new Mutation(builder.build()));
            mutation.validateIndexedColumns();
            ms.add(mutation);
        }
        return ms;
    }
}

