/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.transport.frame.FrameBodyTransformer;

public class Connection {
    static final AttributeKey<Connection> attributeKey = AttributeKey.valueOf((String)"CONN");
    private final Channel channel;
    private final ProtocolVersion version;
    private final Tracker tracker;
    private volatile FrameBodyTransformer transformer;
    private boolean throwOnOverload;

    public Connection(Channel channel, ProtocolVersion version, Tracker tracker) {
        this.channel = channel;
        this.version = version;
        this.tracker = tracker;
        tracker.addConnection(channel, this);
    }

    public void setTransformer(FrameBodyTransformer transformer) {
        this.transformer = transformer;
    }

    public FrameBodyTransformer getTransformer() {
        return this.transformer;
    }

    public void setThrowOnOverload(boolean throwOnOverload) {
        this.throwOnOverload = throwOnOverload;
    }

    public boolean isThrowOnOverload() {
        return this.throwOnOverload;
    }

    public Tracker getTracker() {
        return this.tracker;
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    public Channel channel() {
        return this.channel;
    }

    public static interface Tracker {
        public void addConnection(Channel var1, Connection var2);
    }

    public static interface Factory {
        public Connection newConnection(Channel var1, ProtocolVersion var2);
    }
}

