/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool.stats;

import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.nodetool.stats.StatsHolder;

public class TpStatsHolder
implements StatsHolder {
    public final NodeProbe probe;

    public TpStatsHolder(NodeProbe probe) {
        this.probe = probe;
    }

    @Override
    public Map<String, Object> convert2Map() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap threadPools = new HashMap();
        HashMap droppedMessage = new HashMap();
        HashMap waitLatencies = new HashMap();
        for (Map.Entry entry : this.probe.getThreadPools().entries()) {
            HashMap<String, Object> threadPool = new HashMap<String, Object>();
            threadPool.put("ActiveTasks", this.probe.getThreadPoolMetric((String)entry.getKey(), (String)entry.getValue(), "ActiveTasks"));
            threadPool.put("PendingTasks", this.probe.getThreadPoolMetric((String)entry.getKey(), (String)entry.getValue(), "PendingTasks"));
            threadPool.put("CompletedTasks", this.probe.getThreadPoolMetric((String)entry.getKey(), (String)entry.getValue(), "CompletedTasks"));
            threadPool.put("CurrentlyBlockedTasks", this.probe.getThreadPoolMetric((String)entry.getKey(), (String)entry.getValue(), "CurrentlyBlockedTasks"));
            threadPool.put("TotalBlockedTasks", this.probe.getThreadPoolMetric((String)entry.getKey(), (String)entry.getValue(), "TotalBlockedTasks"));
            threadPools.put(entry.getValue(), threadPool);
        }
        result.put("ThreadPools", threadPools);
        for (Map.Entry entry : this.probe.getDroppedMessages().entrySet()) {
            droppedMessage.put(entry.getKey(), entry.getValue());
            try {
                waitLatencies.put(entry.getKey(), this.probe.metricPercentilesAsArray(this.probe.getMessagingQueueWaitMetrics((String)entry.getKey())));
            }
            catch (RuntimeException runtimeException) {}
        }
        result.put("DroppedMessage", droppedMessage);
        result.put("WaitLatencies", waitLatencies);
        return result;
    }
}

