/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.asymmetric;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.asymmetric.DifferenceHolder;
import org.apache.cassandra.repair.asymmetric.RangeDenormalizer;
import org.apache.cassandra.repair.asymmetric.StreamFromOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncomingRepairStreamTracker {
    private static final Logger logger = LoggerFactory.getLogger(IncomingRepairStreamTracker.class);
    private final DifferenceHolder differences;
    private final Map<Range<Token>, StreamFromOptions> incoming = new HashMap<Range<Token>, StreamFromOptions>();

    public IncomingRepairStreamTracker(DifferenceHolder differences) {
        this.differences = differences;
    }

    public String toString() {
        return "IncomingStreamTracker{incoming=" + this.incoming + '}';
    }

    public void addIncomingRangeFrom(Range<Token> range, InetAddressAndPort streamFromNode) {
        logger.trace("adding incoming range {} from {}", range, (Object)streamFromNode);
        Set<Range<Token>> newInput = RangeDenormalizer.denormalize(range, this.incoming);
        for (Range<Token> input : newInput) {
            this.incoming.computeIfAbsent(input, newRange -> new StreamFromOptions(this.differences, (Range<Token>)newRange)).add(streamFromNode);
        }
    }

    public ImmutableMap<Range<Token>, StreamFromOptions> getIncoming() {
        return ImmutableMap.copyOf(this.incoming);
    }
}

