/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.collect.Iterables;
import java.util.function.Predicate;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.locator.AbstractReplicaCollection;
import org.apache.cassandra.locator.Endpoints;
import org.apache.cassandra.locator.EndpointsForRange;
import org.apache.cassandra.locator.EndpointsForToken;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;

public abstract class ReplicaPlan<E extends Endpoints<E>> {
    protected final Keyspace keyspace;
    protected final ConsistencyLevel consistencyLevel;
    private final E contacts;

    ReplicaPlan(Keyspace keyspace, ConsistencyLevel consistencyLevel, E contacts) {
        assert (contacts != null);
        this.keyspace = keyspace;
        this.consistencyLevel = consistencyLevel;
        this.contacts = contacts;
    }

    public abstract int blockFor();

    public E contacts() {
        return this.contacts;
    }

    public boolean contacts(Replica replica) {
        return ((Endpoints)this.contacts).contains(replica);
    }

    public Keyspace keyspace() {
        return this.keyspace;
    }

    public ConsistencyLevel consistencyLevel() {
        return this.consistencyLevel;
    }

    public static SharedForTokenRead shared(ForTokenRead replicaPlan) {
        return new SharedForTokenRead(replicaPlan);
    }

    public static SharedForRangeRead shared(ForRangeRead replicaPlan) {
        return new SharedForRangeRead(replicaPlan);
    }

    public static class SharedForRangeRead
    implements Shared<EndpointsForRange, ForRangeRead> {
        private ForRangeRead replicaPlan;

        SharedForRangeRead(ForRangeRead replicaPlan) {
            this.replicaPlan = replicaPlan;
        }

        @Override
        public void addToContacts(Replica replica) {
            this.replicaPlan = this.replicaPlan.withContact((EndpointsForRange)Endpoints.append(this.replicaPlan.contacts(), replica));
        }

        @Override
        public ForRangeRead get() {
            return this.replicaPlan;
        }

        @Override
        public ForRangeRead getWithContacts(EndpointsForRange newContact) {
            return this.replicaPlan.withContact(newContact);
        }
    }

    public static class SharedForTokenRead
    implements Shared<EndpointsForToken, ForTokenRead> {
        private ForTokenRead replicaPlan;

        SharedForTokenRead(ForTokenRead replicaPlan) {
            this.replicaPlan = replicaPlan;
        }

        @Override
        public void addToContacts(Replica replica) {
            this.replicaPlan = this.replicaPlan.withContact((EndpointsForToken)Endpoints.append(this.replicaPlan.contacts(), replica));
        }

        @Override
        public ForTokenRead get() {
            return this.replicaPlan;
        }

        @Override
        public ForTokenRead getWithContacts(EndpointsForToken newContact) {
            return this.replicaPlan.withContact(newContact);
        }
    }

    public static interface Shared<E extends Endpoints<E>, P extends ReplicaPlan<E>> {
        public void addToContacts(Replica var1);

        public P get();

        public P getWithContacts(E var1);
    }

    public static class ForPaxosWrite
    extends ForWrite<EndpointsForToken> {
        final int requiredParticipants;

        ForPaxosWrite(Keyspace keyspace, ConsistencyLevel consistencyLevel, EndpointsForToken pending, EndpointsForToken liveAndDown, EndpointsForToken live, EndpointsForToken contact, int requiredParticipants) {
            super(keyspace, consistencyLevel, pending, liveAndDown, live, contact);
            this.requiredParticipants = requiredParticipants;
        }

        public int requiredParticipants() {
            return this.requiredParticipants;
        }
    }

    public static class ForTokenWrite
    extends ForWrite<EndpointsForToken> {
        public ForTokenWrite(Keyspace keyspace, ConsistencyLevel consistencyLevel, EndpointsForToken pending, EndpointsForToken liveAndDown, EndpointsForToken live, EndpointsForToken contact) {
            super(keyspace, consistencyLevel, pending, liveAndDown, live, contact);
        }

        private ForTokenWrite copy(ConsistencyLevel newConsistencyLevel, EndpointsForToken newContact) {
            return new ForTokenWrite(this.keyspace, newConsistencyLevel, (EndpointsForToken)this.pending(), (EndpointsForToken)this.liveAndDown(), (EndpointsForToken)this.live(), newContact);
        }

        ForTokenWrite withConsistencyLevel(ConsistencyLevel newConsistencylevel) {
            return this.copy(newConsistencylevel, (EndpointsForToken)this.contacts());
        }

        public ForTokenWrite withContact(EndpointsForToken newContact) {
            return this.copy(this.consistencyLevel, newContact);
        }
    }

    public static abstract class ForWrite<E extends Endpoints<E>>
    extends ReplicaPlan<E> {
        final E pending;
        final E liveAndDown;
        final E live;

        ForWrite(Keyspace keyspace, ConsistencyLevel consistencyLevel, E pending, E liveAndDown, E live, E contact) {
            super(keyspace, consistencyLevel, contact);
            this.pending = pending;
            this.liveAndDown = liveAndDown;
            this.live = live;
        }

        @Override
        public int blockFor() {
            return this.consistencyLevel.blockForWrite(this.keyspace, (Endpoints<?>)this.pending());
        }

        public E pending() {
            return this.pending;
        }

        public E liveAndDown() {
            return this.liveAndDown;
        }

        public E live() {
            return this.live;
        }

        public E liveUncontacted() {
            return (E)((Endpoints)((AbstractReplicaCollection)this.live()).filter(r -> !this.contacts((Replica)r)));
        }

        public boolean isAlive(Replica replica) {
            return ((Endpoints)this.live).endpoints().contains(replica.endpoint());
        }

        public Replica lookup(InetAddressAndPort endpoint) {
            return ((Endpoints)this.liveAndDown()).byEndpoint().get(endpoint);
        }

        public String toString() {
            return "ReplicaPlan.ForWrite [ CL: " + (Object)((Object)this.consistencyLevel) + " keyspace: " + this.keyspace + " liveAndDown: " + this.liveAndDown + " live: " + this.live + " contacts: " + this.contacts() + " ]";
        }
    }

    public static class ForRangeRead
    extends ForRead<EndpointsForRange> {
        final AbstractBounds<PartitionPosition> range;
        final int vnodeCount;

        public ForRangeRead(Keyspace keyspace, ConsistencyLevel consistencyLevel, AbstractBounds<PartitionPosition> range, EndpointsForRange candidates, EndpointsForRange contact, int vnodeCount) {
            super(keyspace, consistencyLevel, candidates, contact);
            this.range = range;
            this.vnodeCount = vnodeCount;
        }

        public AbstractBounds<PartitionPosition> range() {
            return this.range;
        }

        public int vnodeCount() {
            return this.vnodeCount;
        }

        ForRangeRead withContact(EndpointsForRange newContact) {
            return new ForRangeRead(this.keyspace, this.consistencyLevel, this.range, (EndpointsForRange)this.candidates(), newContact, this.vnodeCount);
        }
    }

    public static class ForTokenRead
    extends ForRead<EndpointsForToken> {
        public ForTokenRead(Keyspace keyspace, ConsistencyLevel consistencyLevel, EndpointsForToken candidates, EndpointsForToken contact) {
            super(keyspace, consistencyLevel, candidates, contact);
        }

        ForTokenRead withContact(EndpointsForToken newContact) {
            return new ForTokenRead(this.keyspace, this.consistencyLevel, (EndpointsForToken)this.candidates(), newContact);
        }
    }

    public static abstract class ForRead<E extends Endpoints<E>>
    extends ReplicaPlan<E> {
        private final E candidates;

        ForRead(Keyspace keyspace, ConsistencyLevel consistencyLevel, E candidates, E contact) {
            super(keyspace, consistencyLevel, contact);
            this.candidates = candidates;
        }

        @Override
        public int blockFor() {
            return this.consistencyLevel.blockFor(this.keyspace);
        }

        public E candidates() {
            return this.candidates;
        }

        public Replica firstUncontactedCandidate(Predicate<Replica> extraPredicate) {
            return (Replica)Iterables.tryFind(this.candidates(), r -> extraPredicate.test((Replica)r) && !this.contacts((Replica)r)).orNull();
        }

        public Replica lookup(InetAddressAndPort endpoint) {
            return ((Endpoints)this.candidates()).byEndpoint().get(endpoint);
        }

        public String toString() {
            return "ReplicaPlan.ForRead [ CL: " + (Object)((Object)this.consistencyLevel) + " keyspace: " + this.keyspace + " candidates: " + this.candidates + " contacts: " + this.contacts() + " ]";
        }
    }
}

