/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Snapshot;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.locator.AbstractEndpointSnitch;
import org.apache.cassandra.locator.DynamicEndpointSnitchMBean;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaCollection;
import org.apache.cassandra.net.LatencySubscribers;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MBeanWrapper;

public class DynamicEndpointSnitch
extends AbstractEndpointSnitch
implements LatencySubscribers.Subscriber,
DynamicEndpointSnitchMBean {
    private static final boolean USE_SEVERITY = !Boolean.getBoolean("cassandra.ignore_dynamic_snitch_severity");
    private static final double ALPHA = 0.75;
    private static final int WINDOW_SIZE = 100;
    private volatile int dynamicUpdateInterval = DatabaseDescriptor.getDynamicUpdateInterval();
    private volatile int dynamicResetInterval = DatabaseDescriptor.getDynamicResetInterval();
    private volatile double dynamicBadnessThreshold = DatabaseDescriptor.getDynamicBadnessThreshold();
    private static final double RANGE_MERGING_PREFERENCE = 1.5;
    private String mbeanName = "org.apache.cassandra.db:type=DynamicEndpointSnitch";
    private boolean registered = false;
    private volatile HashMap<InetAddressAndPort, Double> scores = new HashMap();
    private final ConcurrentHashMap<InetAddressAndPort, ExponentiallyDecayingReservoir> samples = new ConcurrentHashMap();
    public final IEndpointSnitch subsnitch;
    private volatile ScheduledFuture<?> updateSchedular;
    private volatile ScheduledFuture<?> resetSchedular;
    private final Runnable update;
    private final Runnable reset;

    public DynamicEndpointSnitch(IEndpointSnitch snitch) {
        this(snitch, null);
    }

    public DynamicEndpointSnitch(IEndpointSnitch snitch, String instance) {
        if (instance != null) {
            this.mbeanName = this.mbeanName + ",instance=" + instance;
        }
        this.subsnitch = snitch;
        this.update = new Runnable(){

            @Override
            public void run() {
                DynamicEndpointSnitch.this.updateScores();
            }
        };
        this.reset = new Runnable(){

            @Override
            public void run() {
                DynamicEndpointSnitch.this.reset();
            }
        };
        if (DatabaseDescriptor.isDaemonInitialized()) {
            this.updateSchedular = ScheduledExecutors.scheduledTasks.scheduleWithFixedDelay(this.update, this.dynamicUpdateInterval, this.dynamicUpdateInterval, TimeUnit.MILLISECONDS);
            this.resetSchedular = ScheduledExecutors.scheduledTasks.scheduleWithFixedDelay(this.reset, this.dynamicResetInterval, this.dynamicResetInterval, TimeUnit.MILLISECONDS);
            this.registerMBean();
        }
    }

    public void applyConfigChanges() {
        if (this.dynamicUpdateInterval != DatabaseDescriptor.getDynamicUpdateInterval()) {
            this.dynamicUpdateInterval = DatabaseDescriptor.getDynamicUpdateInterval();
            if (DatabaseDescriptor.isDaemonInitialized()) {
                this.updateSchedular.cancel(false);
                this.updateSchedular = ScheduledExecutors.scheduledTasks.scheduleWithFixedDelay(this.update, this.dynamicUpdateInterval, this.dynamicUpdateInterval, TimeUnit.MILLISECONDS);
            }
        }
        if (this.dynamicResetInterval != DatabaseDescriptor.getDynamicResetInterval()) {
            this.dynamicResetInterval = DatabaseDescriptor.getDynamicResetInterval();
            if (DatabaseDescriptor.isDaemonInitialized()) {
                this.resetSchedular.cancel(false);
                this.resetSchedular = ScheduledExecutors.scheduledTasks.scheduleWithFixedDelay(this.reset, this.dynamicResetInterval, this.dynamicResetInterval, TimeUnit.MILLISECONDS);
            }
        }
        this.dynamicBadnessThreshold = DatabaseDescriptor.getDynamicBadnessThreshold();
    }

    private void registerMBean() {
        MBeanWrapper.instance.registerMBean((Object)this, this.mbeanName);
    }

    public void close() {
        this.updateSchedular.cancel(false);
        this.resetSchedular.cancel(false);
        MBeanWrapper.instance.unregisterMBean(this.mbeanName);
    }

    @Override
    public void gossiperStarting() {
        this.subsnitch.gossiperStarting();
    }

    @Override
    public String getRack(InetAddressAndPort endpoint) {
        return this.subsnitch.getRack(endpoint);
    }

    @Override
    public String getDatacenter(InetAddressAndPort endpoint) {
        return this.subsnitch.getDatacenter(endpoint);
    }

    @Override
    public <C extends ReplicaCollection<? extends C>> C sortedByProximity(InetAddressAndPort address, C unsortedAddresses) {
        assert (address.equals(FBUtilities.getBroadcastAddressAndPort()));
        return this.dynamicBadnessThreshold == 0.0 ? this.sortedByProximityWithScore(address, unsortedAddresses) : this.sortedByProximityWithBadness(address, unsortedAddresses);
    }

    private <C extends ReplicaCollection<? extends C>> C sortedByProximityWithScore(InetAddressAndPort address, C unsortedAddresses) {
        HashMap<InetAddressAndPort, Double> scores = this.scores;
        return unsortedAddresses.sorted((r1, r2) -> this.compareEndpoints(address, (Replica)r1, (Replica)r2, (Map<InetAddressAndPort, Double>)scores));
    }

    private <C extends ReplicaCollection<? extends C>> C sortedByProximityWithBadness(InetAddressAndPort address, C replicas) {
        if (replicas.size() < 2) {
            return replicas;
        }
        replicas = this.subsnitch.sortedByProximity(address, replicas);
        HashMap<InetAddressAndPort, Double> scores = this.scores;
        ArrayList<Double> subsnitchOrderedScores = new ArrayList<Double>(replicas.size());
        for (Replica replica : replicas) {
            Double score = scores.get(replica.endpoint());
            if (score == null) {
                score = 0.0;
            }
            subsnitchOrderedScores.add(score);
        }
        ArrayList sortedScores = new ArrayList(subsnitchOrderedScores);
        Collections.sort(sortedScores);
        double badnessThreshold = 1.0 + this.dynamicBadnessThreshold;
        Iterator sortedScoreIterator = sortedScores.iterator();
        for (Double subsnitchScore : subsnitchOrderedScores) {
            if (!(subsnitchScore > (Double)sortedScoreIterator.next() * badnessThreshold)) continue;
            return this.sortedByProximityWithScore(address, replicas);
        }
        return replicas;
    }

    private int compareEndpoints(InetAddressAndPort target, Replica a1, Replica a2, Map<InetAddressAndPort, Double> scores) {
        Double scored1 = scores.get(a1.endpoint());
        Double scored2 = scores.get(a2.endpoint());
        if (scored1 == null) {
            scored1 = 0.0;
        }
        if (scored2 == null) {
            scored2 = 0.0;
        }
        if (scored1.equals(scored2)) {
            return this.subsnitch.compareEndpoints(target, a1, a2);
        }
        if (scored1 < scored2) {
            return -1;
        }
        return 1;
    }

    @Override
    public int compareEndpoints(InetAddressAndPort target, Replica a1, Replica a2) {
        throw new UnsupportedOperationException("You shouldn't wrap the DynamicEndpointSnitch (within itself or otherwise)");
    }

    @Override
    public void receiveTiming(InetAddressAndPort host, long latency, TimeUnit unit) {
        ExponentiallyDecayingReservoir maybeNewSample;
        ExponentiallyDecayingReservoir sample = this.samples.get(host);
        if (sample == null && (sample = this.samples.putIfAbsent(host, maybeNewSample = new ExponentiallyDecayingReservoir(100, 0.75))) == null) {
            sample = maybeNewSample;
        }
        sample.update(unit.toMillis(latency));
    }

    private void updateScores() {
        if (!StorageService.instance.isGossipActive()) {
            return;
        }
        if (!this.registered && MessagingService.instance() != null) {
            MessagingService.instance().latencySubscribers.subscribe(this);
            this.registered = true;
        }
        double maxLatency = 1.0;
        HashMap<InetAddressAndPort, Snapshot> snapshots = new HashMap<InetAddressAndPort, Snapshot>(this.samples.size());
        for (Map.Entry<InetAddressAndPort, ExponentiallyDecayingReservoir> entry : this.samples.entrySet()) {
            snapshots.put(entry.getKey(), entry.getValue().getSnapshot());
        }
        HashMap newScores = new HashMap();
        for (Map.Entry entry : snapshots.entrySet()) {
            double mean = ((Snapshot)entry.getValue()).getMedian();
            if (!(mean > maxLatency)) continue;
            maxLatency = mean;
        }
        for (Map.Entry entry : snapshots.entrySet()) {
            double score = ((Snapshot)entry.getValue()).getMedian() / maxLatency;
            if (USE_SEVERITY) {
                score += this.getSeverity((InetAddressAndPort)entry.getKey());
            }
            newScores.put(entry.getKey(), score);
        }
        this.scores = newScores;
    }

    private void reset() {
        this.samples.clear();
    }

    @Override
    public Map<InetAddress, Double> getScores() {
        return this.scores.entrySet().stream().collect(Collectors.toMap(address -> ((InetAddressAndPort)address.getKey()).address, Map.Entry::getValue));
    }

    @Override
    public Map<InetAddressAndPort, Double> getScoresWithPort() {
        return this.scores;
    }

    @Override
    public int getUpdateInterval() {
        return this.dynamicUpdateInterval;
    }

    @Override
    public int getResetInterval() {
        return this.dynamicResetInterval;
    }

    @Override
    public double getBadnessThreshold() {
        return this.dynamicBadnessThreshold;
    }

    @Override
    public String getSubsnitchClassName() {
        return this.subsnitch.getClass().getName();
    }

    @Override
    public List<Double> dumpTimings(String hostname) throws UnknownHostException {
        InetAddressAndPort host = InetAddressAndPort.getByName(hostname);
        ArrayList<Double> timings = new ArrayList<Double>();
        ExponentiallyDecayingReservoir sample = this.samples.get(host);
        if (sample != null) {
            long[] lArray = sample.getSnapshot().getValues();
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                double time = lArray[i];
                timings.add(time);
            }
        }
        return timings;
    }

    @Override
    public void setSeverity(double severity) {
        Gossiper.instance.addLocalApplicationState(ApplicationState.SEVERITY, StorageService.instance.valueFactory.severity(severity));
    }

    private double getSeverity(InetAddressAndPort endpoint) {
        EndpointState state = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (state == null) {
            return 0.0;
        }
        VersionedValue event = state.getApplicationState(ApplicationState.SEVERITY);
        if (event == null) {
            return 0.0;
        }
        return Double.parseDouble(event.value);
    }

    @Override
    public double getSeverity() {
        return this.getSeverity(FBUtilities.getBroadcastAddressAndPort());
    }

    @Override
    public boolean isWorthMergingForRangeQuery(ReplicaCollection<?> merged, ReplicaCollection<?> l1, ReplicaCollection<?> l2) {
        if (!this.subsnitch.isWorthMergingForRangeQuery(merged, l1, l2)) {
            return false;
        }
        if (l1.size() == 1 && l2.size() == 1 && l1.get(0).equals(l2.get(0))) {
            return true;
        }
        double maxMerged = this.maxScore(merged);
        double maxL1 = this.maxScore(l1);
        double maxL2 = this.maxScore(l2);
        if (maxMerged < 0.0 || maxL1 < 0.0 || maxL2 < 0.0) {
            return true;
        }
        return maxMerged <= (maxL1 + maxL2) * 1.5;
    }

    private double maxScore(ReplicaCollection<?> endpoints) {
        double maxScore = -1.0;
        for (Replica replica : endpoints) {
            Double score = this.scores.get(replica.endpoint());
            if (score == null || !(score > maxScore)) continue;
            maxScore = score;
        }
        return maxScore;
    }

    @Override
    public boolean validate(Set<String> datacenters, Set<String> racks) {
        return this.subsnitch.validate(datacenters, racks);
    }
}

