/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Json;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Tuples;
import org.apache.cassandra.db.marshal.AbstractCompositeType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TupleSerializer;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

public class TupleType
extends AbstractType<ByteBuffer> {
    private static final String COLON = ":";
    private static final Pattern COLON_PAT = Pattern.compile(":");
    private static final String ESCAPED_COLON = "\\\\:";
    private static final Pattern ESCAPED_COLON_PAT = Pattern.compile("\\\\:");
    private static final String AT = "@";
    private static final Pattern AT_PAT = Pattern.compile("@");
    private static final String ESCAPED_AT = "\\\\@";
    private static final Pattern ESCAPED_AT_PAT = Pattern.compile("\\\\@");
    protected final List<AbstractType<?>> types;
    private final TupleSerializer serializer;

    public TupleType(List<AbstractType<?>> types) {
        this(types, true);
    }

    protected TupleType(List<AbstractType<?>> types, boolean freezeInner) {
        super(AbstractType.ComparisonType.CUSTOM);
        this.types = freezeInner ? Lists.newArrayList((Iterable)Iterables.transform(types, AbstractType::freeze)) : types;
        this.serializer = new TupleSerializer(TupleType.fieldSerializers(types));
    }

    private static List<TypeSerializer<?>> fieldSerializers(List<AbstractType<?>> types) {
        int size = types.size();
        ArrayList serializers = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            serializers.add(types.get(i).getSerializer());
        }
        return serializers;
    }

    public static TupleType getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        List<AbstractType<?>> types = parser.getTypeParameters();
        for (int i = 0; i < types.size(); ++i) {
            types.set(i, types.get(i).freeze());
        }
        return new TupleType(types);
    }

    @Override
    public boolean referencesUserType(ByteBuffer name) {
        return Iterables.any(this.types, t -> t.referencesUserType(name));
    }

    public TupleType withUpdatedUserType(UserType udt) {
        return this.referencesUserType(udt.name) ? new TupleType(Lists.newArrayList((Iterable)Iterables.transform(this.types, t -> t.withUpdatedUserType(udt)))) : this;
    }

    @Override
    public AbstractType<?> expandUserTypes() {
        return new TupleType(Lists.newArrayList((Iterable)Iterables.transform(this.types, AbstractType::expandUserTypes)));
    }

    @Override
    public boolean referencesDuration() {
        return this.allTypes().stream().anyMatch(f -> f.referencesDuration());
    }

    public AbstractType<?> type(int i) {
        return this.types.get(i);
    }

    public int size() {
        return this.types.size();
    }

    @Override
    public List<AbstractType<?>> subTypes() {
        return this.types;
    }

    public List<AbstractType<?>> allTypes() {
        return this.types;
    }

    @Override
    public boolean isTuple() {
        return true;
    }

    @Override
    public int compareCustom(ByteBuffer o1, ByteBuffer o2) {
        int size;
        if (!o1.hasRemaining() || !o2.hasRemaining()) {
            return o1.hasRemaining() ? 1 : (o2.hasRemaining() ? -1 : 0);
        }
        ByteBuffer bb1 = o1.duplicate();
        ByteBuffer bb2 = o2.duplicate();
        int i = 0;
        while (bb1.remaining() > 0 && bb2.remaining() > 0) {
            AbstractType<?> comparator = this.types.get(i);
            int size1 = bb1.getInt();
            int size2 = bb2.getInt();
            if (size1 < 0) {
                if (size2 >= 0) {
                    return -1;
                }
            } else {
                ByteBuffer value2;
                if (size2 < 0) {
                    return 1;
                }
                ByteBuffer value1 = ByteBufferUtil.readBytes(bb1, size1);
                int cmp = comparator.compare(value1, value2 = ByteBufferUtil.readBytes(bb2, size2));
                if (cmp != 0) {
                    return cmp;
                }
            }
            ++i;
        }
        while (bb1.remaining() > 0) {
            size = bb1.getInt();
            if (size <= 0) continue;
            return 1;
        }
        while (bb2.remaining() > 0) {
            size = bb2.getInt();
            if (size <= 0) continue;
            return -1;
        }
        return 0;
    }

    public ByteBuffer[] split(ByteBuffer value) {
        ByteBuffer[] components = new ByteBuffer[this.size()];
        ByteBuffer input = value.duplicate();
        for (int i = 0; i < this.size(); ++i) {
            if (!input.hasRemaining()) {
                return Arrays.copyOfRange(components, 0, i);
            }
            int size = input.getInt();
            if (input.remaining() < size) {
                throw new MarshalException(String.format("Not enough bytes to read %dth component", i));
            }
            components[i] = size < 0 ? null : ByteBufferUtil.readBytes(input, size);
        }
        if (input.hasRemaining()) {
            throw new InvalidRequestException(String.format("Expected %s %s for %s column, but got more", this.size(), this.size() == 1 ? "value" : "values", this.asCQL3Type()));
        }
        return components;
    }

    public static ByteBuffer buildValue(ByteBuffer[] components) {
        int totalLength = 0;
        for (ByteBuffer component : components) {
            totalLength += 4 + (component == null ? 0 : component.remaining());
        }
        ByteBuffer result = ByteBuffer.allocate(totalLength);
        for (ByteBuffer component : components) {
            if (component == null) {
                result.putInt(-1);
                continue;
            }
            result.putInt(component.remaining());
            result.put(component.duplicate());
        }
        result.rewind();
        return result;
    }

    @Override
    public String getString(ByteBuffer value) {
        if (value == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        ByteBuffer input = value.duplicate();
        for (int i = 0; i < this.size(); ++i) {
            if (!input.hasRemaining()) {
                return sb.toString();
            }
            if (i > 0) {
                sb.append(COLON);
            }
            AbstractType<?> type = this.type(i);
            int size = input.getInt();
            if (size < 0) {
                sb.append(AT);
                continue;
            }
            ByteBuffer field = ByteBufferUtil.readBytes(input, size);
            String fld = COLON_PAT.matcher(type.getString(field)).replaceAll(ESCAPED_COLON);
            fld = AT_PAT.matcher(fld).replaceAll(ESCAPED_AT);
            sb.append(fld);
        }
        return sb.toString();
    }

    @Override
    public ByteBuffer fromString(String source) {
        List<String> fieldStrings = AbstractCompositeType.split(source);
        if (fieldStrings.size() > this.size()) {
            throw new MarshalException(String.format("Invalid tuple literal: too many elements. Type %s expects %d but got %d", this.asCQL3Type(), this.size(), fieldStrings.size()));
        }
        ByteBuffer[] fields = new ByteBuffer[fieldStrings.size()];
        for (int i = 0; i < fieldStrings.size(); ++i) {
            String fieldString = fieldStrings.get(i);
            if (fieldString.equals(AT)) continue;
            AbstractType<?> type = this.type(i);
            fieldString = ESCAPED_COLON_PAT.matcher(fieldString).replaceAll(COLON);
            fieldString = ESCAPED_AT_PAT.matcher(fieldString).replaceAll(AT);
            fields[i] = type.fromString(fieldString);
        }
        return TupleType.buildValue(fields);
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        if (parsed instanceof String) {
            parsed = Json.decodeJson((String)parsed);
        }
        if (!(parsed instanceof List)) {
            throw new MarshalException(String.format("Expected a list representation of a tuple, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
        List list = (List)parsed;
        if (list.size() > this.types.size()) {
            throw new MarshalException(String.format("Tuple contains extra items (expected %s): %s", this.types.size(), parsed));
        }
        if (this.types.size() > list.size()) {
            throw new MarshalException(String.format("Tuple is missing items (expected %s): %s", this.types.size(), parsed));
        }
        ArrayList<Term> terms = new ArrayList<Term>(list.size());
        Iterator<AbstractType<?>> typeIterator = this.types.iterator();
        for (Object element : list) {
            if (element == null) {
                typeIterator.next();
                terms.add(Constants.NULL_VALUE);
                continue;
            }
            terms.add(typeIterator.next().fromJSONObject(element));
        }
        return new Tuples.DelayedValue(this, terms);
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        ByteBuffer duplicated = buffer.duplicate();
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < this.types.size(); ++i) {
            ByteBuffer value;
            if (i > 0) {
                sb.append(", ");
            }
            if ((value = CollectionSerializer.readValue(duplicated, protocolVersion)) == null) {
                sb.append("null");
                continue;
            }
            sb.append(this.types.get(i).toJSONString(value, protocolVersion));
        }
        return sb.append("]").toString();
    }

    @Override
    public TypeSerializer<ByteBuffer> getSerializer() {
        return this.serializer;
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        if (!(previous instanceof TupleType)) {
            return false;
        }
        TupleType tt = (TupleType)previous;
        if (this.size() < tt.size()) {
            return false;
        }
        for (int i = 0; i < tt.size(); ++i) {
            AbstractType<?> tprev = tt.type(i);
            AbstractType<?> tnew = this.type(i);
            if (tnew.isCompatibleWith(tprev)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValueCompatibleWithInternal(AbstractType<?> otherType) {
        if (!(otherType instanceof TupleType)) {
            return false;
        }
        TupleType tt = (TupleType)otherType;
        if (this.size() < tt.size()) {
            return false;
        }
        for (int i = 0; i < tt.size(); ++i) {
            AbstractType<?> tprev = tt.type(i);
            AbstractType<?> tnew = this.type(i);
            if (tnew.isValueCompatibleWith(tprev)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.types});
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof TupleType)) {
            return false;
        }
        TupleType that = (TupleType)o;
        return this.types.equals(that.types);
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Tuple.create(this);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + TypeParser.stringifyTypeParameters(this.types, true);
    }
}

