/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.transport.frame.compress.SnappyCompressor;
import org.apache.cassandra.transport.messages.SupportedMessage;
import org.apache.cassandra.utils.ChecksumType;

public class OptionsMessage
extends Message.Request {
    public static final Message.Codec<OptionsMessage> codec = new Message.Codec<OptionsMessage>(){

        @Override
        public OptionsMessage decode(ByteBuf body, ProtocolVersion version) {
            return new OptionsMessage();
        }

        @Override
        public void encode(OptionsMessage msg, ByteBuf dest, ProtocolVersion version) {
        }

        @Override
        public int encodedSize(OptionsMessage msg, ProtocolVersion version) {
            return 0;
        }
    };

    public OptionsMessage() {
        super(Message.Type.OPTIONS);
    }

    @Override
    protected Message.Response execute(QueryState state, long queryStartNanoTime, boolean traceRequest) {
        ArrayList<String> cqlVersions = new ArrayList<String>();
        cqlVersions.add(QueryProcessor.CQL_VERSION.toString());
        ArrayList<String> compressions = new ArrayList<String>();
        if (SnappyCompressor.INSTANCE != null) {
            compressions.add("snappy");
        }
        compressions.add("lz4");
        HashMap<String, List<String>> supported = new HashMap<String, List<String>>();
        supported.put("CQL_VERSION", cqlVersions);
        supported.put("COMPRESSION", compressions);
        supported.put("PROTOCOL_VERSIONS", ProtocolVersion.supportedVersions());
        if (this.connection.getVersion().supportsChecksums()) {
            ChecksumType[] types = ChecksumType.values();
            ArrayList<String> checksumImpls = new ArrayList<String>(types.length);
            for (ChecksumType type : types) {
                checksumImpls.add(type.toString());
            }
            supported.put("CONTENT_CHECKSUM", checksumImpls);
        }
        return new SupportedMessage(supported);
    }

    public String toString() {
        return "OPTIONS";
    }
}

