/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads.repair;

import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.tracing.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingReadRepairs {
    private static final Logger logger = LoggerFactory.getLogger(BlockingReadRepairs.class);
    private static final boolean DROP_OVERSIZED_READ_REPAIR_MUTATIONS = Boolean.getBoolean("cassandra.drop_oversized_readrepair_mutations");

    public static Mutation createRepairMutation(PartitionUpdate update, ConsistencyLevel consistency, InetAddressAndPort destination, boolean suppressException) {
        int maxMutationSize;
        if (update == null) {
            return null;
        }
        DecoratedKey key = update.partitionKey();
        Mutation mutation = new Mutation(update);
        Keyspace keyspace = Keyspace.open(mutation.getKeyspaceName());
        TableMetadata metadata = update.metadata();
        int messagingVersion = MessagingService.instance().versions.get(destination);
        int mutationSize = (int)Mutation.serializer.serializedSize(mutation, messagingVersion);
        if (mutationSize <= (maxMutationSize = DatabaseDescriptor.getMaxMutationSize())) {
            return mutation;
        }
        if (DROP_OVERSIZED_READ_REPAIR_MUTATIONS) {
            logger.debug("Encountered an oversized ({}/{}) read repair mutation for table {}, key {}, node {}", new Object[]{mutationSize, maxMutationSize, metadata, metadata.partitionKeyType.getString(key.getKey()), destination});
            return null;
        }
        logger.warn("Encountered an oversized ({}/{}) read repair mutation for table {}, key {}, node {}", new Object[]{mutationSize, maxMutationSize, metadata, metadata.partitionKeyType.getString(key.getKey()), destination});
        if (!suppressException) {
            int blockFor = consistency.blockFor(keyspace);
            Tracing.trace("Timed out while read-repairing after receiving all {} data and digest responses", (Object)blockFor);
            throw new ReadTimeoutException(consistency, blockFor - 1, blockFor, true);
        }
        return null;
    }
}

