/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import java.util.Collection;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.NoPayload;
import org.apache.cassandra.schema.SchemaKeyspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaPullVerbHandler
implements IVerbHandler<NoPayload> {
    public static final SchemaPullVerbHandler instance = new SchemaPullVerbHandler();
    private static final Logger logger = LoggerFactory.getLogger(SchemaPullVerbHandler.class);

    @Override
    public void doVerb(Message<NoPayload> message) {
        logger.trace("Received schema pull request from {}", (Object)message.from());
        Message<Collection<Mutation>> response = message.responseWith((NoPayload)((Object)SchemaKeyspace.convertSchemaToMutations()));
        MessagingService.instance().send(response, message.from());
    }
}

