/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.collect.ImmutableList;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.DefaultSelectStrategyFactory;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.unix.Errors;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.DefaultEventExecutorChooserFactory;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutorChooserFactory;
import io.netty.util.concurrent.RejectedExecutionHandlers;
import io.netty.util.concurrent.ThreadPerTaskExecutor;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.ConnectionType;
import org.apache.cassandra.net.ManyToOneConcurrentLinkedQueue;
import org.apache.cassandra.security.SSLFactory;
import org.apache.cassandra.service.NativeTransportService;
import org.apache.cassandra.utils.ExecutorUtils;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SocketFactory {
    private static final Logger logger = LoggerFactory.getLogger(SocketFactory.class);
    private static final int EVENT_THREADS = Integer.getInteger("cassandra.internode-event-threads", FBUtilities.getAvailableProcessors());
    static final boolean WIRETRACE = false;
    private final Provider provider;
    private final EventLoopGroup acceptGroup;
    private final EventLoopGroup defaultGroup;
    private final EventLoopGroup outboundStreamingGroup;
    final ExecutorService synchronousWorkExecutor = Executors.newCachedThreadPool(new NamedThreadFactory("Messaging-SynchronousWork"));

    SocketFactory() {
        this(Provider.optimalProvider());
    }

    SocketFactory(Provider provider) {
        this.provider = provider;
        this.acceptGroup = provider.makeEventLoopGroup(1, "Messaging-AcceptLoop");
        this.defaultGroup = provider.makeEventLoopGroup(EVENT_THREADS, NamedThreadFactory.globalPrefix() + "Messaging-EventLoop");
        this.outboundStreamingGroup = provider.makeEventLoopGroup(EVENT_THREADS, "Streaming-EventLoop");
    }

    Bootstrap newClientBootstrap(EventLoop eventLoop, int tcpUserTimeoutInMS) {
        if (eventLoop == null) {
            throw new IllegalArgumentException("must provide eventLoop");
        }
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)eventLoop)).channelFactory(this.provider.clientChannelFactory());
        if (this.provider == Provider.EPOLL) {
            bootstrap.option(EpollChannelOption.TCP_USER_TIMEOUT, (Object)tcpUserTimeoutInMS);
        }
        return bootstrap;
    }

    ServerBootstrap newServerBootstrap() {
        return (ServerBootstrap)new ServerBootstrap().group(this.acceptGroup, this.defaultGroup).channelFactory(this.provider.serverChannelFactory());
    }

    static SslHandler newSslHandler(Channel channel, SslContext sslContext, @Nullable InetSocketAddress peer) {
        if (peer == null) {
            return sslContext.newHandler(channel.alloc());
        }
        logger.debug("Creating SSL handler for {}:{}", (Object)peer.getHostString(), (Object)peer.getPort());
        SslHandler sslHandler = sslContext.newHandler(channel.alloc(), peer.getHostString(), peer.getPort());
        SSLEngine engine = sslHandler.engine();
        SSLParameters sslParameters = engine.getSSLParameters();
        sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
        engine.setSSLParameters(sslParameters);
        return sslHandler;
    }

    static String encryptionLogStatement(EncryptionOptions options) {
        if (options == null) {
            return "disabled";
        }
        String encryptionType = SSLFactory.openSslIsAvailable() ? "openssl" : "jdk";
        return "enabled (" + encryptionType + ')';
    }

    EventLoopGroup defaultGroup() {
        return this.defaultGroup;
    }

    public EventLoopGroup outboundStreamingGroup() {
        return this.outboundStreamingGroup;
    }

    public void shutdownNow() {
        this.acceptGroup.shutdownGracefully(0L, 2L, TimeUnit.SECONDS);
        this.defaultGroup.shutdownGracefully(0L, 2L, TimeUnit.SECONDS);
        this.outboundStreamingGroup.shutdownGracefully(0L, 2L, TimeUnit.SECONDS);
        this.synchronousWorkExecutor.shutdownNow();
    }

    void awaitTerminationUntil(long deadlineNanos) throws InterruptedException, TimeoutException {
        ImmutableList groups = ImmutableList.of((Object)this.acceptGroup, (Object)this.defaultGroup, (Object)this.outboundStreamingGroup, (Object)this.synchronousWorkExecutor);
        ExecutorUtils.awaitTerminationUntil(deadlineNanos, groups);
    }

    static boolean isConnectionReset(Throwable t) {
        if (t instanceof ClosedChannelException) {
            return true;
        }
        if (t instanceof ConnectException) {
            return true;
        }
        if (t instanceof Errors.NativeIoException) {
            int errorCode = ((Errors.NativeIoException)t).expectedErr();
            return errorCode == Errors.ERRNO_ECONNRESET_NEGATIVE || errorCode != Errors.ERROR_ECONNREFUSED_NEGATIVE;
        }
        return IOException.class == t.getClass() && ("Broken pipe".equals(t.getMessage()) || "Connection reset by peer".equals(t.getMessage()));
    }

    static boolean isCausedByConnectionReset(Throwable t) {
        return Throwables.isCausedBy(t, SocketFactory::isConnectionReset);
    }

    static String channelId(InetAddressAndPort from, InetSocketAddress realFrom, InetAddressAndPort to, InetSocketAddress realTo, ConnectionType type, String id) {
        return SocketFactory.addressId(from, realFrom) + "->" + SocketFactory.addressId(to, realTo) + '-' + (Object)((Object)type) + '-' + id;
    }

    static String addressId(InetAddressAndPort address, InetSocketAddress realAddress) {
        String str = address.toString();
        if (!address.address.equals(realAddress.getAddress()) || address.port != realAddress.getPort()) {
            str = str + '(' + InetAddressAndPort.toString(realAddress.getAddress(), realAddress.getPort()) + ')';
        }
        return str;
    }

    static String channelId(InetAddressAndPort from, InetAddressAndPort to, ConnectionType type, String id) {
        return from + "->" + to + '-' + (Object)((Object)type) + '-' + id;
    }

    static enum Provider {
        NIO{

            NioEventLoopGroup makeEventLoopGroup(int threadCount, ThreadFactory threadFactory) {
                return new NioEventLoopGroup(threadCount, (Executor)new ThreadPerTaskExecutor(threadFactory), (EventExecutorChooserFactory)DefaultEventExecutorChooserFactory.INSTANCE, SelectorProvider.provider(), DefaultSelectStrategyFactory.INSTANCE, RejectedExecutionHandlers.reject(), capacity -> new ManyToOneConcurrentLinkedQueue());
            }

            ChannelFactory<NioSocketChannel> clientChannelFactory() {
                return NioSocketChannel::new;
            }

            ChannelFactory<NioServerSocketChannel> serverChannelFactory() {
                return NioServerSocketChannel::new;
            }
        }
        ,
        EPOLL{

            EpollEventLoopGroup makeEventLoopGroup(int threadCount, ThreadFactory threadFactory) {
                return new EpollEventLoopGroup(threadCount, (Executor)new ThreadPerTaskExecutor(threadFactory), (EventExecutorChooserFactory)DefaultEventExecutorChooserFactory.INSTANCE, DefaultSelectStrategyFactory.INSTANCE, RejectedExecutionHandlers.reject(), capacity -> new ManyToOneConcurrentLinkedQueue());
            }

            ChannelFactory<EpollSocketChannel> clientChannelFactory() {
                return EpollSocketChannel::new;
            }

            ChannelFactory<EpollServerSocketChannel> serverChannelFactory() {
                return EpollServerSocketChannel::new;
            }
        };


        EventLoopGroup makeEventLoopGroup(int threadCount, String threadNamePrefix) {
            logger.debug("using netty {} event loop for pool prefix {}", (Object)this.name(), (Object)threadNamePrefix);
            return this.makeEventLoopGroup(threadCount, (ThreadFactory)new DefaultThreadFactory(threadNamePrefix, true));
        }

        abstract EventLoopGroup makeEventLoopGroup(int var1, ThreadFactory var2);

        abstract ChannelFactory<? extends Channel> clientChannelFactory();

        abstract ChannelFactory<? extends ServerChannel> serverChannelFactory();

        static Provider optimalProvider() {
            return NativeTransportService.useEpoll() ? EPOLL : NIO;
        }
    }
}

