/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.IOException;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.net.ConnectionType;

class PingRequest {
    static final PingRequest forUrgent = new PingRequest(ConnectionType.URGENT_MESSAGES);
    static final PingRequest forSmall = new PingRequest(ConnectionType.SMALL_MESSAGES);
    static final PingRequest forLarge = new PingRequest(ConnectionType.LARGE_MESSAGES);
    final ConnectionType connectionType;
    static IVersionedSerializer<PingRequest> serializer = new IVersionedSerializer<PingRequest>(){

        @Override
        public void serialize(PingRequest t, DataOutputPlus out, int version) throws IOException {
            out.writeByte(t.connectionType.id);
        }

        @Override
        public PingRequest deserialize(DataInputPlus in, int version) throws IOException {
            ConnectionType type = ConnectionType.fromId(in.readByte());
            switch (type) {
                case URGENT_MESSAGES: {
                    return forUrgent;
                }
                case SMALL_MESSAGES: {
                    return forSmall;
                }
                case LARGE_MESSAGES: {
                    return forLarge;
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public long serializedSize(PingRequest t, int version) {
            return 1L;
        }
    };

    private PingRequest(ConnectionType connectionType) {
        this.connectionType = connectionType;
    }
}

