/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import org.apache.cassandra.net.ManyToOneConcurrentLinkedQueue;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.PrunableArrayQueue;
import org.apache.cassandra.utils.MonotonicClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OutboundMessageQueue {
    private static final Logger logger = LoggerFactory.getLogger(OutboundMessageQueue.class);
    private final MessageConsumer<RuntimeException> onExpired;
    private final ManyToOneConcurrentLinkedQueue<Message<?>> externalQueue = new ManyToOneConcurrentLinkedQueue();
    private final PrunableArrayQueue<Message<?>> internalQueue = new PrunableArrayQueue(256);
    private volatile long earliestExpiresAt = Long.MAX_VALUE;
    private static final AtomicLongFieldUpdater<OutboundMessageQueue> earliestExpiresAtUpdater = AtomicLongFieldUpdater.newUpdater(OutboundMessageQueue.class, "earliestExpiresAt");
    private static final Locked LOCKED = new Locked(() -> {}, null);
    private volatile Locked locked = null;
    private static final AtomicReferenceFieldUpdater<OutboundMessageQueue, Locked> lockedUpdater = AtomicReferenceFieldUpdater.newUpdater(OutboundMessageQueue.class, Locked.class, "locked");
    private volatile RemoveRunner removeRunner = null;
    private static final AtomicReferenceFieldUpdater<OutboundMessageQueue, RemoveRunner> removeRunnerUpdater = AtomicReferenceFieldUpdater.newUpdater(OutboundMessageQueue.class, RemoveRunner.class, "removeRunner");

    OutboundMessageQueue(MessageConsumer<RuntimeException> onExpired) {
        this.onExpired = onExpired;
    }

    void add(Message<?> m) {
        this.maybePruneExpired();
        this.externalQueue.offer(m);
        this.maybeUpdateMinimumExpiryTime(m.expiresAtNanos());
    }

    WithLock lockOrCallback(long nowNanos, Runnable callbackIfDeferred) {
        if (!this.lockOrCallback(callbackIfDeferred)) {
            return null;
        }
        return new WithLock(nowNanos);
    }

    void runEventually(Consumer<WithLock> runEventually) {
        try (WithLock withLock = this.lockOrCallback(MonotonicClock.approxTime.now(), () -> this.runEventually(runEventually));){
            if (withLock != null) {
                runEventually.accept(withLock);
            }
        }
    }

    Message<?> tryPoll(long nowNanos, Runnable elseIfDeferred) {
        try (WithLock withLock = this.lockOrCallback(nowNanos, elseIfDeferred);){
            if (withLock == null) {
                Message<?> message = null;
                return message;
            }
            Message<?> message = withLock.poll();
            return message;
        }
    }

    boolean maybePruneExpired() {
        return this.maybePruneExpired(MonotonicClock.approxTime.now());
    }

    private boolean maybePruneExpired(long nowNanos) {
        if (MonotonicClock.approxTime.isAfter(nowNanos, this.earliestExpiresAt)) {
            return this.tryRun(() -> this.pruneWithLock(nowNanos));
        }
        return false;
    }

    private void maybeUpdateMinimumExpiryTime(long newTime) {
        if (newTime < this.earliestExpiresAt) {
            earliestExpiresAtUpdater.accumulateAndGet(this, newTime, Math::min);
        }
    }

    private void pruneWithLock(long nowNanos) {
        this.earliestExpiresAt = Long.MAX_VALUE;
        this.externalQueue.drain(this.internalQueue::offer);
        this.pruneInternalQueueWithLock(nowNanos);
    }

    private void pruneInternalQueueWithLock(final long nowNanos) {
        class Pruner
        implements PrunableArrayQueue.Pruner<Message<?>> {
            private long earliestExpiresAt = Long.MAX_VALUE;

            Pruner() {
            }

            @Override
            public boolean shouldPrune(Message<?> message) {
                return !OutboundMessageQueue.shouldSend(message, nowNanos);
            }

            @Override
            public void onPruned(Message<?> message) {
                OutboundMessageQueue.this.onExpired.accept(message);
            }

            @Override
            public void onKept(Message<?> message) {
                this.earliestExpiresAt = Math.min(message.expiresAtNanos(), this.earliestExpiresAt);
            }
        }
        Pruner pruner = new Pruner();
        this.internalQueue.prune(pruner);
        this.maybeUpdateMinimumExpiryTime(pruner.earliestExpiresAt);
    }

    private void runEventually(Runnable runEventually) {
        if (!this.lockOrCallback(() -> this.runEventually(runEventually))) {
            return;
        }
        try {
            runEventually.run();
        }
        finally {
            this.unlock();
        }
    }

    private boolean tryRun(Runnable runIfAvailable) {
        if (!this.tryLock()) {
            return false;
        }
        try {
            runIfAvailable.run();
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    private boolean tryLock() {
        return this.locked == null && lockedUpdater.compareAndSet(this, null, LOCKED);
    }

    private boolean lockOrCallback(Runnable callbackWhenAvailable) {
        Locked current;
        if (callbackWhenAvailable == null) {
            return this.tryLock();
        }
        do {
            if ((current = this.locked) != null || !lockedUpdater.compareAndSet(this, null, LOCKED)) continue;
            return true;
        } while (current == null || !lockedUpdater.compareAndSet(this, current, current.andThen(callbackWhenAvailable)));
        return false;
    }

    private void unlock() {
        Locked locked = lockedUpdater.getAndSet(this, null);
        locked.run();
    }

    boolean remove(Message<?> remove) {
        RemoveRunner runner;
        if (remove == null) {
            throw new NullPointerException();
        }
        while ((runner = this.removeRunner) == null || !runner.undo(remove)) {
            if (runner != null || !removeRunnerUpdater.compareAndSet(this, null, runner = new RemoveRunner())) continue;
            runner.undo(remove);
            this.runEventually(runner);
            break;
        }
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)runner.done);
        return runner.removed.contains(remove);
    }

    private static boolean shouldSend(Message<?> m, long nowNanos) {
        return !MonotonicClock.approxTime.isAfter(nowNanos, m.expiresAtNanos());
    }

    private class RemoveRunner
    extends AtomicReference<Remove>
    implements Runnable {
        final CountDownLatch done;
        final Set<Message<?>> removed;

        RemoveRunner() {
            super(new Remove(null, null));
            this.done = new CountDownLatch(1);
            this.removed = Collections.newSetFromMap(new IdentityHashMap());
        }

        boolean undo(Message<?> message) {
            return null != this.updateAndGet(prev -> prev == null ? null : new Remove(message, (Remove)prev));
        }

        @Override
        public void run() {
            final Set remove = Collections.newSetFromMap(new IdentityHashMap());
            OutboundMessageQueue.this.removeRunner = null;
            Remove undo = this.getAndSet(null);
            while (undo.message != null) {
                remove.add(undo.message);
                undo = undo.next;
            }
            class Remover
            implements PrunableArrayQueue.Pruner<Message<?>> {
                private long earliestExpiresAt = Long.MAX_VALUE;

                Remover() {
                }

                @Override
                public boolean shouldPrune(Message<?> message) {
                    return remove.contains(message);
                }

                @Override
                public void onPruned(Message<?> message) {
                    RemoveRunner.this.removed.add(message);
                }

                @Override
                public void onKept(Message<?> message) {
                    this.earliestExpiresAt = Math.min(message.expiresAtNanos(), this.earliestExpiresAt);
                }
            }
            Remover remover = new Remover();
            OutboundMessageQueue.this.earliestExpiresAt = Long.MAX_VALUE;
            OutboundMessageQueue.this.externalQueue.drain(OutboundMessageQueue.this.internalQueue::offer);
            OutboundMessageQueue.this.internalQueue.prune(remover);
            OutboundMessageQueue.this.maybeUpdateMinimumExpiryTime(remover.earliestExpiresAt);
            this.done.countDown();
        }
    }

    static class Remove {
        final Message<?> message;
        final Remove next;

        Remove(Message<?> message, Remove next) {
            this.message = message;
            this.next = next;
        }
    }

    private static class Locked
    implements Runnable {
        final Runnable run;
        final Locked next;

        private Locked(Runnable run, Locked next) {
            this.run = run;
            this.next = next;
        }

        Locked andThen(Runnable next) {
            return new Locked(next, this);
        }

        @Override
        public void run() {
            Locked cur = this;
            while (cur != null) {
                try {
                    cur.run.run();
                }
                catch (Throwable t) {
                    logger.error("Unexpected error when executing deferred lock-intending functions", t);
                }
                cur = cur.next;
            }
        }
    }

    class WithLock
    implements AutoCloseable {
        private final long nowNanos;

        private WithLock(long nowNanos) {
            this.nowNanos = nowNanos;
            OutboundMessageQueue.this.earliestExpiresAt = Long.MAX_VALUE;
            OutboundMessageQueue.this.externalQueue.drain(OutboundMessageQueue.this.internalQueue::offer);
        }

        Message<?> poll() {
            Message m;
            while (null != (m = (Message)OutboundMessageQueue.this.internalQueue.poll()) && !OutboundMessageQueue.shouldSend(m, this.nowNanos)) {
                OutboundMessageQueue.this.onExpired.accept(m);
            }
            return m;
        }

        void removeHead(Message<?> expectHead) {
            assert (expectHead == OutboundMessageQueue.this.internalQueue.peek());
            OutboundMessageQueue.this.internalQueue.poll();
        }

        Message<?> peek() {
            Message m;
            while (null != (m = (Message)OutboundMessageQueue.this.internalQueue.peek()) && !OutboundMessageQueue.shouldSend(m, this.nowNanos)) {
                OutboundMessageQueue.this.internalQueue.poll();
                OutboundMessageQueue.this.onExpired.accept(m);
            }
            return m;
        }

        void consume(Consumer<Message<?>> consumer) {
            Message<?> m;
            while (null != (m = this.poll())) {
                consumer.accept(m);
            }
        }

        @Override
        public void close() {
            OutboundMessageQueue.this.pruneInternalQueueWithLock(this.nowNanos);
            OutboundMessageQueue.this.unlock();
        }
    }

    static interface MessageConsumer<Produces extends Throwable> {
        public boolean accept(Message<?> var1) throws Produces;
    }
}

