/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.hints.ChecksummedDataInput;
import org.apache.cassandra.hints.InputPosition;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.compress.ICompressor;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.memory.BufferPool;

public final class CompressedChecksummedDataInput
extends ChecksummedDataInput {
    private final ICompressor compressor;
    private volatile long filePosition = 0L;
    private volatile long sourcePosition = 0L;
    private volatile ByteBuffer compressedBuffer = null;
    private final ByteBuffer metadataBuffer = ByteBuffer.allocate(8);

    public CompressedChecksummedDataInput(ChannelProxy channel, ICompressor compressor, long filePosition) {
        super(channel, compressor.preferredBufferType());
        this.compressor = compressor;
        this.sourcePosition = this.filePosition = filePosition;
    }

    @Override
    public boolean isEOF() {
        return this.filePosition == this.channel.size() && this.buffer.remaining() == 0;
    }

    @Override
    public long getSourcePosition() {
        return this.sourcePosition;
    }

    @Override
    public InputPosition getSeekPosition() {
        return new Position(this.sourcePosition, this.bufferOffset, this.buffer.position());
    }

    @Override
    public void seek(InputPosition p) {
        Position pos = (Position)p;
        this.bufferOffset = pos.bufferStart;
        this.filePosition = pos.sourcePosition;
        this.buffer.position(0).limit(0);
        this.resetCrc();
        this.reBuffer();
        this.buffer.position(pos.bufferPosition);
        assert (this.sourcePosition == pos.sourcePosition);
        assert (this.bufferOffset == pos.bufferStart);
        assert (this.buffer.position() == pos.bufferPosition);
    }

    @Override
    protected void readBuffer() {
        int bufferSize;
        this.sourcePosition = this.filePosition;
        if (this.isEOF()) {
            return;
        }
        this.metadataBuffer.clear();
        this.channel.read(this.metadataBuffer, this.filePosition);
        this.filePosition += 8L;
        this.metadataBuffer.rewind();
        int uncompressedSize = this.metadataBuffer.getInt();
        int compressedSize = this.metadataBuffer.getInt();
        if (this.compressedBuffer == null || compressedSize > this.compressedBuffer.capacity()) {
            bufferSize = compressedSize + compressedSize / 20;
            if (this.compressedBuffer != null) {
                BufferPool.put(this.compressedBuffer);
            }
            this.compressedBuffer = BufferPool.get(bufferSize, this.compressor.preferredBufferType());
        }
        this.compressedBuffer.clear();
        this.compressedBuffer.limit(compressedSize);
        this.channel.read(this.compressedBuffer, this.filePosition);
        this.compressedBuffer.rewind();
        this.filePosition += (long)compressedSize;
        if (this.buffer.capacity() < uncompressedSize) {
            bufferSize = uncompressedSize + uncompressedSize / 20;
            BufferPool.put(this.buffer);
            this.buffer = BufferPool.get(bufferSize, this.compressor.preferredBufferType());
        }
        this.buffer.clear();
        this.buffer.limit(uncompressedSize);
        try {
            this.compressor.uncompress(this.compressedBuffer, this.buffer);
            this.buffer.flip();
        }
        catch (IOException e) {
            throw new FSReadError((Throwable)e, this.getPath());
        }
    }

    @Override
    public void close() {
        BufferPool.put(this.compressedBuffer);
        super.close();
    }

    public static ChecksummedDataInput upgradeInput(ChecksummedDataInput input, ICompressor compressor) {
        long position = input.getPosition();
        input.close();
        ChannelProxy channel = new ChannelProxy(input.getPath());
        try {
            return new CompressedChecksummedDataInput(channel, compressor, position);
        }
        catch (Throwable t) {
            throw Throwables.cleaned(channel.close(t));
        }
    }

    @VisibleForTesting
    ICompressor getCompressor() {
        return this.compressor;
    }

    static class Position
    extends ChecksummedDataInput.Position {
        final long bufferStart;
        final int bufferPosition;

        public Position(long sourcePosition, long bufferStart, int bufferPosition) {
            super(sourcePosition);
            this.bufferStart = bufferStart;
            this.bufferPosition = bufferPosition;
        }

        @Override
        public long subtract(InputPosition o) {
            Position other = (Position)o;
            return this.bufferStart - other.bufferStart + (long)this.bufferPosition - (long)other.bufferPosition;
        }
    }
}

