/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.streaming;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.streaming.CassandraCompressedStreamReader;
import org.apache.cassandra.db.streaming.CassandraEntireSSTableStreamReader;
import org.apache.cassandra.db.streaming.CassandraStreamHeader;
import org.apache.cassandra.db.streaming.CassandraStreamReader;
import org.apache.cassandra.db.streaming.IStreamReader;
import org.apache.cassandra.io.sstable.SSTableMultiWriter;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.streaming.IncomingStream;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.messages.StreamMessageHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraIncomingFile
implements IncomingStream {
    private final ColumnFamilyStore cfs;
    private final StreamSession session;
    private final StreamMessageHeader header;
    private volatile SSTableMultiWriter sstable;
    private volatile long size = -1L;
    private static final Logger logger = LoggerFactory.getLogger(CassandraIncomingFile.class);

    public CassandraIncomingFile(ColumnFamilyStore cfs, StreamSession session, StreamMessageHeader header) {
        this.cfs = cfs;
        this.session = session;
        this.header = header;
    }

    @Override
    public synchronized void read(DataInputPlus in, int version) throws IOException {
        CassandraStreamHeader streamHeader = (CassandraStreamHeader)CassandraStreamHeader.serializer.deserialize(in, version);
        logger.debug("Incoming stream entireSSTable={} components={}", (Object)streamHeader.isEntireSSTable, (Object)streamHeader.componentManifest);
        IStreamReader reader = streamHeader.isEntireSSTable ? new CassandraEntireSSTableStreamReader(this.header, streamHeader, this.session) : (streamHeader.isCompressed() ? new CassandraCompressedStreamReader(this.header, streamHeader, this.session) : new CassandraStreamReader(this.header, streamHeader, this.session));
        this.size = streamHeader.size();
        this.sstable = reader.read(in);
    }

    @Override
    public synchronized String getName() {
        return this.sstable == null ? "null" : this.sstable.getFilename();
    }

    @Override
    public synchronized long getSize() {
        Preconditions.checkState((this.size > 0L ? 1 : 0) != 0, (Object)"Stream hasn't been read yet");
        return this.size;
    }

    @Override
    public TableId getTableId() {
        Preconditions.checkState((this.sstable != null ? 1 : 0) != 0, (Object)"Stream hasn't been read yet");
        return this.sstable.getTableId();
    }

    public String toString() {
        SSTableMultiWriter sst = this.sstable;
        return "CassandraIncomingFile{sstable=" + (sst == null ? "null" : sst.getFilename()) + '}';
    }

    public SSTableMultiWriter getSSTable() {
        Preconditions.checkState((this.sstable != null ? 1 : 0) != 0, (Object)"Stream hasn't been read yet");
        return this.sstable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CassandraIncomingFile that = (CassandraIncomingFile)o;
        return Objects.equals(this.cfs, that.cfs) && Objects.equals(this.session, that.session) && Objects.equals(this.header, that.header) && Objects.equals(this.sstable, that.sstable);
    }

    public int hashCode() {
        return Objects.hash(this.cfs, this.session, this.header, this.sstable);
    }
}

