/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.NumberType;
import org.apache.cassandra.serializers.IntegerSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

public final class IntegerType
extends NumberType<BigInteger> {
    public static final IntegerType instance = new IntegerType();

    private static int findMostSignificantByte(ByteBuffer bytes) {
        byte b0;
        int i;
        int len = bytes.remaining() - 1;
        for (i = 0; i < len && ((b0 = bytes.get(bytes.position() + i)) == 0 || b0 == -1); ++i) {
            byte b1 = bytes.get(bytes.position() + i + 1);
            if (b0 == 0 && b1 != 0) {
                if (b1 <= 0) break;
                ++i;
                break;
            }
            if (b0 != -1 || b1 == -1) continue;
            if (b1 >= 0) break;
            ++i;
            break;
        }
        return i;
    }

    IntegerType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public int compareCustom(ByteBuffer lhs, ByteBuffer rhs) {
        return IntegerType.compareIntegers(lhs, rhs);
    }

    public static int compareIntegers(ByteBuffer lhs, ByteBuffer rhs) {
        int lhsLen = lhs.remaining();
        int rhsLen = rhs.remaining();
        if (lhsLen == 0) {
            return rhsLen == 0 ? 0 : -1;
        }
        if (rhsLen == 0) {
            return 1;
        }
        int lhsMsbIdx = IntegerType.findMostSignificantByte(lhs);
        int rhsMsbIdx = IntegerType.findMostSignificantByte(rhs);
        int lhsLenDiff = lhsLen - lhsMsbIdx;
        int rhsLenDiff = rhsLen - rhsMsbIdx;
        byte lhsMsb = lhs.get(lhs.position() + lhsMsbIdx);
        byte rhsMsb = rhs.get(rhs.position() + rhsMsbIdx);
        if (lhsLenDiff != rhsLenDiff) {
            if (lhsMsb < 0) {
                return rhsMsb < 0 ? rhsLenDiff - lhsLenDiff : -1;
            }
            if (rhsMsb < 0) {
                return 1;
            }
            return lhsLenDiff - rhsLenDiff;
        }
        if (lhsMsb != rhsMsb) {
            return lhsMsb - rhsMsb;
        }
        ++lhsMsbIdx;
        ++rhsMsbIdx;
        while (lhsMsbIdx < lhsLen) {
            lhsMsb = lhs.get(lhs.position() + lhsMsbIdx++);
            if (lhsMsb == (rhsMsb = rhs.get(rhs.position() + rhsMsbIdx++))) continue;
            return (lhsMsb & 0xFF) - (rhsMsb & 0xFF);
        }
        return 0;
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        BigInteger integerType;
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            integerType = new BigInteger(source);
        }
        catch (Exception e) {
            throw new MarshalException(String.format("unable to make int from '%s'", source), e);
        }
        return this.decompose(integerType);
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            return new Constants.Value(this.getSerializer().serialize(new BigInteger(parsed.toString())));
        }
        catch (NumberFormatException exc) {
            throw new MarshalException(String.format("Value '%s' is not a valid representation of a varint value", parsed));
        }
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        return this.getSerializer().deserialize(buffer).toString();
    }

    @Override
    public boolean isValueCompatibleWithInternal(AbstractType<?> otherType) {
        return this == otherType || Int32Type.instance.isValueCompatibleWith(otherType) || LongType.instance.isValueCompatibleWith(otherType);
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.VARINT;
    }

    @Override
    public TypeSerializer<BigInteger> getSerializer() {
        return IntegerSerializer.instance;
    }

    @Override
    protected int toInt(ByteBuffer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected float toFloat(ByteBuffer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected long toLong(ByteBuffer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected double toDouble(ByteBuffer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected BigInteger toBigInteger(ByteBuffer value) {
        return (BigInteger)this.compose(value);
    }

    @Override
    protected BigDecimal toBigDecimal(ByteBuffer value) {
        return new BigDecimal((BigInteger)this.compose(value));
    }

    @Override
    public ByteBuffer add(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return this.decompose(leftType.toBigInteger(left).add(rightType.toBigInteger(right)));
    }

    @Override
    public ByteBuffer substract(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return this.decompose(leftType.toBigInteger(left).subtract(rightType.toBigInteger(right)));
    }

    @Override
    public ByteBuffer multiply(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return this.decompose(leftType.toBigInteger(left).multiply(rightType.toBigInteger(right)));
    }

    @Override
    public ByteBuffer divide(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return this.decompose(leftType.toBigInteger(left).divide(rightType.toBigInteger(right)));
    }

    @Override
    public ByteBuffer mod(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return this.decompose(leftType.toBigInteger(left).remainder(rightType.toBigInteger(right)));
    }

    @Override
    public ByteBuffer negate(ByteBuffer input) {
        return this.decompose(this.toBigInteger(input).negate());
    }
}

