/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.TruncateRequest;
import org.apache.cassandra.db.TruncateResponse;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.tracing.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TruncateVerbHandler
implements IVerbHandler<TruncateRequest> {
    public static final TruncateVerbHandler instance = new TruncateVerbHandler();
    private static final Logger logger = LoggerFactory.getLogger(TruncateVerbHandler.class);

    @Override
    public void doVerb(Message<TruncateRequest> message) {
        TruncateRequest t;
        block2: {
            t = (TruncateRequest)message.payload;
            Tracing.trace("Applying truncation of {}.{}", (Object)t.keyspace, (Object)t.table);
            try {
                ColumnFamilyStore cfs = Keyspace.open(t.keyspace).getColumnFamilyStore(t.table);
                cfs.truncateBlocking();
            }
            catch (Exception e) {
                logger.error("Error in truncation", (Throwable)e);
                TruncateVerbHandler.respondError(t, message);
                if (FSError.findNested(e) == null) break block2;
                throw FSError.findNested(e);
            }
        }
        Tracing.trace("Enqueuing response to truncate operation to {}", (Object)message.from());
        TruncateResponse response = new TruncateResponse(t.keyspace, t.table, true);
        logger.trace("{} applied.  Enqueuing response to {}@{} ", new Object[]{t, message.id(), message.from()});
        MessagingService.instance().send(message.responseWith((TruncateRequest)((Object)response)), message.from());
    }

    private static void respondError(TruncateRequest t, Message truncateRequestMessage) {
        TruncateResponse response = new TruncateResponse(t.keyspace, t.table, false);
        MessagingService.instance().send(truncateRequestMessage.responseWith(response), truncateRequestMessage.from());
    }
}

