/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.cache.IRowCacheEntry;
import org.apache.cassandra.cache.RowCacheKey;
import org.apache.cassandra.cache.RowCacheSentinel;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.EmptyIterators;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SinglePartitionReadQuery;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.StorageHook;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ClusteringIndexSliceFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.db.partitions.AbstractBTreePartition;
import org.apache.cassandra.db.partitions.CachedBTreePartition;
import org.apache.cassandra.db.partitions.CachedPartition;
import org.apache.cassandra.db.partitions.ImmutableBTreePartition;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.partitions.SingletonUnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIteratorWithLowerBound;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.db.rows.WrappingUnfilteredRowIterator;
import org.apache.cassandra.db.transform.RTBoundValidator;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableReadsListener;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.SearchIterator;
import org.apache.cassandra.utils.btree.BTreeSet;

public class SinglePartitionReadCommand
extends ReadCommand
implements SinglePartitionReadQuery {
    protected static final ReadCommand.SelectionDeserializer selectionDeserializer = new Deserializer();
    private final DecoratedKey partitionKey;
    private final ClusteringIndexFilter clusteringIndexFilter;

    @VisibleForTesting
    protected SinglePartitionReadCommand(boolean isDigest, int digestVersion, boolean acceptsTransient, TableMetadata metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DecoratedKey partitionKey, ClusteringIndexFilter clusteringIndexFilter, IndexMetadata index) {
        super(ReadCommand.Kind.SINGLE_PARTITION, isDigest, digestVersion, acceptsTransient, metadata, nowInSec, columnFilter, rowFilter, limits, index);
        assert (partitionKey.getPartitioner() == metadata.partitioner);
        this.partitionKey = partitionKey;
        this.clusteringIndexFilter = clusteringIndexFilter;
    }

    public static SinglePartitionReadCommand create(TableMetadata metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DecoratedKey partitionKey, ClusteringIndexFilter clusteringIndexFilter, IndexMetadata indexMetadata) {
        return new SinglePartitionReadCommand(false, 0, false, metadata, nowInSec, columnFilter, rowFilter, limits, partitionKey, clusteringIndexFilter, indexMetadata);
    }

    public static SinglePartitionReadCommand create(TableMetadata metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DecoratedKey partitionKey, ClusteringIndexFilter clusteringIndexFilter) {
        return SinglePartitionReadCommand.create(metadata, nowInSec, columnFilter, rowFilter, limits, partitionKey, clusteringIndexFilter, SinglePartitionReadCommand.findIndex(metadata, rowFilter));
    }

    public static SinglePartitionReadCommand create(TableMetadata metadata, int nowInSec, DecoratedKey key, ColumnFilter columnFilter, ClusteringIndexFilter filter) {
        return SinglePartitionReadCommand.create(metadata, nowInSec, columnFilter, RowFilter.NONE, DataLimits.NONE, key, filter);
    }

    public static SinglePartitionReadCommand fullPartitionRead(TableMetadata metadata, int nowInSec, DecoratedKey key) {
        return SinglePartitionReadCommand.create(metadata, nowInSec, key, Slices.ALL);
    }

    public static SinglePartitionReadCommand fullPartitionRead(TableMetadata metadata, int nowInSec, ByteBuffer key) {
        return SinglePartitionReadCommand.create(metadata, nowInSec, metadata.partitioner.decorateKey(key), Slices.ALL);
    }

    public static SinglePartitionReadCommand create(TableMetadata metadata, int nowInSec, DecoratedKey key, Slice slice) {
        return SinglePartitionReadCommand.create(metadata, nowInSec, key, Slices.with(metadata.comparator, slice));
    }

    public static SinglePartitionReadCommand create(TableMetadata metadata, int nowInSec, DecoratedKey key, Slices slices) {
        ClusteringIndexSliceFilter filter = new ClusteringIndexSliceFilter(slices, false);
        return SinglePartitionReadCommand.create(metadata, nowInSec, ColumnFilter.all(metadata), RowFilter.NONE, DataLimits.NONE, key, filter);
    }

    public static SinglePartitionReadCommand create(TableMetadata metadata, int nowInSec, ByteBuffer key, Slices slices) {
        return SinglePartitionReadCommand.create(metadata, nowInSec, metadata.partitioner.decorateKey(key), slices);
    }

    public static SinglePartitionReadCommand create(TableMetadata metadata, int nowInSec, DecoratedKey key, NavigableSet<Clustering> names) {
        ClusteringIndexNamesFilter filter = new ClusteringIndexNamesFilter(names, false);
        return SinglePartitionReadCommand.create(metadata, nowInSec, ColumnFilter.all(metadata), RowFilter.NONE, DataLimits.NONE, key, filter);
    }

    public static SinglePartitionReadCommand create(TableMetadata metadata, int nowInSec, DecoratedKey key, Clustering name) {
        return SinglePartitionReadCommand.create(metadata, nowInSec, key, FBUtilities.singleton(name, metadata.comparator));
    }

    @Override
    public SinglePartitionReadCommand copy() {
        return new SinglePartitionReadCommand(this.isDigestQuery(), this.digestVersion(), this.acceptsTransient(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), this.limits(), this.partitionKey(), this.clusteringIndexFilter(), this.indexMetadata());
    }

    @Override
    protected SinglePartitionReadCommand copyAsDigestQuery() {
        return new SinglePartitionReadCommand(true, this.digestVersion(), this.acceptsTransient(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), this.limits(), this.partitionKey(), this.clusteringIndexFilter(), this.indexMetadata());
    }

    @Override
    protected SinglePartitionReadCommand copyAsTransientQuery() {
        return new SinglePartitionReadCommand(false, 0, true, this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), this.limits(), this.partitionKey(), this.clusteringIndexFilter(), this.indexMetadata());
    }

    @Override
    public SinglePartitionReadCommand withUpdatedLimit(DataLimits newLimits) {
        return new SinglePartitionReadCommand(this.isDigestQuery(), this.digestVersion(), this.acceptsTransient(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), newLimits, this.partitionKey(), this.clusteringIndexFilter(), this.indexMetadata());
    }

    @Override
    public DecoratedKey partitionKey() {
        return this.partitionKey;
    }

    @Override
    public ClusteringIndexFilter clusteringIndexFilter() {
        return this.clusteringIndexFilter;
    }

    @Override
    public ClusteringIndexFilter clusteringIndexFilter(DecoratedKey key) {
        return this.clusteringIndexFilter;
    }

    @Override
    public long getTimeout(TimeUnit unit) {
        return DatabaseDescriptor.getReadRpcTimeout(unit);
    }

    @Override
    public SinglePartitionReadCommand forPaging(Clustering lastReturned, DataLimits limits) {
        assert (!this.isDigestQuery());
        return SinglePartitionReadCommand.create(this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), limits, this.partitionKey(), lastReturned == null ? this.clusteringIndexFilter() : this.clusteringIndexFilter.forPaging(this.metadata().comparator, lastReturned, false));
    }

    @Override
    public PartitionIterator execute(ConsistencyLevel consistency, ClientState clientState, long queryStartNanoTime) throws RequestExecutionException {
        return StorageProxy.read(Group.one(this), consistency, clientState, queryStartNanoTime);
    }

    @Override
    protected void recordLatency(TableMetrics metric, long latencyNanos) {
        metric.readLatency.addNano(latencyNanos);
    }

    @Override
    protected UnfilteredPartitionIterator queryStorage(ColumnFamilyStore cfs, ReadExecutionController executionController) {
        UnfilteredRowIterator partition = cfs.isRowCacheEnabled() && !this.isTrackingRepairedStatus() ? this.getThroughCache(cfs, executionController) : this.queryMemtableAndDisk(cfs, executionController);
        return new SingletonUnfilteredPartitionIterator(partition);
    }

    private UnfilteredRowIterator getThroughCache(ColumnFamilyStore cfs, ReadExecutionController executionController) {
        boolean cacheFullPartitions;
        assert (!cfs.isIndex());
        assert (cfs.isRowCacheEnabled()) : String.format("Row cache is not enabled on table [%s]", cfs.name);
        RowCacheKey key = new RowCacheKey(this.metadata(), this.partitionKey());
        IRowCacheEntry cached = (IRowCacheEntry)CacheService.instance.rowCache.get(key);
        if (cached != null) {
            if (cached instanceof RowCacheSentinel) {
                Tracing.trace("Row cache miss (race)");
                cfs.metric.rowCacheMiss.inc();
                return this.queryMemtableAndDisk(cfs, executionController);
            }
            CachedPartition cachedPartition = (CachedPartition)cached;
            if (cfs.isFilterFullyCoveredBy(this.clusteringIndexFilter(), this.limits(), cachedPartition, this.nowInSec(), this.metadata().enforceStrictLiveness())) {
                cfs.metric.rowCacheHit.inc();
                Tracing.trace("Row cache hit");
                UnfilteredRowIterator unfilteredRowIterator = this.clusteringIndexFilter().getUnfilteredRowIterator(this.columnFilter(), cachedPartition);
                cfs.metric.updateSSTableIterated(0);
                return unfilteredRowIterator;
            }
            cfs.metric.rowCacheHitOutOfRange.inc();
            Tracing.trace("Ignoring row cache as cached value could not satisfy query");
            return this.queryMemtableAndDisk(cfs, executionController);
        }
        cfs.metric.rowCacheMiss.inc();
        Tracing.trace("Row cache miss");
        boolean bl = cacheFullPartitions = this.metadata().clusteringColumns().size() > 0 ? this.metadata().params.caching.cacheAllRows() : this.metadata().params.caching.cacheRows();
        if (cacheFullPartitions || this.clusteringIndexFilter().isHeadFilter()) {
            RowCacheSentinel sentinel = new RowCacheSentinel();
            boolean sentinelSuccess = CacheService.instance.rowCache.putIfAbsent(key, sentinel);
            boolean sentinelReplaced = false;
            try {
                UnfilteredRowIterator cacheIterator;
                UnfilteredRowIterator iter;
                block16: {
                    final int rowsToCache = this.metadata().params.caching.rowsPerPartitionToCache();
                    final boolean enforceStrictLiveness = this.metadata().enforceStrictLiveness();
                    iter = SinglePartitionReadCommand.fullPartitionRead(this.metadata(), this.nowInSec(), this.partitionKey()).queryMemtableAndDisk(cfs, executionController);
                    try {
                        WrappingUnfilteredRowIterator toCacheIterator = new WrappingUnfilteredRowIterator(iter){
                            private int rowsCounted;
                            {
                                super(wrapped);
                                this.rowsCounted = 0;
                            }

                            @Override
                            public boolean hasNext() {
                                return this.rowsCounted < rowsToCache && super.hasNext();
                            }

                            @Override
                            public Unfiltered next() {
                                Row row;
                                Unfiltered unfiltered = super.next();
                                if (unfiltered.isRow() && (row = (Row)unfiltered).hasLiveData(SinglePartitionReadCommand.this.nowInSec(), enforceStrictLiveness)) {
                                    ++this.rowsCounted;
                                }
                                return unfiltered;
                            }
                        };
                        CachedBTreePartition toCache = CachedBTreePartition.create((UnfilteredRowIterator)toCacheIterator, this.nowInSec());
                        if (sentinelSuccess && !toCache.isEmpty()) {
                            Tracing.trace("Caching {} rows", (Object)toCache.rowCount());
                            CacheService.instance.rowCache.replace(key, sentinel, toCache);
                            sentinelReplaced = true;
                        }
                        cacheIterator = this.clusteringIndexFilter().getUnfilteredRowIterator(this.columnFilter(), toCache);
                        if (!cacheFullPartitions) break block16;
                        assert (!iter.hasNext());
                        iter.close();
                        UnfilteredRowIterator unfilteredRowIterator = cacheIterator;
                        return unfilteredRowIterator;
                    }
                    catch (Error | RuntimeException e) {
                        iter.close();
                        throw e;
                    }
                }
                UnfilteredRowIterator unfilteredRowIterator = UnfilteredRowIterators.concat(cacheIterator, this.clusteringIndexFilter().filterNotIndexed(this.columnFilter(), iter));
                return unfilteredRowIterator;
            }
            finally {
                if (sentinelSuccess && !sentinelReplaced) {
                    cfs.invalidateCachedPartition(key);
                }
            }
        }
        Tracing.trace("Fetching data but not populating cache as query does not query from the start of the partition");
        return this.queryMemtableAndDisk(cfs, executionController);
    }

    public UnfilteredRowIterator queryMemtableAndDisk(ColumnFamilyStore cfs, ReadExecutionController executionController) {
        assert (executionController != null && executionController.validForReadOn(cfs));
        Tracing.trace("Executing single-partition query on {}", (Object)cfs.name);
        return this.queryMemtableAndDiskInternal(cfs);
    }

    private UnfilteredRowIterator queryMemtableAndDiskInternal(ColumnFamilyStore cfs) {
        if (this.clusteringIndexFilter() instanceof ClusteringIndexNamesFilter && !this.queriesMulticellType() && !this.isTrackingRepairedStatus()) {
            return this.queryMemtableAndSSTablesInTimestampOrder(cfs, (ClusteringIndexNamesFilter)this.clusteringIndexFilter());
        }
        Tracing.trace("Acquiring sstable references");
        ColumnFamilyStore.ViewFragment view = cfs.select(View.select(SSTableSet.LIVE, this.partitionKey()));
        Collections.sort(view.sstables, SSTableReader.maxTimestampDescending);
        ClusteringIndexFilter filter = this.clusteringIndexFilter();
        long minTimestamp = Long.MAX_VALUE;
        long mostRecentPartitionTombstone = Long.MIN_VALUE;
        ReadCommand.InputCollector<UnfilteredRowIterator> inputCollector = this.iteratorsForPartition(view);
        try {
            for (Memtable memtable : view.memtables) {
                Partition partition = memtable.getPartition(this.partitionKey());
                if (partition == null) continue;
                minTimestamp = Math.min(minTimestamp, memtable.getMinTimestamp());
                UnfilteredRowIterator iter = filter.getUnfilteredRowIterator(this.columnFilter(), partition);
                this.oldestUnrepairedTombstone = Math.min(this.oldestUnrepairedTombstone, partition.stats().minLocalDeletionTime);
                inputCollector.addMemtableIterator(RTBoundValidator.validate(iter, RTBoundValidator.Stage.MEMTABLE, false));
                mostRecentPartitionTombstone = Math.max(mostRecentPartitionTombstone, iter.partitionLevelDeletion().markedForDeleteAt());
            }
            int nonIntersectingSSTables = 0;
            ArrayList<SSTableReader> skippedSSTablesWithTombstones = null;
            SSTableReadMetricsCollector metricsCollector = new SSTableReadMetricsCollector();
            if (this.isTrackingRepairedStatus()) {
                Tracing.trace("Collecting data from sstables and tracking repaired status");
            }
            for (SSTableReader sstable : view.sstables) {
                if (sstable.getMaxTimestamp() < mostRecentPartitionTombstone) {
                    inputCollector.markInconclusive();
                    break;
                }
                if (!this.shouldInclude(sstable)) {
                    ++nonIntersectingSSTables;
                    if (!sstable.mayHaveTombstones()) continue;
                    if (skippedSSTablesWithTombstones == null) {
                        skippedSSTablesWithTombstones = new ArrayList<SSTableReader>();
                    }
                    skippedSSTablesWithTombstones.add(sstable);
                    continue;
                }
                minTimestamp = Math.min(minTimestamp, sstable.getMinTimestamp());
                UnfilteredRowIteratorWithLowerBound iter = this.makeIterator(cfs, sstable, metricsCollector);
                if (!sstable.isRepaired()) {
                    this.oldestUnrepairedTombstone = Math.min(this.oldestUnrepairedTombstone, sstable.getMinLocalDeletionTime());
                }
                inputCollector.addSSTableIterator(sstable, iter);
                mostRecentPartitionTombstone = Math.max(mostRecentPartitionTombstone, iter.partitionLevelDeletion().markedForDeleteAt());
            }
            int includedDueToTombstones = 0;
            if (skippedSSTablesWithTombstones != null) {
                for (SSTableReader sstable : skippedSSTablesWithTombstones) {
                    if (sstable.getMaxTimestamp() <= minTimestamp) continue;
                    UnfilteredRowIteratorWithLowerBound iter = this.makeIterator(cfs, sstable, metricsCollector);
                    if (!sstable.isRepaired()) {
                        this.oldestUnrepairedTombstone = Math.min(this.oldestUnrepairedTombstone, sstable.getMinLocalDeletionTime());
                    }
                    inputCollector.addSSTableIterator(sstable, iter);
                    ++includedDueToTombstones;
                }
            }
            if (Tracing.isTracing()) {
                Tracing.trace("Skipped {}/{} non-slice-intersecting sstables, included {} due to tombstones", nonIntersectingSSTables, view.sstables.size(), includedDueToTombstones);
            }
            if (inputCollector.isEmpty()) {
                return EmptyIterators.unfilteredRow(cfs.metadata(), this.partitionKey(), filter.isReversed());
            }
            StorageHook.instance.reportRead(cfs.metadata().id, this.partitionKey());
            return this.withSSTablesIterated(inputCollector.finalizeIterators(cfs, this.nowInSec(), this.oldestUnrepairedTombstone), cfs.metric, metricsCollector);
        }
        catch (Error | RuntimeException e) {
            try {
                inputCollector.close();
            }
            catch (Exception e1) {
                e.addSuppressed(e1);
            }
            throw e;
        }
    }

    private boolean shouldInclude(SSTableReader sstable) {
        if (!this.columnFilter().fetchedColumns().statics.isEmpty()) {
            return true;
        }
        return this.clusteringIndexFilter().shouldInclude(sstable);
    }

    private UnfilteredRowIteratorWithLowerBound makeIterator(ColumnFamilyStore cfs, SSTableReader sstable, SSTableReadsListener listener) {
        return StorageHook.instance.makeRowIteratorWithLowerBound(cfs, this.partitionKey(), sstable, this.clusteringIndexFilter(), this.columnFilter(), listener);
    }

    private UnfilteredRowIterator withSSTablesIterated(List<UnfilteredRowIterator> iterators, final TableMetrics metrics, final SSTableReadMetricsCollector metricsCollector) {
        UnfilteredRowIterator merged = UnfilteredRowIterators.merge(iterators);
        if (!merged.isEmpty()) {
            DecoratedKey key = merged.partitionKey();
            metrics.topReadPartitionFrequency.addSample(key.getKey(), 1);
        }
        class UpdateSstablesIterated
        extends Transformation {
            UpdateSstablesIterated() {
            }

            @Override
            public void onPartitionClose() {
                int mergedSSTablesIterated = metricsCollector.getMergedSSTables();
                metrics.updateSSTableIterated(mergedSSTablesIterated);
                Tracing.trace("Merged data from memtables and {} sstables", (Object)mergedSSTablesIterated);
            }
        }
        return Transformation.apply(merged, new UpdateSstablesIterated());
    }

    private boolean queriesMulticellType() {
        for (ColumnMetadata column : this.columnFilter().fetchedColumns()) {
            if (!column.type.isMultiCell() && !column.type.isCounter()) continue;
            return true;
        }
        return false;
    }

    private UnfilteredRowIterator queryMemtableAndSSTablesInTimestampOrder(ColumnFamilyStore cfs, ClusteringIndexNamesFilter filter) {
        UnfilteredRowIterator iter;
        Tracing.trace("Acquiring sstable references");
        ColumnFamilyStore.ViewFragment view = cfs.select(View.select(SSTableSet.LIVE, this.partitionKey()));
        AbstractBTreePartition result = null;
        Tracing.trace("Merging memtable contents");
        for (Memtable memtable : view.memtables) {
            Partition partition = memtable.getPartition(this.partitionKey());
            if (partition == null) continue;
            iter = filter.getUnfilteredRowIterator(this.columnFilter(), partition);
            Throwable throwable = null;
            try {
                if (iter.isEmpty()) continue;
                result = this.add(RTBoundValidator.validate(iter, RTBoundValidator.Stage.MEMTABLE, false), (ImmutableBTreePartition)result, filter, false);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (iter == null) continue;
                if (throwable != null) {
                    try {
                        iter.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                iter.close();
            }
        }
        Collections.sort(view.sstables, SSTableReader.maxTimestampDescending);
        boolean onlyUnrepaired = true;
        SSTableReadMetricsCollector metricsCollector = new SSTableReadMetricsCollector();
        for (SSTableReader sstable : view.sstables) {
            Throwable throwable;
            UnfilteredRowIterator iter2;
            long currentMaxTs;
            if (result != null && sstable.getMaxTimestamp() < result.partitionLevelDeletion().markedForDeleteAt() || (filter = this.reduceFilter(filter, result, currentMaxTs = sstable.getMaxTimestamp())) == null) break;
            if (!this.shouldInclude(sstable)) {
                if (!sstable.mayHaveTombstones()) continue;
                iter2 = StorageHook.instance.makeRowIterator(cfs, sstable, this.partitionKey(), filter.getSlices(this.metadata()), this.columnFilter(), filter.isReversed(), metricsCollector);
                throwable = null;
                try {
                    if (!iter2.partitionLevelDeletion().isLive()) {
                        result = this.add(UnfilteredRowIterators.noRowsIterator(iter2.metadata(), iter2.partitionKey(), Rows.EMPTY_STATIC_ROW, iter2.partitionLevelDeletion(), filter.isReversed()), (ImmutableBTreePartition)result, filter, sstable.isRepaired());
                        continue;
                    }
                    result = this.add(RTBoundValidator.validate(iter2, RTBoundValidator.Stage.SSTABLE, false), (ImmutableBTreePartition)result, filter, sstable.isRepaired());
                    continue;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (iter2 == null) continue;
                    if (throwable != null) {
                        try {
                            iter2.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    iter2.close();
                    continue;
                }
            }
            iter2 = StorageHook.instance.makeRowIterator(cfs, sstable, this.partitionKey(), filter.getSlices(this.metadata()), this.columnFilter(), filter.isReversed(), metricsCollector);
            throwable = null;
            try {
                if (iter2.isEmpty()) continue;
                if (sstable.isRepaired()) {
                    onlyUnrepaired = false;
                }
                result = this.add(RTBoundValidator.validate(iter2, RTBoundValidator.Stage.SSTABLE, false), (ImmutableBTreePartition)result, filter, sstable.isRepaired());
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (iter2 == null) continue;
                if (throwable != null) {
                    try {
                        iter2.close();
                    }
                    catch (Throwable throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                    continue;
                }
                iter2.close();
            }
        }
        cfs.metric.updateSSTableIterated(metricsCollector.getMergedSSTables());
        if (result == null || result.isEmpty()) {
            return EmptyIterators.unfilteredRow(this.metadata(), this.partitionKey(), false);
        }
        DecoratedKey key = result.partitionKey();
        cfs.metric.topReadPartitionFrequency.addSample(key.getKey(), 1);
        StorageHook.instance.reportRead(cfs.metadata.id, this.partitionKey());
        if (metricsCollector.getMergedSSTables() > cfs.getMinimumCompactionThreshold() && onlyUnrepaired && !cfs.isAutoCompactionDisabled() && cfs.getCompactionStrategyManager().shouldDefragment()) {
            Tracing.trace("Defragmenting requested data");
            iter = result.unfilteredIterator(this.columnFilter(), Slices.ALL, false);
            Throwable throwable = null;
            try {
                Mutation mutation = new Mutation(PartitionUpdate.fromIterator(iter, this.columnFilter()));
                Stage.MUTATION.execute(() -> Keyspace.open(mutation.getKeyspaceName()).apply(mutation, false, false));
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (iter != null) {
                    if (throwable != null) {
                        try {
                            iter.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        iter.close();
                    }
                }
            }
        }
        return result.unfilteredIterator(this.columnFilter(), Slices.ALL, this.clusteringIndexFilter().isReversed());
    }

    private ImmutableBTreePartition add(UnfilteredRowIterator iter, ImmutableBTreePartition result, ClusteringIndexNamesFilter filter, boolean isRepaired) {
        if (!isRepaired) {
            this.oldestUnrepairedTombstone = Math.min(this.oldestUnrepairedTombstone, iter.stats().minLocalDeletionTime);
        }
        int maxRows = Math.max(filter.requestedRows().size(), 1);
        if (result == null) {
            return ImmutableBTreePartition.create(iter, maxRows);
        }
        try (UnfilteredRowIterator merged = UnfilteredRowIterators.merge(Arrays.asList(iter, result.unfilteredIterator(this.columnFilter(), Slices.ALL, filter.isReversed())));){
            ImmutableBTreePartition immutableBTreePartition = ImmutableBTreePartition.create(merged, maxRows);
            return immutableBTreePartition;
        }
    }

    private ClusteringIndexNamesFilter reduceFilter(ClusteringIndexNamesFilter filter, Partition result, long sstableTimestamp) {
        boolean hasNoMoreClusterings;
        if (result == null) {
            return filter;
        }
        SearchIterator<Clustering, Row> searchIter = result.searchIterator(this.columnFilter(), false);
        RegularAndStaticColumns columns = this.columnFilter().fetchedColumns();
        NavigableSet<Clustering> clusterings = filter.requestedRows();
        boolean removeStatic = false;
        if (!columns.statics.isEmpty()) {
            Row staticRow = searchIter.next(Clustering.STATIC_CLUSTERING);
            removeStatic = staticRow != null && this.canRemoveRow(staticRow, columns.statics, sstableTimestamp);
        }
        TreeSet<Clusterable> toRemove = null;
        for (Clustering clustering : clusterings) {
            Row row = searchIter.next(clustering);
            if (row == null || !this.canRemoveRow(row, columns.regulars, sstableTimestamp)) continue;
            if (toRemove == null) {
                toRemove = new TreeSet<Clusterable>(result.metadata().comparator);
            }
            toRemove.add(clustering);
        }
        if (!removeStatic && toRemove == null) {
            return filter;
        }
        boolean hasNoMoreStatic = columns.statics.isEmpty() || removeStatic;
        boolean bl = hasNoMoreClusterings = clusterings.isEmpty() || toRemove != null && toRemove.size() == clusterings.size();
        if (hasNoMoreStatic && hasNoMoreClusterings) {
            return null;
        }
        if (toRemove != null) {
            BTreeSet.Builder<Clusterable> newClusterings = BTreeSet.builder(result.metadata().comparator);
            newClusterings.addAll((Collection<Clusterable>)Sets.difference(clusterings, toRemove));
            clusterings = newClusterings.build();
        }
        return new ClusteringIndexNamesFilter(clusterings, filter.isReversed());
    }

    private boolean canRemoveRow(Row row, Columns requestedColumns, long sstableTimestamp) {
        if (row.primaryKeyLivenessInfo().isEmpty() || row.primaryKeyLivenessInfo().timestamp() <= sstableTimestamp) {
            return false;
        }
        for (ColumnMetadata column : requestedColumns) {
            Cell cell = row.getCell(column);
            if (cell != null && cell.timestamp() > sstableTimestamp) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean selectsFullPartition() {
        return this.metadata().isStaticCompactTable() || this.clusteringIndexFilter.selectsAllPartition() && !this.rowFilter().hasExpressionOnClusteringOrRegularColumns();
    }

    public String toString() {
        return String.format("Read(%s columns=%s rowFilter=%s limits=%s key=%s filter=%s, nowInSec=%d)", this.metadata().toString(), this.columnFilter(), this.rowFilter(), this.limits(), this.metadata().partitionKeyType.getString(this.partitionKey().getKey()), this.clusteringIndexFilter.toString(this.metadata()), this.nowInSec());
    }

    @Override
    public Verb verb() {
        return Verb.READ_REQ;
    }

    @Override
    protected void appendCQLWhereClause(StringBuilder sb) {
        String filterString;
        sb.append(" WHERE ");
        sb.append(ColumnMetadata.toCQLString(this.metadata().partitionKeyColumns())).append(" = ");
        DataRange.appendKeyString(sb, this.metadata().partitionKeyType, this.partitionKey().getKey());
        if (!this.rowFilter().isEmpty()) {
            sb.append(" AND ").append(this.rowFilter());
        }
        if (!(filterString = this.clusteringIndexFilter().toCQLString(this.metadata())).isEmpty()) {
            sb.append(" AND ").append(filterString);
        }
    }

    @Override
    protected void serializeSelection(DataOutputPlus out, int version) throws IOException {
        this.metadata().partitionKeyType.writeValue(this.partitionKey().getKey(), out);
        ClusteringIndexFilter.serializer.serialize(this.clusteringIndexFilter(), out, version);
    }

    @Override
    protected long selectionSerializedSize(int version) {
        return this.metadata().partitionKeyType.writtenLength(this.partitionKey().getKey()) + ClusteringIndexFilter.serializer.serializedSize(this.clusteringIndexFilter(), version);
    }

    @Override
    public boolean isLimitedToOnePartition() {
        return true;
    }

    @Override
    public boolean isRangeRequest() {
        return false;
    }

    private static final class SSTableReadMetricsCollector
    implements SSTableReadsListener {
        private int mergedSSTables;

        private SSTableReadMetricsCollector() {
        }

        @Override
        public void onSSTableSelected(SSTableReader sstable, RowIndexEntry<?> indexEntry, SSTableReadsListener.SelectionReason reason) {
            sstable.incrementReadCount();
            ++this.mergedSSTables;
        }

        public int getMergedSSTables() {
            return this.mergedSSTables;
        }
    }

    private static class Deserializer
    extends ReadCommand.SelectionDeserializer {
        private Deserializer() {
        }

        @Override
        public ReadCommand deserialize(DataInputPlus in, int version, boolean isDigest, int digestVersion, boolean acceptsTransient, TableMetadata metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, IndexMetadata index) throws IOException {
            DecoratedKey key = metadata.partitioner.decorateKey(metadata.partitionKeyType.readValue(in, DatabaseDescriptor.getMaxValueSize()));
            ClusteringIndexFilter filter = ClusteringIndexFilter.serializer.deserialize(in, version, metadata);
            return new SinglePartitionReadCommand(isDigest, digestVersion, acceptsTransient, metadata, nowInSec, columnFilter, rowFilter, limits, key, filter, index);
        }
    }

    public static class Group
    extends SinglePartitionReadQuery.Group<SinglePartitionReadCommand> {
        public static Group create(TableMetadata metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, List<DecoratedKey> partitionKeys, ClusteringIndexFilter clusteringIndexFilter) {
            ArrayList<SinglePartitionReadCommand> commands = new ArrayList<SinglePartitionReadCommand>(partitionKeys.size());
            for (DecoratedKey partitionKey : partitionKeys) {
                commands.add(SinglePartitionReadCommand.create(metadata, nowInSec, columnFilter, rowFilter, limits, partitionKey, clusteringIndexFilter));
            }
            return new Group((List<SinglePartitionReadCommand>)commands, limits);
        }

        public Group(List<SinglePartitionReadCommand> commands, DataLimits limits) {
            super(commands, limits);
        }

        public static Group one(SinglePartitionReadCommand command) {
            return new Group(Collections.singletonList(command), command.limits());
        }

        @Override
        public PartitionIterator execute(ConsistencyLevel consistency, ClientState clientState, long queryStartNanoTime) throws RequestExecutionException {
            return StorageProxy.read(this, consistency, clientState, queryStartNanoTime);
        }
    }
}

