/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadQuery;
import org.apache.cassandra.db.VirtualTablePartitionRangeReadQuery;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.service.pager.PartitionRangeQueryPager;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.transport.ProtocolVersion;

public interface PartitionRangeReadQuery
extends ReadQuery {
    public static ReadQuery create(TableMetadata table, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DataRange dataRange) {
        if (table.isVirtual()) {
            return VirtualTablePartitionRangeReadQuery.create(table, nowInSec, columnFilter, rowFilter, limits, dataRange);
        }
        return PartitionRangeReadCommand.create(table, nowInSec, columnFilter, rowFilter, limits, dataRange);
    }

    public DataRange dataRange();

    public PartitionRangeReadQuery withUpdatedLimit(DataLimits var1);

    public PartitionRangeReadQuery withUpdatedLimitsAndDataRange(DataLimits var1, DataRange var2);

    @Override
    default public QueryPager getPager(PagingState pagingState, ProtocolVersion protocolVersion) {
        return new PartitionRangeQueryPager(this, pagingState, protocolVersion);
    }

    @Override
    default public boolean selectsKey(DecoratedKey key) {
        if (!this.dataRange().contains(key)) {
            return false;
        }
        return this.rowFilter().partitionKeyRestrictionsAreSatisfiedBy(key, this.metadata().partitionKeyType);
    }

    @Override
    default public boolean selectsClustering(DecoratedKey key, Clustering clustering) {
        if (clustering == Clustering.STATIC_CLUSTERING) {
            return !this.columnFilter().fetchedColumns().statics.isEmpty();
        }
        if (!this.dataRange().clusteringIndexFilter(key).selects(clustering)) {
            return false;
        }
        return this.rowFilter().clusteringKeyRestrictionsAreSatisfiedBy(clustering);
    }

    @Override
    default public boolean selectsFullPartition() {
        return this.metadata().isStaticCompactTable() || this.dataRange().selectsAllPartition() && !this.rowFilter().hasExpressionOnClusteringOrRegularColumns();
    }
}

