/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.cassandra.cql3.BatchQueryOptions;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.statements.BatchStatement;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.MD5Digest;

public interface QueryHandler {
    public ResultMessage process(String var1, QueryState var2, QueryOptions var3, Map<String, ByteBuffer> var4, long var5) throws RequestExecutionException, RequestValidationException;

    public ResultMessage.Prepared prepare(String var1, ClientState var2, Map<String, ByteBuffer> var3) throws RequestValidationException;

    public Prepared getPrepared(MD5Digest var1);

    public ResultMessage processPrepared(CQLStatement var1, QueryState var2, QueryOptions var3, Map<String, ByteBuffer> var4, long var5) throws RequestExecutionException, RequestValidationException;

    public ResultMessage processBatch(BatchStatement var1, QueryState var2, BatchQueryOptions var3, Map<String, ByteBuffer> var4, long var5) throws RequestExecutionException, RequestValidationException;

    public static class Prepared {
        public final CQLStatement statement;
        public final MD5Digest resultMetadataId;
        public final String rawCQLStatement;

        public Prepared(CQLStatement statement) {
            this(statement, "");
        }

        public Prepared(CQLStatement statement, String rawCQLStatement) {
            this.statement = statement;
            this.rawCQLStatement = rawCQLStatement;
            this.resultMetadataId = ResultSet.ResultMetadata.fromPrepared(statement).getResultMetadataId();
        }
    }
}

