/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.audit.AuditLogEntry;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.audit.AuditLogManager;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.BatchQueryOptions;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryHandler;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.statements.BatchStatement;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.PreparedQueryNotFoundException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.MD5Digest;

public class BatchMessage
extends Message.Request {
    public static final Message.Codec<BatchMessage> codec = new Message.Codec<BatchMessage>(){

        @Override
        public BatchMessage decode(ByteBuf body, ProtocolVersion version) {
            byte type = body.readByte();
            int n = body.readUnsignedShort();
            ArrayList<Object> queryOrIds = new ArrayList<Object>(n);
            ArrayList<List<ByteBuffer>> variables = new ArrayList<List<ByteBuffer>>(n);
            for (int i = 0; i < n; ++i) {
                byte kind = body.readByte();
                if (kind == 0) {
                    queryOrIds.add(CBUtil.readLongString(body));
                } else if (kind == 1) {
                    queryOrIds.add(MD5Digest.wrap(CBUtil.readBytes(body)));
                } else {
                    throw new ProtocolException("Invalid query kind in BATCH messages. Must be 0 or 1 but got " + kind);
                }
                variables.add(CBUtil.readValueList(body, version));
            }
            QueryOptions options = QueryOptions.codec.decode(body, version);
            return new BatchMessage(this.toType(type), queryOrIds, variables, options);
        }

        @Override
        public void encode(BatchMessage msg, ByteBuf dest, ProtocolVersion version) {
            int queries = msg.queryOrIdList.size();
            dest.writeByte((int)this.fromType(msg.batchType));
            dest.writeShort(queries);
            for (int i = 0; i < queries; ++i) {
                Object q = msg.queryOrIdList.get(i);
                dest.writeByte((int)((byte)(!(q instanceof String) ? 1 : 0)));
                if (q instanceof String) {
                    CBUtil.writeLongString((String)q, dest);
                } else {
                    CBUtil.writeBytes(((MD5Digest)q).bytes, dest);
                }
                CBUtil.writeValueList(msg.values.get(i), dest);
            }
            if (version.isSmallerThan(ProtocolVersion.V3)) {
                CBUtil.writeConsistencyLevel(msg.options.getConsistency(), dest);
            } else {
                QueryOptions.codec.encode(msg.options, dest, version);
            }
        }

        @Override
        public int encodedSize(BatchMessage msg, ProtocolVersion version) {
            int size = 3;
            for (int i = 0; i < msg.queryOrIdList.size(); ++i) {
                Object q = msg.queryOrIdList.get(i);
                size += 1 + (q instanceof String ? CBUtil.sizeOfLongString((String)q) : CBUtil.sizeOfBytes(((MD5Digest)q).bytes));
                size += CBUtil.sizeOfValueList(msg.values.get(i));
            }
            return size += version.isSmallerThan(ProtocolVersion.V3) ? CBUtil.sizeOfConsistencyLevel(msg.options.getConsistency()) : QueryOptions.codec.encodedSize(msg.options, version);
        }

        private BatchStatement.Type toType(byte b) {
            if (b == 0) {
                return BatchStatement.Type.LOGGED;
            }
            if (b == 1) {
                return BatchStatement.Type.UNLOGGED;
            }
            if (b == 2) {
                return BatchStatement.Type.COUNTER;
            }
            throw new ProtocolException("Invalid BATCH message type " + b);
        }

        private byte fromType(BatchStatement.Type type) {
            switch (type) {
                case LOGGED: {
                    return 0;
                }
                case UNLOGGED: {
                    return 1;
                }
                case COUNTER: {
                    return 2;
                }
            }
            throw new AssertionError();
        }
    };
    public final BatchStatement.Type batchType;
    public final List<Object> queryOrIdList;
    public final List<List<ByteBuffer>> values;
    public final QueryOptions options;

    public BatchMessage(BatchStatement.Type type, List<Object> queryOrIdList, List<List<ByteBuffer>> values, QueryOptions options) {
        super(Message.Type.BATCH);
        this.batchType = type;
        this.queryOrIdList = queryOrIdList;
        this.values = values;
        this.options = options;
    }

    @Override
    protected boolean isTraceable() {
        return true;
    }

    @Override
    protected Message.Response execute(QueryState state, long queryStartNanoTime, boolean traceRequest) {
        AuditLogManager auditLogManager = AuditLogManager.getInstance();
        try {
            if (traceRequest) {
                this.traceQuery(state);
            }
            QueryHandler handler = ClientState.getCQLQueryHandler();
            ArrayList<QueryHandler.Prepared> prepared = new ArrayList<QueryHandler.Prepared>(this.queryOrIdList.size());
            for (int i = 0; i < this.queryOrIdList.size(); ++i) {
                QueryHandler.Prepared p;
                Object query = this.queryOrIdList.get(i);
                if (query instanceof String) {
                    CQLStatement statement = QueryProcessor.parseStatement((String)query, state.getClientState().cloneWithKeyspaceIfSet(this.options.getKeyspace()));
                    p = new QueryHandler.Prepared(statement, (String)query);
                } else {
                    p = handler.getPrepared((MD5Digest)query);
                    if (null == p) {
                        throw new PreparedQueryNotFoundException((MD5Digest)query);
                    }
                }
                List<ByteBuffer> queryValues = this.values.get(i);
                if (queryValues.size() != p.statement.getBindVariables().size()) {
                    throw new InvalidRequestException(String.format("There were %d markers(?) in CQL but %d bound variables", p.statement.getBindVariables().size(), queryValues.size()));
                }
                prepared.add(p);
            }
            BatchQueryOptions batchOptions = BatchQueryOptions.withPerStatementVariables(this.options, this.values, this.queryOrIdList);
            ArrayList<ModificationStatement> statements = new ArrayList<ModificationStatement>(prepared.size());
            for (int i = 0; i < prepared.size(); ++i) {
                CQLStatement statement = ((QueryHandler.Prepared)prepared.get((int)i)).statement;
                batchOptions.prepareStatement(i, statement.getBindVariables());
                if (!(statement instanceof ModificationStatement)) {
                    throw new InvalidRequestException("Invalid statement in batch: only UPDATE, INSERT and DELETE statements are allowed.");
                }
                statements.add((ModificationStatement)statement);
            }
            BatchStatement batch = new BatchStatement(this.batchType, VariableSpecifications.empty(), statements, Attributes.none());
            long fqlTime = auditLogManager.isLoggingEnabled() ? System.currentTimeMillis() : 0L;
            ResultMessage response = handler.processBatch(batch, state, batchOptions, this.getCustomPayload(), queryStartNanoTime);
            if (auditLogManager.isLoggingEnabled()) {
                auditLogManager.logBatch(this.batchType, this.queryOrIdList, this.values, prepared, this.options, state, fqlTime);
            }
            return response;
        }
        catch (Exception e) {
            if (auditLogManager.isAuditingEnabled()) {
                this.logException(state, e);
            }
            JVMStabilityInspector.inspectThrowable(e);
            return ErrorMessage.fromException(e);
        }
    }

    private void traceQuery(QueryState state) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (this.options.getConsistency() != null) {
            builder.put((Object)"consistency_level", (Object)this.options.getConsistency().name());
        }
        if (this.options.getSerialConsistency() != null) {
            builder.put((Object)"serial_consistency_level", (Object)this.options.getSerialConsistency().name());
        }
        Tracing.instance.begin("Execute batch of CQL3 queries", state.getClientAddress(), (Map<String, String>)builder.build());
    }

    private void logException(QueryState state, Exception e) {
        AuditLogEntry entry = new AuditLogEntry.Builder(state).setOperation(this.getAuditString()).setOptions(this.options).setType(AuditLogEntryType.BATCH).build();
        AuditLogManager.getInstance().log(entry, e);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BATCH of [");
        for (int i = 0; i < this.queryOrIdList.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.queryOrIdList.get(i)).append(" with ").append(this.values.get(i).size()).append(" values");
        }
        sb.append("] at consistency ").append((Object)this.options.getConsistency());
        return sb.toString();
    }

    private String getAuditString() {
        return String.format("BATCH of %d statements at consistency %s", new Object[]{this.queryOrIdList.size(), this.options.getConsistency()});
    }
}

