/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.frame.compress;

import java.io.IOException;
import org.apache.cassandra.transport.frame.compress.Compressor;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.xerial.snappy.Snappy;
import org.xerial.snappy.SnappyError;

public class SnappyCompressor
implements Compressor {
    public static final SnappyCompressor INSTANCE;

    private SnappyCompressor() {
        Snappy.getNativeLibraryVersion();
    }

    @Override
    public int maxCompressedLength(int length) {
        return Snappy.maxCompressedLength((int)length);
    }

    @Override
    public int compress(byte[] src, int srcOffset, int length, byte[] dest, int destOffset) throws IOException {
        return Snappy.compress((byte[])src, (int)0, (int)src.length, (byte[])dest, (int)destOffset);
    }

    @Override
    public byte[] decompress(byte[] src, int offset, int length, int expectedDecompressedLength) throws IOException {
        if (!Snappy.isValidCompressedBuffer((byte[])src, (int)0, (int)length)) {
            throw new IOException("Provided frame does not appear to be Snappy compressed");
        }
        int uncompressedLength = Snappy.uncompressedLength((byte[])src);
        byte[] output = new byte[uncompressedLength];
        Snappy.uncompress((byte[])src, (int)offset, (int)length, (byte[])output, (int)0);
        return output;
    }

    static {
        SnappyCompressor i;
        try {
            i = new SnappyCompressor();
        }
        catch (Exception e) {
            JVMStabilityInspector.inspectThrowable(e);
            i = null;
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError | SnappyError e) {
            i = null;
        }
        INSTANCE = i;
    }
}

