/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.util.Iterator;
import java.util.Set;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.net.MessagingServiceMBean;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.SessionInfo;
import org.apache.cassandra.streaming.StreamState;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="netstats", description="Print network information on provided host (connecting node by default)")
public class NetStats
extends NodeTool.NodeToolCmd {
    @Option(title="human_readable", name={"-H", "--human-readable"}, description="Display bytes in human readable form, i.e. KiB, MiB, GiB, TiB")
    private boolean humanReadable = false;

    @Override
    public void execute(NodeProbe probe) {
        System.out.printf("Mode: %s%n", probe.getOperationMode());
        Set<StreamState> statuses = probe.getStreamStatus();
        if (statuses.isEmpty()) {
            System.out.println("Not sending any streams.");
        }
        for (StreamState status : statuses) {
            System.out.printf("%s %s%n", status.streamOperation.getDescription(), status.planId.toString());
            for (SessionInfo info : status.sessions) {
                System.out.printf("    %s", info.peer.toString(this.printPort));
                if (!info.peer.equals(info.connecting)) {
                    System.out.printf(" (using %s)", info.connecting.toString(this.printPort));
                }
                System.out.printf("%n", new Object[0]);
                if (!info.receivingSummaries.isEmpty()) {
                    if (this.humanReadable) {
                        System.out.printf("        Receiving %d files, %s total. Already received %d files, %s total%n", info.getTotalFilesToReceive(), FileUtils.stringifyFileSize(info.getTotalSizeToReceive()), info.getTotalFilesReceived(), FileUtils.stringifyFileSize(info.getTotalSizeReceived()));
                    } else {
                        System.out.printf("        Receiving %d files, %d bytes total. Already received %d files, %d bytes total%n", info.getTotalFilesToReceive(), info.getTotalSizeToReceive(), info.getTotalFilesReceived(), info.getTotalSizeReceived());
                    }
                    for (ProgressInfo progress : info.getReceivingFiles()) {
                        System.out.printf("            %s%n", progress.toString(this.printPort));
                    }
                }
                if (info.sendingSummaries.isEmpty()) continue;
                if (this.humanReadable) {
                    System.out.printf("        Sending %d files, %s total. Already sent %d files, %s total%n", info.getTotalFilesToSend(), FileUtils.stringifyFileSize(info.getTotalSizeToSend()), info.getTotalFilesSent(), FileUtils.stringifyFileSize(info.getTotalSizeSent()));
                } else {
                    System.out.printf("        Sending %d files, %d bytes total. Already sent %d files, %d bytes total%n", info.getTotalFilesToSend(), info.getTotalSizeToSend(), info.getTotalFilesSent(), info.getTotalSizeSent());
                }
                for (ProgressInfo progress : info.getSendingFiles()) {
                    System.out.printf("            %s%n", progress.toString(this.printPort));
                }
            }
        }
        if (!probe.isStarting()) {
            System.out.printf("Read Repair Statistics:%nAttempted: %d%nMismatch (Blocking): %d%nMismatch (Background): %d%n", probe.getReadRepairAttempted(), probe.getReadRepairRepairedBlocking(), probe.getReadRepairRepairedBackground());
            MessagingServiceMBean ms = probe.msProxy;
            System.out.printf("%-25s", "Pool Name");
            System.out.printf("%10s", "Active");
            System.out.printf("%10s", "Pending");
            System.out.printf("%15s", "Completed");
            System.out.printf("%10s%n", "Dropped");
            int pending = 0;
            Iterator<Number> iterator = ms.getLargeMessagePendingTasks().values().iterator();
            while (iterator.hasNext()) {
                int n = iterator.next();
                pending += n;
            }
            long completed = 0L;
            iterator = ms.getLargeMessageCompletedTasks().values().iterator();
            while (iterator.hasNext()) {
                long n = (Long)iterator.next();
                completed += n;
            }
            long dropped = 0L;
            iterator = ms.getLargeMessageDroppedTasks().values().iterator();
            while (iterator.hasNext()) {
                long n = (Long)iterator.next();
                dropped += n;
            }
            System.out.printf("%-25s%10s%10s%15s%10s%n", "Large messages", "n/a", pending, completed, dropped);
            pending = 0;
            iterator = ms.getSmallMessagePendingTasks().values().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                pending += n;
            }
            completed = 0L;
            iterator = ms.getSmallMessageCompletedTasks().values().iterator();
            while (iterator.hasNext()) {
                long n = (Long)iterator.next();
                completed += n;
            }
            dropped = 0L;
            iterator = ms.getSmallMessageDroppedTasks().values().iterator();
            while (iterator.hasNext()) {
                long n = (Long)iterator.next();
                dropped += n;
            }
            System.out.printf("%-25s%10s%10s%15s%10s%n", "Small messages", "n/a", pending, completed, dropped);
            pending = 0;
            iterator = ms.getGossipMessagePendingTasks().values().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                pending += n;
            }
            completed = 0L;
            iterator = ms.getGossipMessageCompletedTasks().values().iterator();
            while (iterator.hasNext()) {
                long n = (Long)iterator.next();
                completed += n;
            }
            dropped = 0L;
            iterator = ms.getGossipMessageDroppedTasks().values().iterator();
            while (iterator.hasNext()) {
                long n = (Long)iterator.next();
                dropped += n;
            }
            System.out.printf("%-25s%10s%10s%15s%10s%n", "Gossip messages", "n/a", pending, completed, dropped);
        }
    }
}

