/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.base.Preconditions;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="getreplicas", description="Print replicas for a given key")
public class GetReplicas
extends NodeTool.NodeToolCmd {
    @Arguments(usage="<keyspace> <table> <key>", description="The keyspace, the table, and the partition key for which we need to find replicas")
    private List<String> args = new ArrayList<String>();

    @Override
    public void execute(NodeProbe probe) {
        Preconditions.checkArgument((this.args.size() == 3 ? 1 : 0) != 0, (Object)"getreplicas requires keyspace, table and partition key arguments");
        String ks = this.args.get(0);
        String table = this.args.get(1);
        String key = this.args.get(2);
        System.out.println(probe.getReplicas(ks, table, key));
    }
}

