/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.management;

import com.google.common.base.Throwables;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.UUID;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.streaming.ProgressInfo;

public class ProgressInfoCompositeData {
    private static final String[] ITEM_NAMES = new String[]{"planId", "peer", "peer storage port", "sessionIndex", "fileName", "direction", "currentBytes", "totalBytes"};
    private static final String[] ITEM_DESCS = new String[]{"String representation of Plan ID", "Session peer", "Session peer storage port", "Index of session", "Name of the stream", "Direction('IN' or 'OUT')", "Current bytes transferred", "Total bytes to transfer"};
    private static final OpenType<?>[] ITEM_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.LONG};
    public static final CompositeType COMPOSITE_TYPE;

    public static CompositeData toCompositeData(UUID planId, ProgressInfo progressInfo) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put(ITEM_NAMES[0], planId.toString());
        valueMap.put(ITEM_NAMES[1], progressInfo.peer.address.getHostAddress());
        valueMap.put(ITEM_NAMES[2], progressInfo.peer.port);
        valueMap.put(ITEM_NAMES[3], progressInfo.sessionIndex);
        valueMap.put(ITEM_NAMES[4], progressInfo.fileName);
        valueMap.put(ITEM_NAMES[5], progressInfo.direction.name());
        valueMap.put(ITEM_NAMES[6], progressInfo.currentBytes);
        valueMap.put(ITEM_NAMES[7], progressInfo.totalBytes);
        try {
            return new CompositeDataSupport(COMPOSITE_TYPE, valueMap);
        }
        catch (OpenDataException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static ProgressInfo fromCompositeData(CompositeData cd) {
        Object[] values = cd.getAll(ITEM_NAMES);
        try {
            return new ProgressInfo(InetAddressAndPort.getByNameOverrideDefaults((String)values[1], (Integer)values[2]), (Integer)values[3], (String)values[4], ProgressInfo.Direction.valueOf((String)values[5]), (Long)values[6], (Long)values[7]);
        }
        catch (UnknownHostException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static {
        try {
            COMPOSITE_TYPE = new CompositeType(ProgressInfo.class.getName(), "ProgressInfo", ITEM_NAMES, ITEM_DESCS, ITEM_TYPES);
        }
        catch (OpenDataException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

