/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;

public class MapSerializer<K, V>
extends CollectionSerializer<Map<K, V>> {
    private static final ConcurrentMap<Pair<TypeSerializer<?>, TypeSerializer<?>>, MapSerializer> instances = new ConcurrentHashMap();
    public final TypeSerializer<K> keys;
    public final TypeSerializer<V> values;
    private final Comparator<Pair<ByteBuffer, ByteBuffer>> comparator;

    public static <K, V> MapSerializer<K, V> getInstance(TypeSerializer<K> keys, TypeSerializer<V> values, Comparator<ByteBuffer> comparator) {
        Pair<TypeSerializer<K>, TypeSerializer<V>> p = Pair.create(keys, values);
        MapSerializer t = (MapSerializer)instances.get(p);
        if (t == null) {
            t = instances.computeIfAbsent(p, k -> new MapSerializer((TypeSerializer)k.left, (TypeSerializer)k.right, comparator));
        }
        return t;
    }

    private MapSerializer(TypeSerializer<K> keys, TypeSerializer<V> values, Comparator<ByteBuffer> comparator) {
        this.keys = keys;
        this.values = values;
        this.comparator = (p1, p2) -> comparator.compare((ByteBuffer)p1.left, (ByteBuffer)p2.left);
    }

    @Override
    public List<ByteBuffer> serializeValues(Map<K, V> map) {
        ArrayList<Pair<ByteBuffer, ByteBuffer>> pairs = new ArrayList<Pair<ByteBuffer, ByteBuffer>>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            pairs.add(Pair.create(this.keys.serialize(entry.getKey()), this.values.serialize(entry.getValue())));
        }
        Collections.sort(pairs, this.comparator);
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(pairs.size() * 2);
        for (Pair pair : pairs) {
            buffers.add((ByteBuffer)pair.left);
            buffers.add((ByteBuffer)pair.right);
        }
        return buffers;
    }

    @Override
    public int getElementCount(Map<K, V> value) {
        return value.size();
    }

    @Override
    public void validateForNativeProtocol(ByteBuffer bytes, ProtocolVersion version) {
        try {
            ByteBuffer input = bytes.duplicate();
            int n = MapSerializer.readCollectionSize(input, version);
            for (int i = 0; i < n; ++i) {
                this.keys.validate(MapSerializer.readValue(input, version));
                this.values.validate(MapSerializer.readValue(input, version));
            }
            if (input.hasRemaining()) {
                throw new MarshalException("Unexpected extraneous bytes after map value");
            }
        }
        catch (BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a map");
        }
    }

    @Override
    public Map<K, V> deserializeForNativeProtocol(ByteBuffer bytes, ProtocolVersion version) {
        try {
            ByteBuffer input = bytes.duplicate();
            int n = MapSerializer.readCollectionSize(input, version);
            if (n < 0) {
                throw new MarshalException("The data cannot be deserialized as a map");
            }
            LinkedHashMap<K, V> m = new LinkedHashMap<K, V>(Math.min(n, 256));
            for (int i = 0; i < n; ++i) {
                ByteBuffer kbb = MapSerializer.readValue(input, version);
                this.keys.validate(kbb);
                ByteBuffer vbb = MapSerializer.readValue(input, version);
                this.values.validate(vbb);
                m.put(this.keys.deserialize(kbb), this.values.deserialize(vbb));
            }
            if (input.hasRemaining()) {
                throw new MarshalException("Unexpected extraneous bytes after map value");
            }
            return m;
        }
        catch (BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a map");
        }
    }

    @Override
    public ByteBuffer getSerializedValue(ByteBuffer collection, ByteBuffer key, AbstractType<?> comparator) {
        try {
            ByteBuffer input = collection.duplicate();
            int n = MapSerializer.readCollectionSize(input, ProtocolVersion.V3);
            for (int i = 0; i < n; ++i) {
                ByteBuffer kbb = MapSerializer.readValue(input, ProtocolVersion.V3);
                int comparison = comparator.compareForCQL(kbb, key);
                if (comparison == 0) {
                    return MapSerializer.readValue(input, ProtocolVersion.V3);
                }
                if (comparison > 0) {
                    return null;
                }
                MapSerializer.skipValue(input, ProtocolVersion.V3);
            }
            return null;
        }
        catch (BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a map");
        }
    }

    @Override
    public ByteBuffer getSliceFromSerialized(ByteBuffer collection, ByteBuffer from, ByteBuffer to, AbstractType<?> comparator, boolean frozen) {
        if (from == ByteBufferUtil.UNSET_BYTE_BUFFER && to == ByteBufferUtil.UNSET_BYTE_BUFFER) {
            return collection;
        }
        try {
            ByteBuffer input = collection.duplicate();
            int n = MapSerializer.readCollectionSize(input, ProtocolVersion.V3);
            int startPos = input.position();
            int count = 0;
            boolean inSlice = from == ByteBufferUtil.UNSET_BYTE_BUFFER;
            for (int i = 0; i < n; ++i) {
                int comparison;
                int pos = input.position();
                ByteBuffer kbb = MapSerializer.readValue(input, ProtocolVersion.V3);
                if (!inSlice) {
                    comparison = comparator.compareForCQL(from, kbb);
                    if (comparison <= 0) {
                        inSlice = true;
                        startPos = pos;
                    } else {
                        MapSerializer.skipValue(input, ProtocolVersion.V3);
                        continue;
                    }
                }
                int n2 = comparison = to == ByteBufferUtil.UNSET_BYTE_BUFFER ? -1 : comparator.compareForCQL(kbb, to);
                if (comparison > 0) {
                    input.position(pos);
                    break;
                }
                MapSerializer.skipValue(input, ProtocolVersion.V3);
                ++count;
                if (comparison == 0) break;
            }
            if (count == 0 && !frozen) {
                return null;
            }
            return this.copyAsNewCollection(collection, count, startPos, input.position(), ProtocolVersion.V3);
        }
        catch (BufferUnderflowException e) {
            throw new MarshalException("Not enough bytes to read a map");
        }
    }

    @Override
    public String toString(Map<K, V> value) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean isFirst = true;
        for (Map.Entry<K, V> element : value.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(this.keys.toString(element.getKey()));
            sb.append(": ");
            sb.append(this.values.toString(element.getValue()));
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Class<Map<K, V>> getType() {
        return Map.class;
    }
}

