/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.net.OutboundConnections;

public class InternodeOutboundMetrics {
    public static final String TYPE_NAME = "Connection";
    public static final Meter totalExpiredCallbacks = CassandraMetricsRegistry.Metrics.meter(DefaultNameFactory.createMetricName("Connection", "TotalTimeouts", null));
    public final Meter expiredCallbacks;
    public final String address;
    public final Gauge<Integer> largeMessagePendingTasks;
    public final Gauge<Long> largeMessagePendingBytes;
    public final Gauge<Long> largeMessageCompletedTasks;
    public final Gauge<Long> largeMessageCompletedBytes;
    public final Gauge<Long> largeMessageDropped;
    public final Gauge<Long> largeMessageDroppedTasksDueToTimeout;
    public final Gauge<Long> largeMessageDroppedBytesDueToTimeout;
    public final Gauge<Long> largeMessageDroppedTasksDueToOverload;
    public final Gauge<Long> largeMessageDroppedBytesDueToOverload;
    public final Gauge<Long> largeMessageDroppedTasksDueToError;
    public final Gauge<Long> largeMessageDroppedBytesDueToError;
    public final Gauge<Integer> smallMessagePendingTasks;
    public final Gauge<Long> smallMessagePendingBytes;
    public final Gauge<Long> smallMessageCompletedTasks;
    public final Gauge<Long> smallMessageCompletedBytes;
    public final Gauge<Long> smallMessageDroppedTasks;
    public final Gauge<Long> smallMessageDroppedTasksDueToTimeout;
    public final Gauge<Long> smallMessageDroppedBytesDueToTimeout;
    public final Gauge<Long> smallMessageDroppedTasksDueToOverload;
    public final Gauge<Long> smallMessageDroppedBytesDueToOverload;
    public final Gauge<Long> smallMessageDroppedTasksDueToError;
    public final Gauge<Long> smallMessageDroppedBytesDueToError;
    public final Gauge<Integer> urgentMessagePendingTasks;
    public final Gauge<Long> urgentMessagePendingBytes;
    public final Gauge<Long> urgentMessageCompletedTasks;
    public final Gauge<Long> urgentMessageCompletedBytes;
    public final Gauge<Long> urgentMessageDroppedTasks;
    public final Gauge<Long> urgentMessageDroppedTasksDueToTimeout;
    public final Gauge<Long> urgentMessageDroppedBytesDueToTimeout;
    public final Gauge<Long> urgentMessageDroppedTasksDueToOverload;
    public final Gauge<Long> urgentMessageDroppedBytesDueToOverload;
    public final Gauge<Long> urgentMessageDroppedTasksDueToError;
    public final Gauge<Long> urgentMessageDroppedBytesDueToError;
    private final MetricNameFactory factory;

    public InternodeOutboundMetrics(InetAddressAndPort ip, OutboundConnections messagingPool) {
        this.address = ip.toString().replace(':', '_');
        this.factory = new DefaultNameFactory(TYPE_NAME, this.address);
        this.largeMessagePendingTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("LargeMessagePendingTasks"), messagingPool.large::pendingCount);
        this.largeMessagePendingBytes = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("LargeMessagePendingBytes"), messagingPool.large::pendingBytes);
        this.largeMessageCompletedTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("LargeMessageCompletedTasks"), messagingPool.large::sentCount);
        this.largeMessageCompletedBytes = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("LargeMessageCompletedBytes"), messagingPool.large::sentBytes);
        this.largeMessageDropped = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("LargeMessageDroppedTasks"), messagingPool.large::dropped);
        this.largeMessageDroppedTasksDueToOverload = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("LargeMessageDroppedTasksDueToOverload"), messagingPool.large::overloadedCount);
        this.largeMessageDroppedBytesDueToOverload = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("LargeMessageDroppedBytesDueToOverload"), messagingPool.large::overloadedBytes);
        this.largeMessageDroppedTasksDueToTimeout = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("LargeMessageDroppedTasksDueToTimeout"), messagingPool.large::expiredCount);
        this.largeMessageDroppedBytesDueToTimeout = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("LargeMessageDroppedBytesDueToTimeout"), messagingPool.large::expiredBytes);
        this.largeMessageDroppedTasksDueToError = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("LargeMessageDroppedTasksDueToError"), messagingPool.large::errorCount);
        this.largeMessageDroppedBytesDueToError = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("LargeMessageDroppedBytesDueToError"), messagingPool.large::errorBytes);
        this.smallMessagePendingTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("SmallMessagePendingTasks"), messagingPool.small::pendingCount);
        this.smallMessagePendingBytes = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("SmallMessagePendingBytes"), messagingPool.small::pendingBytes);
        this.smallMessageCompletedTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("SmallMessageCompletedTasks"), messagingPool.small::sentCount);
        this.smallMessageCompletedBytes = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("SmallMessageCompletedBytes"), messagingPool.small::sentBytes);
        this.smallMessageDroppedTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("SmallMessageDroppedTasks"), messagingPool.small::dropped);
        this.smallMessageDroppedTasksDueToOverload = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("SmallMessageDroppedTasksDueToOverload"), messagingPool.small::overloadedCount);
        this.smallMessageDroppedBytesDueToOverload = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("SmallMessageDroppedBytesDueToOverload"), messagingPool.small::overloadedBytes);
        this.smallMessageDroppedTasksDueToTimeout = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("SmallMessageDroppedTasksDueToTimeout"), messagingPool.small::expiredCount);
        this.smallMessageDroppedBytesDueToTimeout = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("SmallMessageDroppedBytesDueToTimeout"), messagingPool.small::expiredBytes);
        this.smallMessageDroppedTasksDueToError = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("SmallMessageDroppedTasksDueToError"), messagingPool.small::errorCount);
        this.smallMessageDroppedBytesDueToError = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("SmallMessageDroppedBytesDueToError"), messagingPool.small::errorBytes);
        this.urgentMessagePendingTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("UrgentMessagePendingTasks"), messagingPool.urgent::pendingCount);
        this.urgentMessagePendingBytes = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("UrgentMessagePendingBytes"), messagingPool.urgent::pendingBytes);
        this.urgentMessageCompletedTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("UrgentMessageCompletedTasks"), messagingPool.urgent::sentCount);
        this.urgentMessageCompletedBytes = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("UrgentMessageCompletedBytes"), messagingPool.urgent::sentBytes);
        this.urgentMessageDroppedTasks = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("UrgentMessageDroppedTasks"), messagingPool.urgent::dropped);
        this.urgentMessageDroppedTasksDueToOverload = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("UrgentMessageDroppedTasksDueToOverload"), messagingPool.urgent::overloadedCount);
        this.urgentMessageDroppedBytesDueToOverload = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("UrgentMessageDroppedBytesDueToOverload"), messagingPool.urgent::overloadedBytes);
        this.urgentMessageDroppedTasksDueToTimeout = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("UrgentMessageDroppedTasksDueToTimeout"), messagingPool.urgent::expiredCount);
        this.urgentMessageDroppedBytesDueToTimeout = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("UrgentMessageDroppedBytesDueToTimeout"), messagingPool.urgent::expiredBytes);
        this.urgentMessageDroppedTasksDueToError = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("UrgentMessageDroppedTasksDueToError"), messagingPool.urgent::errorCount);
        this.urgentMessageDroppedBytesDueToError = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("UrgentMessageDroppedBytesDueToError"), messagingPool.urgent::errorBytes);
        this.expiredCallbacks = CassandraMetricsRegistry.Metrics.meter(this.factory.createMetricName("Timeouts"));
        CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("GossipMessagePendingTasks"), messagingPool.urgent::pendingCount);
        CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("GossipMessageCompletedTasks"), messagingPool.urgent::sentCount);
        CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("GossipMessageDroppedTasks"), messagingPool.urgent::dropped);
    }

    public void release() {
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("LargeMessagePendingTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("LargeMessagePendingBytes"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("LargeMessageCompletedTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("LargeMessageCompletedBytes"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("LargeMessageDroppedTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("LargeMessageDroppedTasksDueToTimeout"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("LargeMessageDroppedBytesDueToTimeout"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("LargeMessageDroppedTasksDueToOverload"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("LargeMessageDroppedBytesDueToOverload"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("LargeMessageDroppedTasksDueToError"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("LargeMessageDroppedBytesDueToError"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("SmallMessagePendingTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("SmallMessagePendingBytes"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("SmallMessageCompletedTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("SmallMessageCompletedBytes"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("SmallMessageDroppedTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("SmallMessageDroppedTasksDueToTimeout"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("SmallMessageDroppedBytesDueToTimeout"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("SmallMessageDroppedTasksDueToOverload"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("SmallMessageDroppedBytesDueToOverload"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("SmallMessageDroppedTasksDueToError"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("SmallMessageDroppedBytesDueToError"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("GossipMessagePendingTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("GossipMessageCompletedTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("GossipMessageDroppedTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("UrgentMessagePendingTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("UrgentMessagePendingBytes"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("UrgentMessageCompletedTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("UrgentMessageCompletedBytes"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("UrgentMessageDroppedTasks"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("UrgentMessageDroppedTasksDueToTimeout"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("UrgentMessageDroppedBytesDueToTimeout"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("UrgentMessageDroppedTasksDueToOverload"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("UrgentMessageDroppedBytesDueToOverload"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("UrgentMessageDroppedTasksDueToError"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("UrgentMessageDroppedBytesDueToError"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("Timeouts"));
    }
}

