/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.FastByteOperations;

public final class InetAddressAndPort
implements Comparable<InetAddressAndPort>,
Serializable {
    private static final long serialVersionUID = 0L;
    static volatile int defaultPort = 7000;
    public final InetAddress address;
    public final byte[] addressBytes;
    public final int port;

    private InetAddressAndPort(InetAddress address, byte[] addressBytes, int port) {
        Preconditions.checkNotNull((Object)address);
        Preconditions.checkNotNull((Object)addressBytes);
        InetAddressAndPort.validatePortRange(port);
        this.address = address;
        this.port = port;
        this.addressBytes = addressBytes;
    }

    public InetAddressAndPort withPort(int port) {
        return new InetAddressAndPort(this.address, this.addressBytes, port);
    }

    private static void validatePortRange(int port) {
        if (port < 0 | port > 65535) {
            throw new IllegalArgumentException("Port " + port + " is not a valid port number in the range 0-65535");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InetAddressAndPort that = (InetAddressAndPort)o;
        if (this.port != that.port) {
            return false;
        }
        return this.address.equals(that.address);
    }

    public int hashCode() {
        int result = this.address.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    @Override
    public int compareTo(InetAddressAndPort o) {
        int retval = FastByteOperations.compareUnsigned(this.addressBytes, 0, this.addressBytes.length, o.addressBytes, 0, o.addressBytes.length);
        if (retval != 0) {
            return retval;
        }
        return Integer.compare(this.port, o.port);
    }

    public String getHostAddress(boolean withPort) {
        if (withPort) {
            return this.toString();
        }
        return this.address.getHostAddress();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean withPort) {
        if (withPort) {
            return InetAddressAndPort.toString(this.address, this.port);
        }
        return this.address.toString();
    }

    public static String toString(InetAddress address, int port) {
        return HostAndPort.fromParts((String)address.getHostAddress(), (int)port).toString();
    }

    public static InetAddressAndPort getByName(String name) throws UnknownHostException {
        return InetAddressAndPort.getByNameOverrideDefaults(name, null);
    }

    public static InetAddressAndPort getByNameOverrideDefaults(String name, Integer port) throws UnknownHostException {
        HostAndPort hap = HostAndPort.fromString((String)name);
        if (hap.hasPort()) {
            port = hap.getPort();
        }
        return InetAddressAndPort.getByAddressOverrideDefaults(InetAddress.getByName(hap.getHost()), port);
    }

    public static InetAddressAndPort getByAddress(byte[] address) throws UnknownHostException {
        return InetAddressAndPort.getByAddressOverrideDefaults(InetAddress.getByAddress(address), address, null);
    }

    public static InetAddressAndPort getByAddress(InetAddress address) {
        return InetAddressAndPort.getByAddressOverrideDefaults(address, null);
    }

    public static InetAddressAndPort getByAddressOverrideDefaults(InetAddress address, Integer port) {
        if (port == null) {
            port = defaultPort;
        }
        return new InetAddressAndPort(address, address.getAddress(), port);
    }

    public static InetAddressAndPort getByAddressOverrideDefaults(InetAddress address, byte[] addressBytes, Integer port) {
        if (port == null) {
            port = defaultPort;
        }
        return new InetAddressAndPort(address, addressBytes, port);
    }

    public static InetAddressAndPort getLoopbackAddress() {
        return InetAddressAndPort.getByAddress(InetAddress.getLoopbackAddress());
    }

    public static InetAddressAndPort getLocalHost() {
        return FBUtilities.getLocalAddressAndPort();
    }

    public static void initializeDefaultPort(int port) {
        defaultPort = port;
    }

    static int getDefaultPort() {
        return defaultPort;
    }

    public static final class Serializer
    implements IVersionedSerializer<InetAddressAndPort> {
        public static final int MAXIMUM_SIZE = 19;
        public static final Serializer inetAddressAndPortSerializer = new Serializer();

        private Serializer() {
        }

        @Override
        public void serialize(InetAddressAndPort endpoint, DataOutputPlus out, int version) throws IOException {
            byte[] buf = endpoint.addressBytes;
            if (version >= 12) {
                out.writeByte(buf.length + 2);
                out.write(buf);
                out.writeShort(endpoint.port);
            } else {
                out.writeByte(buf.length);
                out.write(buf);
            }
        }

        @Override
        public InetAddressAndPort deserialize(DataInputPlus in, int version) throws IOException {
            int size = in.readByte() & 0xFF;
            switch (size) {
                case 4: 
                case 16: {
                    byte[] bytes = new byte[size];
                    in.readFully(bytes, 0, bytes.length);
                    return InetAddressAndPort.getByAddress(bytes);
                }
                case 6: 
                case 18: {
                    byte[] bytes = new byte[size - 2];
                    in.readFully(bytes);
                    int port = in.readShort() & 0xFFFF;
                    return InetAddressAndPort.getByAddressOverrideDefaults(InetAddress.getByAddress(bytes), bytes, port);
                }
            }
            throw new AssertionError((Object)("Unexpected size " + size));
        }

        public InetAddressAndPort extract(ByteBuffer buf, int position) throws IOException {
            int size;
            if ((size = buf.get(position++) & 0xFF) == 4 || size == 16) {
                byte[] bytes = new byte[size];
                ByteBufferUtil.copyBytes(buf, position, bytes, 0, size);
                return InetAddressAndPort.getByAddress(bytes);
            }
            if (size == 6 || size == 18) {
                byte[] bytes = new byte[size - 2];
                ByteBufferUtil.copyBytes(buf, position, bytes, 0, size - 2);
                int port = buf.getShort(position += size - 2) & 0xFFFF;
                return InetAddressAndPort.getByAddressOverrideDefaults(InetAddress.getByAddress(bytes), bytes, port);
            }
            throw new AssertionError((Object)("Unexpected pre-4.0 InetAddressAndPort size " + size));
        }

        @Override
        public long serializedSize(InetAddressAndPort from, int version) {
            if (version >= 12) {
                if (from.address instanceof Inet4Address) {
                    return 7L;
                }
                assert (from.address instanceof Inet6Address);
                return 19L;
            }
            if (from.address instanceof Inet4Address) {
                return 5L;
            }
            assert (from.address instanceof Inet6Address);
            return 17L;
        }
    }
}

