/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.IOError;
import java.io.IOException;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.UnfilteredValidation;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.SerializationHelper;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.SSTableSimpleIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.ByteBufferUtil;

public class SSTableIdentityIterator
implements Comparable<SSTableIdentityIterator>,
UnfilteredRowIterator {
    private final SSTableReader sstable;
    private final DecoratedKey key;
    private final DeletionTime partitionLevelDeletion;
    private final String filename;
    protected final SSTableSimpleIterator iterator;
    private final Row staticRow;

    public SSTableIdentityIterator(SSTableReader sstable, DecoratedKey key, DeletionTime partitionLevelDeletion, String filename, SSTableSimpleIterator iterator) throws IOException {
        this.sstable = sstable;
        this.key = key;
        this.partitionLevelDeletion = partitionLevelDeletion;
        this.filename = filename;
        this.iterator = iterator;
        this.staticRow = iterator.readStaticRow();
    }

    public static SSTableIdentityIterator create(SSTableReader sstable, RandomAccessReader file, DecoratedKey key) {
        try {
            DeletionTime partitionLevelDeletion = DeletionTime.serializer.deserialize(file);
            if (!partitionLevelDeletion.validate()) {
                UnfilteredValidation.handleInvalid(sstable.metadata(), key, sstable, "partitionLevelDeletion=" + partitionLevelDeletion.toString());
            }
            SerializationHelper helper = new SerializationHelper(sstable.metadata(), sstable.descriptor.version.correspondingMessagingVersion(), SerializationHelper.Flag.LOCAL);
            SSTableSimpleIterator iterator = SSTableSimpleIterator.create(sstable.metadata(), file, sstable.header, helper, partitionLevelDeletion);
            return new SSTableIdentityIterator(sstable, key, partitionLevelDeletion, file.getPath(), iterator);
        }
        catch (IOException e) {
            sstable.markSuspect();
            throw new CorruptSSTableException((Throwable)e, file.getPath());
        }
    }

    public static SSTableIdentityIterator create(SSTableReader sstable, FileDataInput dfile, RowIndexEntry<?> indexEntry, DecoratedKey key, boolean tombstoneOnly) {
        try {
            dfile.seek(indexEntry.position);
            ByteBufferUtil.skipShortLength(dfile);
            DeletionTime partitionLevelDeletion = DeletionTime.serializer.deserialize(dfile);
            SerializationHelper helper = new SerializationHelper(sstable.metadata(), sstable.descriptor.version.correspondingMessagingVersion(), SerializationHelper.Flag.LOCAL);
            SSTableSimpleIterator iterator = tombstoneOnly ? SSTableSimpleIterator.createTombstoneOnly(sstable.metadata(), dfile, sstable.header, helper, partitionLevelDeletion) : SSTableSimpleIterator.create(sstable.metadata(), dfile, sstable.header, helper, partitionLevelDeletion);
            return new SSTableIdentityIterator(sstable, key, partitionLevelDeletion, dfile.getPath(), iterator);
        }
        catch (IOException e) {
            sstable.markSuspect();
            throw new CorruptSSTableException((Throwable)e, dfile.getPath());
        }
    }

    @Override
    public TableMetadata metadata() {
        return this.iterator.metadata;
    }

    @Override
    public RegularAndStaticColumns columns() {
        return this.metadata().regularAndStaticColumns();
    }

    @Override
    public boolean isReverseOrder() {
        return false;
    }

    @Override
    public DecoratedKey partitionKey() {
        return this.key;
    }

    @Override
    public DeletionTime partitionLevelDeletion() {
        return this.partitionLevelDeletion;
    }

    @Override
    public Row staticRow() {
        return this.staticRow;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.iterator.hasNext();
        }
        catch (IndexOutOfBoundsException e) {
            this.sstable.markSuspect();
            throw new CorruptSSTableException((Throwable)e, this.filename);
        }
        catch (IOError e) {
            if (e.getCause() instanceof IOException) {
                this.sstable.markSuspect();
                throw new CorruptSSTableException((Throwable)((Exception)e.getCause()), this.filename);
            }
            throw e;
        }
    }

    @Override
    public Unfiltered next() {
        try {
            return this.doCompute();
        }
        catch (IndexOutOfBoundsException e) {
            this.sstable.markSuspect();
            throw new CorruptSSTableException((Throwable)e, this.filename);
        }
        catch (IOError e) {
            if (e.getCause() instanceof IOException) {
                this.sstable.markSuspect();
                throw new CorruptSSTableException((Throwable)((Exception)e.getCause()), this.filename);
            }
            throw e;
        }
    }

    protected Unfiltered doCompute() {
        Unfiltered unfiltered = (Unfiltered)this.iterator.next();
        UnfilteredValidation.maybeValidateUnfiltered(unfiltered, this.metadata(), this.key, this.sstable);
        return unfiltered;
    }

    @Override
    public void close() {
    }

    public String getPath() {
        return this.filename;
    }

    @Override
    public EncodingStats stats() {
        return this.sstable.stats();
    }

    @Override
    public int compareTo(SSTableIdentityIterator o) {
        return this.key.compareTo(o.key);
    }
}

