/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.CRC32;
import org.apache.cassandra.hints.Hint;
import org.apache.cassandra.io.util.DataOutputBufferFixed;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.concurrent.OpOrder;

final class HintsBuffer {
    static final int ENTRY_OVERHEAD_SIZE = 12;
    static final int CLOSED = -1;
    private final ByteBuffer slab;
    private final AtomicInteger position;
    private final ConcurrentMap<UUID, Queue<Integer>> offsets;
    private final OpOrder appendOrder;

    private HintsBuffer(ByteBuffer slab) {
        this.slab = slab;
        this.position = new AtomicInteger();
        this.offsets = new ConcurrentHashMap<UUID, Queue<Integer>>();
        this.appendOrder = new OpOrder();
    }

    static HintsBuffer create(int slabSize) {
        return new HintsBuffer(ByteBuffer.allocateDirect(slabSize));
    }

    boolean isClosed() {
        return this.position.get() == -1;
    }

    int capacity() {
        return this.slab.capacity();
    }

    int remaining() {
        int pos = this.position.get();
        return pos == -1 ? 0 : this.capacity() - pos;
    }

    HintsBuffer recycle() {
        this.slab.clear();
        return new HintsBuffer(this.slab);
    }

    void free() {
        FileUtils.clean(this.slab);
    }

    void waitForModifications() {
        this.appendOrder.awaitNewBarrier();
    }

    Set<UUID> hostIds() {
        return this.offsets.keySet();
    }

    Iterator<ByteBuffer> consumingHintsIterator(UUID hostId) {
        final Queue bufferOffsets = (Queue)this.offsets.get(hostId);
        if (bufferOffsets == null) {
            return Collections.emptyIterator();
        }
        return new AbstractIterator<ByteBuffer>(){
            private final ByteBuffer flyweight;
            {
                this.flyweight = HintsBuffer.this.slab.duplicate();
            }

            @Override
            protected ByteBuffer computeNext() {
                Integer offset = (Integer)bufferOffsets.poll();
                if (offset == null) {
                    return (ByteBuffer)this.endOfData();
                }
                int totalSize = HintsBuffer.this.slab.getInt(offset) + 12;
                return (ByteBuffer)this.flyweight.clear().position(offset).limit(offset + totalSize);
            }
        };
    }

    Allocation allocate(int hintSize) {
        int totalSize = hintSize + 12;
        if (totalSize > this.slab.capacity() / 2) {
            throw new IllegalArgumentException(String.format("Hint of %s bytes is too large - the maximum size is %s", hintSize, this.slab.capacity() / 2));
        }
        OpOrder.Group opGroup = this.appendOrder.start();
        try {
            return this.allocate(totalSize, opGroup);
        }
        catch (Throwable t) {
            opGroup.close();
            throw t;
        }
    }

    private Allocation allocate(int totalSize, OpOrder.Group opGroup) {
        int offset = this.allocateBytes(totalSize);
        if (offset < 0) {
            opGroup.close();
            return null;
        }
        return new Allocation(offset, totalSize, opGroup);
    }

    private int allocateBytes(int totalSize) {
        int next;
        int prev;
        do {
            prev = this.position.get();
            next = prev + totalSize;
            if (prev == -1) {
                return -1;
            }
            if (next <= this.slab.capacity()) continue;
            this.position.set(-1);
            return -1;
        } while (!this.position.compareAndSet(prev, next));
        return prev;
    }

    private void put(UUID hostId, int offset) {
        Queue queue = (Queue)this.offsets.get(hostId);
        if (queue == null) {
            queue = this.offsets.computeIfAbsent(hostId, id -> new ConcurrentLinkedQueue());
        }
        queue.offer(offset);
    }

    final class Allocation
    implements AutoCloseable {
        private final Integer offset;
        private final int totalSize;
        private final OpOrder.Group opGroup;

        Allocation(int offset, int totalSize, OpOrder.Group opGroup) {
            this.offset = offset;
            this.totalSize = totalSize;
            this.opGroup = opGroup;
        }

        void write(Iterable<UUID> hostIds, Hint hint) {
            this.write(hint);
            for (UUID hostId : hostIds) {
                HintsBuffer.this.put(hostId, this.offset);
            }
        }

        @Override
        public void close() {
            this.opGroup.close();
        }

        private void write(Hint hint) {
            ByteBuffer buffer = (ByteBuffer)HintsBuffer.this.slab.duplicate().position(this.offset).limit(this.offset + this.totalSize);
            CRC32 crc = new CRC32();
            int hintSize = this.totalSize - 12;
            try (DataOutputBufferFixed dop = new DataOutputBufferFixed(buffer);){
                dop.writeInt(hintSize);
                FBUtilities.updateChecksumInt(crc, hintSize);
                dop.writeInt((int)crc.getValue());
                Hint.serializer.serialize(hint, (DataOutputPlus)dop, 12);
                FBUtilities.updateChecksum(crc, buffer, buffer.position() - hintSize, hintSize);
                dop.writeInt((int)crc.getValue());
            }
            catch (IOException e) {
                throw new AssertionError();
            }
        }
    }
}

