/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.exceptions;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.exceptions.ExceptionCode;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.locator.InetAddressAndPort;

public class RequestFailureException
extends RequestExecutionException {
    public final ConsistencyLevel consistency;
    public final int received;
    public final int blockFor;
    public final Map<InetAddressAndPort, RequestFailureReason> failureReasonByEndpoint;

    protected RequestFailureException(ExceptionCode code, ConsistencyLevel consistency, int received, int blockFor, Map<InetAddressAndPort, RequestFailureReason> failureReasonByEndpoint) {
        super(code, String.format("Operation failed - received %d responses and %d failures: %s", received, failureReasonByEndpoint.size(), RequestFailureException.buildFailureString(failureReasonByEndpoint)));
        this.consistency = consistency;
        this.received = received;
        this.blockFor = blockFor;
        this.failureReasonByEndpoint = new HashMap<InetAddressAndPort, RequestFailureReason>(failureReasonByEndpoint);
    }

    private static String buildFailureString(Map<InetAddressAndPort, RequestFailureReason> failures) {
        return failures.entrySet().stream().map(e -> String.format("%s from %s", e.getValue(), e.getKey())).collect(Collectors.joining(", "));
    }
}

