/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.apache.cassandra.db.CachedHashDecoratedKey;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.PartitionerDefinedOrder;
import org.apache.cassandra.dht.ComparableObjectToken;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Splitter;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.GuidGenerator;
import org.apache.cassandra.utils.HashingUtils;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.Pair;

public class RandomPartitioner
implements IPartitioner {
    public static final BigInteger ZERO = new BigInteger("0");
    public static final BigIntegerToken MINIMUM = new BigIntegerToken("-1");
    public static final BigInteger MAXIMUM = new BigInteger("2").pow(127);
    public static final int MAXIMUM_TOKEN_SIZE = MAXIMUM.bitLength() / 8 + 1;
    private static final ThreadLocal<MessageDigest> localMD5Digest = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            return HashingUtils.newMessageDigest("MD5");
        }

        @Override
        public MessageDigest get() {
            MessageDigest digest = (MessageDigest)super.get();
            digest.reset();
            return digest;
        }
    };
    private static final int HEAP_SIZE = (int)ObjectSizes.measureDeep(new BigIntegerToken(RandomPartitioner.hashToBigInteger(ByteBuffer.allocate(1))));
    public static final RandomPartitioner instance = new RandomPartitioner();
    public static final AbstractType<?> partitionOrdering = new PartitionerDefinedOrder(instance);
    private final Splitter splitter = new Splitter(this){

        @Override
        public Token tokenForValue(BigInteger value) {
            return new BigIntegerToken(value);
        }

        @Override
        public BigInteger valueForToken(Token token) {
            return (BigInteger)((BigIntegerToken)token).getTokenValue();
        }
    };
    private final Token.TokenFactory tokenFactory = new Token.TokenFactory(){

        @Override
        public ByteBuffer toByteArray(Token token) {
            BigIntegerToken bigIntegerToken = (BigIntegerToken)token;
            return ByteBuffer.wrap(((BigInteger)bigIntegerToken.token).toByteArray());
        }

        @Override
        public void serialize(Token token, DataOutputPlus out) throws IOException {
            out.write(((BigInteger)((BigIntegerToken)token).token).toByteArray());
        }

        @Override
        public void serialize(Token token, ByteBuffer out) {
            out.put(((BigInteger)((BigIntegerToken)token).token).toByteArray());
        }

        @Override
        public int byteSize(Token token) {
            return ((BigInteger)((BigIntegerToken)token).token).bitLength() / 8 + 1;
        }

        @Override
        public Token fromByteArray(ByteBuffer bytes) {
            return new BigIntegerToken(new BigInteger(ByteBufferUtil.getArray(bytes)));
        }

        @Override
        public Token fromByteBuffer(ByteBuffer bytes, int position, int length) {
            return new BigIntegerToken(new BigInteger(ByteBufferUtil.getArray(bytes, position, length)));
        }

        @Override
        public String toString(Token token) {
            BigIntegerToken bigIntegerToken = (BigIntegerToken)token;
            return ((BigInteger)bigIntegerToken.token).toString();
        }

        @Override
        public void validate(String token) throws ConfigurationException {
            try {
                if (!RandomPartitioner.this.isValidToken(new BigInteger(token))) {
                    throw new ConfigurationException("Token must be >= 0 and <= 2**127");
                }
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(e.getMessage());
            }
        }

        @Override
        public Token fromString(String string) {
            return new BigIntegerToken(new BigInteger(string));
        }
    };

    @Override
    public DecoratedKey decorateKey(ByteBuffer key) {
        return new CachedHashDecoratedKey(this.getToken(key), key);
    }

    @Override
    public Token midpoint(Token ltoken, Token rtoken) {
        BigInteger left = ltoken.equals(MINIMUM) ? ZERO : (BigInteger)((BigIntegerToken)ltoken).token;
        BigInteger right = rtoken.equals(MINIMUM) ? ZERO : (BigInteger)((BigIntegerToken)rtoken).token;
        Pair<BigInteger, Boolean> midpair = FBUtilities.midpoint(left, right, 127);
        return new BigIntegerToken((BigInteger)midpair.left);
    }

    @Override
    public Token split(Token ltoken, Token rtoken, double ratioToLeft) {
        BigInteger newToken;
        BigDecimal left = ltoken.equals(MINIMUM) ? BigDecimal.ZERO : new BigDecimal((BigInteger)((BigIntegerToken)ltoken).token);
        BigDecimal right = rtoken.equals(MINIMUM) ? BigDecimal.ZERO : new BigDecimal((BigInteger)((BigIntegerToken)rtoken).token);
        BigDecimal ratio = BigDecimal.valueOf(ratioToLeft);
        if (left.compareTo(right) < 0) {
            newToken = right.subtract(left).multiply(ratio).add(left).toBigInteger();
        } else {
            BigDecimal max = new BigDecimal(MAXIMUM);
            newToken = max.add(right).subtract(left).multiply(ratio).add(left).toBigInteger().mod(MAXIMUM);
        }
        assert (this.isValidToken(newToken)) : "Invalid tokens from split";
        return new BigIntegerToken(newToken);
    }

    @Override
    public BigIntegerToken getMinimumToken() {
        return MINIMUM;
    }

    @Override
    public BigIntegerToken getRandomToken() {
        BigInteger token = RandomPartitioner.hashToBigInteger(GuidGenerator.guidAsBytes());
        if (token.signum() == -1) {
            token = token.multiply(BigInteger.valueOf(-1L));
        }
        return new BigIntegerToken(token);
    }

    @Override
    public BigIntegerToken getRandomToken(Random random) {
        BigInteger token = RandomPartitioner.hashToBigInteger(GuidGenerator.guidAsBytes(random, "host/127.0.0.1", 0L));
        if (token.signum() == -1) {
            token = token.multiply(BigInteger.valueOf(-1L));
        }
        return new BigIntegerToken(token);
    }

    private boolean isValidToken(BigInteger token) {
        return token.compareTo(ZERO) >= 0 && token.compareTo(MAXIMUM) <= 0;
    }

    @Override
    public Token.TokenFactory getTokenFactory() {
        return this.tokenFactory;
    }

    @Override
    public boolean preservesOrder() {
        return false;
    }

    @Override
    public BigIntegerToken getToken(ByteBuffer key) {
        if (key.remaining() == 0) {
            return MINIMUM;
        }
        return new BigIntegerToken(RandomPartitioner.hashToBigInteger(key));
    }

    @Override
    public int getMaxTokenSize() {
        return MAXIMUM_TOKEN_SIZE;
    }

    @Override
    public Map<Token, Float> describeOwnership(List<Token> sortedTokens) {
        HashMap<Token, Float> ownerships = new HashMap<Token, Float>();
        Iterator<Token> i = sortedTokens.iterator();
        if (!i.hasNext()) {
            throw new RuntimeException("No nodes present in the cluster. Has this node finished starting up?");
        }
        if (sortedTokens.size() == 1) {
            ownerships.put(i.next(), new Float(1.0));
        } else {
            float x;
            BigInteger ti;
            BigInteger ri = MAXIMUM;
            BigDecimal r = new BigDecimal(ri);
            Token start = i.next();
            BigInteger tim1 = ti = (BigInteger)((BigIntegerToken)start).token;
            while (i.hasNext()) {
                Token t = i.next();
                ti = (BigInteger)((BigIntegerToken)t).token;
                x = new BigDecimal(ti.subtract(tim1).add(ri).mod(ri)).divide(r).floatValue();
                ownerships.put(t, Float.valueOf(x));
                tim1 = ti;
            }
            x = new BigDecimal(((BigInteger)((BigIntegerToken)start).token).subtract(ti).add(ri).mod(ri)).divide(r).floatValue();
            ownerships.put(start, Float.valueOf(x));
        }
        return ownerships;
    }

    @Override
    public Token getMaximumToken() {
        return new BigIntegerToken(MAXIMUM);
    }

    @Override
    public AbstractType<?> getTokenValidator() {
        return IntegerType.instance;
    }

    @Override
    public AbstractType<?> partitionOrdering() {
        return partitionOrdering;
    }

    @Override
    public Optional<Splitter> splitter() {
        return Optional.of(this.splitter);
    }

    private static BigInteger hashToBigInteger(ByteBuffer data) {
        MessageDigest messageDigest = localMD5Digest.get();
        if (data.hasArray()) {
            messageDigest.update(data.array(), data.arrayOffset() + data.position(), data.remaining());
        } else {
            messageDigest.update(data.duplicate());
        }
        return new BigInteger(messageDigest.digest()).abs();
    }

    public static class BigIntegerToken
    extends ComparableObjectToken<BigInteger> {
        static final long serialVersionUID = -5833589141319293006L;

        public BigIntegerToken(BigInteger token) {
            super(token);
        }

        @VisibleForTesting
        public BigIntegerToken(String token) {
            this(new BigInteger(token));
        }

        @Override
        public IPartitioner getPartitioner() {
            return instance;
        }

        @Override
        public long getHeapSize() {
            return HEAP_SIZE;
        }

        @Override
        public Token increaseSlightly() {
            return new BigIntegerToken(((BigInteger)this.token).add(BigInteger.ONE));
        }

        @Override
        public double size(Token next) {
            BigIntegerToken n = (BigIntegerToken)next;
            BigInteger v = ((BigInteger)n.token).subtract((BigInteger)this.token);
            double d = Math.scalb(v.doubleValue(), -127);
            return d > 0.0 ? d : d + 1.0;
        }
    }
}

