/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.rows.AbstractUnfilteredRowIterator;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.BufferCell;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.virtual.AbstractVirtualTable;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.ByteBufferUtil;

public class SimpleDataSet
extends AbstractVirtualTable.AbstractDataSet {
    private final TableMetadata metadata;
    private Row currentRow;

    public SimpleDataSet(TableMetadata metadata) {
        super(new TreeMap<DecoratedKey, AbstractVirtualTable.Partition>(DecoratedKey.comparator));
        this.metadata = metadata;
    }

    public SimpleDataSet row(Object ... primaryKeyValues) {
        if (Iterables.size(this.metadata.primaryKeyColumns()) != primaryKeyValues.length) {
            throw new IllegalArgumentException();
        }
        Object[] partitionKeyValues = new Object[this.metadata.partitionKeyColumns().size()];
        Object[] clusteringValues = new Object[this.metadata.clusteringColumns().size()];
        System.arraycopy(primaryKeyValues, 0, partitionKeyValues, 0, partitionKeyValues.length);
        System.arraycopy(primaryKeyValues, partitionKeyValues.length, clusteringValues, 0, clusteringValues.length);
        DecoratedKey partitionKey = this.makeDecoratedKey(partitionKeyValues);
        Clustering clustering = this.makeClustering(clusteringValues);
        this.currentRow = new Row(this.metadata, clustering);
        SimplePartition partition = (SimplePartition)this.partitions.computeIfAbsent(partitionKey, pk -> new SimplePartition(this.metadata, (DecoratedKey)pk));
        partition.add(this.currentRow);
        return this;
    }

    public SimpleDataSet column(String columnName, Object value) {
        if (null == this.currentRow) {
            throw new IllegalStateException();
        }
        if (null == columnName) {
            throw new IllegalStateException(String.format("Invalid column: %s=%s for %s", columnName, value, this.currentRow));
        }
        this.currentRow.add(columnName, value);
        return this;
    }

    private DecoratedKey makeDecoratedKey(Object ... partitionKeyValues) {
        ByteBuffer partitionKey = partitionKeyValues.length == 1 ? SimpleDataSet.decompose(this.metadata.partitionKeyType, partitionKeyValues[0]) : ((CompositeType)this.metadata.partitionKeyType).decompose(partitionKeyValues);
        return this.metadata.partitioner.decorateKey(partitionKey);
    }

    private Clustering makeClustering(Object ... clusteringValues) {
        if (clusteringValues.length == 0) {
            return Clustering.EMPTY;
        }
        ByteBuffer[] clusteringByteBuffers = new ByteBuffer[clusteringValues.length];
        for (int i = 0; i < clusteringValues.length; ++i) {
            clusteringByteBuffers[i] = SimpleDataSet.decompose(((ColumnMetadata)this.metadata.clusteringColumns().get((int)i)).type, clusteringValues[i]);
        }
        return Clustering.make(clusteringByteBuffers);
    }

    private static <T> ByteBuffer decompose(AbstractType<?> type, T value) {
        return type.decompose(value);
    }

    private static class Row {
        private final TableMetadata metadata;
        private final Clustering clustering;
        private final Map<ColumnMetadata, Object> values = new HashMap<ColumnMetadata, Object>();

        private Row(TableMetadata metadata, Clustering clustering) {
            this.metadata = metadata;
            this.clustering = clustering;
        }

        private void add(String columnName, Object value) {
            ColumnMetadata column = this.metadata.getColumn(ByteBufferUtil.bytes(columnName));
            if (null == column || !column.isRegular()) {
                throw new IllegalArgumentException();
            }
            this.values.put(column, value);
        }

        private org.apache.cassandra.db.rows.Row toTableRow(RegularAndStaticColumns columns, long now) {
            Row.Builder builder = BTreeRow.unsortedBuilder();
            builder.newRow(this.clustering);
            columns.forEach(c -> {
                Object value = this.values.get(c);
                if (null != value) {
                    builder.addCell(BufferCell.live(c, now, SimpleDataSet.decompose(c.type, value)));
                }
            });
            return builder.build();
        }

        public String toString() {
            return "Row[...:" + this.clustering.toString(this.metadata) + ']';
        }
    }

    private static final class SimplePartition
    implements AbstractVirtualTable.Partition {
        private final DecoratedKey key;
        private final NavigableMap<Clustering, Row> rows;

        private SimplePartition(TableMetadata metadata, DecoratedKey key) {
            this.key = key;
            this.rows = new TreeMap<Clusterable, Row>(metadata.comparator);
        }

        private void add(Row row) {
            this.rows.put(row.clustering, row);
        }

        @Override
        public DecoratedKey key() {
            return this.key;
        }

        @Override
        public UnfilteredRowIterator toRowIterator(TableMetadata metadata, final ClusteringIndexFilter clusteringIndexFilter, ColumnFilter columnFilter, final long now) {
            final Iterator iterator = (clusteringIndexFilter.isReversed() ? this.rows.descendingMap() : this.rows).values().iterator();
            return new AbstractUnfilteredRowIterator(metadata, this.key, DeletionTime.LIVE, columnFilter.queriedColumns(), Rows.EMPTY_STATIC_ROW, false, EncodingStats.NO_STATS){

                @Override
                protected Unfiltered computeNext() {
                    while (iterator.hasNext()) {
                        Row row = (Row)iterator.next();
                        if (!clusteringIndexFilter.selects(row.clustering)) continue;
                        return row.toTableRow(this.columns, now);
                    }
                    return (Unfiltered)this.endOfData();
                }
            };
        }
    }
}

