/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.streaming;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cassandra.db.streaming.CassandraStreamWriter;
import org.apache.cassandra.db.streaming.CompressionInfo;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.DataOutputStreamPlus;
import org.apache.cassandra.net.AsyncStreamingOutputPlus;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraCompressedStreamWriter
extends CassandraStreamWriter {
    private static final int CHUNK_SIZE = 65536;
    private static final Logger logger = LoggerFactory.getLogger(CassandraCompressedStreamWriter.class);
    private final CompressionInfo compressionInfo;

    public CassandraCompressedStreamWriter(SSTableReader sstable, Collection<SSTableReader.PartitionPositionBounds> sections, CompressionInfo compressionInfo, StreamSession session) {
        super(sstable, sections, session);
        this.compressionInfo = compressionInfo;
    }

    @Override
    public void write(DataOutputStreamPlus output) throws IOException {
        AsyncStreamingOutputPlus out = (AsyncStreamingOutputPlus)output;
        long totalSize = this.totalSize();
        logger.debug("[Stream #{}] Start streaming file {} to {}, repairedAt = {}, totalSize = {}", new Object[]{this.session.planId(), this.sstable.getFilename(), this.session.peer, this.sstable.getSSTableMetadata().repairedAt, totalSize});
        try (ChannelProxy fc = this.sstable.getDataChannel().sharedCopy();){
            long progress = 0L;
            List<SSTableReader.PartitionPositionBounds> sections = this.getTransferSections(this.compressionInfo.chunks);
            int sectionIdx = 0;
            for (SSTableReader.PartitionPositionBounds section : sections) {
                int toTransfer;
                long length = section.upperPosition - section.lowerPosition;
                logger.debug("[Stream #{}] Writing section {} with length {} to stream.", new Object[]{this.session.planId(), sectionIdx++, length});
                for (long bytesTransferred = 0L; bytesTransferred < length; bytesTransferred += (long)toTransfer) {
                    toTransfer = (int)Math.min(65536L, length - bytesTransferred);
                    long position = section.lowerPosition + bytesTransferred;
                    out.writeToChannel(bufferSupplier -> {
                        ByteBuffer outBuffer = bufferSupplier.get(toTransfer);
                        long read = fc.read(outBuffer, position);
                        assert (read == (long)toTransfer) : String.format("could not read required number of bytes from file to be streamed: read %d bytes, wanted %d bytes", read, toTransfer);
                        outBuffer.flip();
                    }, this.limiter);
                    this.session.progress(this.sstable.descriptor.filenameFor(Component.DATA), ProgressInfo.Direction.OUT, progress += (long)toTransfer, totalSize);
                }
            }
            logger.debug("[Stream #{}] Finished streaming file {} to {}, bytesTransferred = {}, totalSize = {}", new Object[]{this.session.planId(), this.sstable.getFilename(), this.session.peer, FBUtilities.prettyPrintMemory(progress), FBUtilities.prettyPrintMemory(totalSize)});
        }
    }

    @Override
    protected long totalSize() {
        long size = 0L;
        for (CompressionMetadata.Chunk chunk : this.compressionInfo.chunks) {
            size += (long)(chunk.length + 4);
        }
        return size;
    }

    private List<SSTableReader.PartitionPositionBounds> getTransferSections(CompressionMetadata.Chunk[] chunks) {
        ArrayList<SSTableReader.PartitionPositionBounds> transferSections = new ArrayList<SSTableReader.PartitionPositionBounds>();
        SSTableReader.PartitionPositionBounds lastSection = null;
        for (CompressionMetadata.Chunk chunk : chunks) {
            if (lastSection != null) {
                if (chunk.offset == lastSection.upperPosition) {
                    lastSection = new SSTableReader.PartitionPositionBounds(lastSection.lowerPosition, chunk.offset + (long)chunk.length + 4L);
                    continue;
                }
                transferSections.add(lastSection);
                lastSection = new SSTableReader.PartitionPositionBounds(chunk.offset, chunk.offset + (long)chunk.length + 4L);
                continue;
            }
            lastSection = new SSTableReader.PartitionPositionBounds(chunk.offset, chunk.offset + (long)chunk.length + 4L);
        }
        if (lastSection != null) {
            transferSections.add(lastSection);
        }
        return transferSections;
    }
}

