/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Tuples;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.restrictions.MultiColumnRestriction;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;

public class MultiColumnRelation
extends Relation {
    private final List<ColumnMetadata.Raw> entities;
    private final Term.MultiColumnRaw valuesOrMarker;
    private final List<? extends Term.MultiColumnRaw> inValues;
    private final Tuples.INRaw inMarker;

    private MultiColumnRelation(List<ColumnMetadata.Raw> entities, Operator relationType, Term.MultiColumnRaw valuesOrMarker, List<? extends Term.MultiColumnRaw> inValues, Tuples.INRaw inMarker) {
        this.entities = entities;
        this.relationType = relationType;
        this.valuesOrMarker = valuesOrMarker;
        this.inValues = inValues;
        this.inMarker = inMarker;
    }

    public static MultiColumnRelation createNonInRelation(List<ColumnMetadata.Raw> entities, Operator relationType, Term.MultiColumnRaw valuesOrMarker) {
        assert (relationType != Operator.IN);
        return new MultiColumnRelation(entities, relationType, valuesOrMarker, null, null);
    }

    public static MultiColumnRelation createInRelation(List<ColumnMetadata.Raw> entities, List<? extends Term.MultiColumnRaw> inValues) {
        return new MultiColumnRelation(entities, Operator.IN, null, inValues, null);
    }

    public static MultiColumnRelation createSingleMarkerInRelation(List<ColumnMetadata.Raw> entities, Tuples.INRaw inMarker) {
        return new MultiColumnRelation(entities, Operator.IN, null, null, inMarker);
    }

    public List<ColumnMetadata.Raw> getEntities() {
        return this.entities;
    }

    @Override
    public Term.MultiColumnRaw getValue() {
        return this.relationType == Operator.IN ? this.inMarker : this.valuesOrMarker;
    }

    @Override
    public List<? extends Term.Raw> getInValues() {
        assert (this.relationType == Operator.IN);
        return this.inValues;
    }

    @Override
    public boolean isMultiColumn() {
        return true;
    }

    @Override
    protected Restriction newEQRestriction(TableMetadata table, VariableSpecifications boundNames) {
        List<ColumnMetadata> receivers = this.receivers(table);
        Term term = this.toTerm(receivers, this.getValue(), table.keyspace, boundNames);
        return new MultiColumnRestriction.EQRestriction(receivers, term);
    }

    @Override
    protected Restriction newINRestriction(TableMetadata table, VariableSpecifications boundNames) {
        List<ColumnMetadata> receivers = this.receivers(table);
        List<Term> terms = this.toTerms(receivers, this.inValues, table.keyspace, boundNames);
        if (terms == null) {
            Term term = this.toTerm(receivers, this.getValue(), table.keyspace, boundNames);
            return new MultiColumnRestriction.InRestrictionWithMarker(receivers, (AbstractMarker)term);
        }
        if (terms.size() == 1) {
            return new MultiColumnRestriction.EQRestriction(receivers, terms.get(0));
        }
        return new MultiColumnRestriction.InRestrictionWithValues(receivers, terms);
    }

    @Override
    protected Restriction newSliceRestriction(TableMetadata table, VariableSpecifications boundNames, Bound bound, boolean inclusive) {
        List<ColumnMetadata> receivers = this.receivers(table);
        Term term = this.toTerm(this.receivers(table), this.getValue(), table.keyspace, boundNames);
        return new MultiColumnRestriction.SliceRestriction(receivers, bound, inclusive, term);
    }

    @Override
    protected Restriction newContainsRestriction(TableMetadata table, VariableSpecifications boundNames, boolean isKey) {
        throw RequestValidations.invalidRequest("%s cannot be used for multi-column relations", new Object[]{this.operator()});
    }

    @Override
    protected Restriction newIsNotRestriction(TableMetadata table, VariableSpecifications boundNames) {
        throw new AssertionError((Object)String.format("%s cannot be used for multi-column relations", new Object[]{this.operator()}));
    }

    @Override
    protected Restriction newLikeRestriction(TableMetadata table, VariableSpecifications boundNames, Operator operator) {
        throw RequestValidations.invalidRequest("%s cannot be used for multi-column relations", new Object[]{this.operator()});
    }

    @Override
    protected Term toTerm(List<? extends ColumnSpecification> receivers, Term.Raw raw, String keyspace, VariableSpecifications boundNames) throws InvalidRequestException {
        Term term = ((Term.MultiColumnRaw)raw).prepare(keyspace, receivers);
        term.collectMarkerSpecification(boundNames);
        return term;
    }

    protected List<ColumnMetadata> receivers(TableMetadata table) throws InvalidRequestException {
        ArrayList<ColumnMetadata> names = new ArrayList<ColumnMetadata>(this.getEntities().size());
        int previousPosition = -1;
        for (ColumnMetadata.Raw raw : this.getEntities()) {
            ColumnMetadata def = raw.prepare(table);
            RequestValidations.checkTrue(def.isClusteringColumn(), "Multi-column relations can only be applied to clustering columns but was applied to: %s", def.name);
            RequestValidations.checkFalse(names.contains(def), "Column \"%s\" appeared twice in a relation: %s", def.name, this);
            RequestValidations.checkFalse(previousPosition != -1 && def.position() != previousPosition + 1, "Clustering columns must appear in the PRIMARY KEY order in multi-column relations: %s", this);
            names.add(def);
            previousPosition = def.position();
        }
        return names;
    }

    @Override
    public Relation renameIdentifier(ColumnMetadata.Raw from, ColumnMetadata.Raw to) {
        if (!this.entities.contains(from)) {
            return this;
        }
        List<ColumnMetadata.Raw> newEntities = this.entities.stream().map(e -> e.equals(from) ? to : e).collect(Collectors.toList());
        return new MultiColumnRelation(newEntities, this.operator(), this.valuesOrMarker, this.inValues, this.inMarker);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(Tuples.tupleToString(this.entities));
        if (this.isIN()) {
            return builder.append(" IN ").append(this.inMarker != null ? Character.valueOf('?') : Tuples.tupleToString(this.inValues)).toString();
        }
        return builder.append(" ").append((Object)this.relationType).append(" ").append(this.valuesOrMarker).toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.relationType, this.entities, this.valuesOrMarker, this.inValues, this.inMarker});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiColumnRelation)) {
            return false;
        }
        MultiColumnRelation mcr = (MultiColumnRelation)o;
        return Objects.equals(this.entities, mcr.entities) && Objects.equals(this.valuesOrMarker, mcr.valuesOrMarker) && Objects.equals(this.inValues, mcr.inValues) && Objects.equals(this.inMarker, mcr.inMarker);
    }
}

