/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.btree;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Ordering;
import io.netty.util.Recycler;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.SortedSet;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.btree.BTreeSearchIterator;
import org.apache.cassandra.utils.btree.BTreeSet;
import org.apache.cassandra.utils.btree.TreeBuilder;
import org.apache.cassandra.utils.btree.UpdateFunction;

public class BTree {
    static final int FAN_SHIFT;
    static final int FAN_FACTOR;
    static final int MINIMAL_NODE_SIZE;
    static final Object[] EMPTY_LEAF;
    static final Object[] EMPTY_BRANCH;
    static final Recycler<Builder> builderRecycler;
    static Object POSITIVE_INFINITY;
    static Object NEGATIVE_INFINITY;

    public static Object[] empty() {
        return EMPTY_LEAF;
    }

    public static Object[] singleton(Object value) {
        return new Object[]{value};
    }

    public static <C, K extends C, V extends C> Object[] build(Collection<K> source, UpdateFunction<K, V> updateF) {
        return BTree.buildInternal(source, source.size(), updateF);
    }

    public static <C, K extends C, V extends C> Object[] build(Iterable<K> source, UpdateFunction<K, V> updateF) {
        return BTree.buildInternal(source, -1, updateF);
    }

    public static <C, K extends C, V extends C> Object[] build(Iterable<K> source, int size, UpdateFunction<K, V> updateF) {
        if (size < 0) {
            throw new IllegalArgumentException(Integer.toString(size));
        }
        return BTree.buildInternal(source, size, updateF);
    }

    private static <C, K extends C, V extends C> Object[] buildInternal(Iterable<K> source, int size, UpdateFunction<K, V> updateF) {
        if (size >= 0 & size < FAN_FACTOR) {
            if (size == 0) {
                return EMPTY_LEAF;
            }
            Object[] values = new Object[size | 1];
            int i = 0;
            for (K k : source) {
                values[i++] = updateF.apply(k);
            }
            updateF.allocated(ObjectSizes.sizeOfArray(values));
            return values;
        }
        TreeBuilder builder = TreeBuilder.newInstance();
        Object[] btree = builder.build(source, updateF, size);
        return btree;
    }

    public static <C, K extends C, V extends C> Object[] update(Object[] btree, Comparator<C> comparator, Collection<K> updateWith, UpdateFunction<K, V> updateF) {
        return BTree.update(btree, comparator, updateWith, updateWith.size(), updateF);
    }

    public static <C, K extends C, V extends C> Object[] update(Object[] btree, Comparator<C> comparator, Iterable<K> updateWith, int updateWithLength, UpdateFunction<K, V> updateF) {
        if (BTree.isEmpty(btree)) {
            return BTree.build(updateWith, updateWithLength, updateF);
        }
        TreeBuilder builder = TreeBuilder.newInstance();
        btree = builder.update(btree, comparator, updateWith, updateF);
        return btree;
    }

    public static <K> Object[] merge(Object[] tree1, Object[] tree2, Comparator<? super K> comparator, UpdateFunction<K, K> updateF) {
        if (BTree.size(tree1) < BTree.size(tree2)) {
            Object[] tmp = tree1;
            tree1 = tree2;
            tree2 = tmp;
        }
        return BTree.update(tree1, comparator, new BTreeSet<K>(tree2, comparator), updateF);
    }

    public static <V> Iterator<V> iterator(Object[] btree) {
        return BTree.iterator(btree, Dir.ASC);
    }

    public static <V> Iterator<V> iterator(Object[] btree, Dir dir) {
        return new BTreeSearchIterator(btree, null, dir);
    }

    public static <V> Iterator<V> iterator(Object[] btree, int lb, int ub, Dir dir) {
        return new BTreeSearchIterator(btree, null, dir, lb, ub);
    }

    public static <V> Iterable<V> iterable(Object[] btree) {
        return BTree.iterable(btree, Dir.ASC);
    }

    public static <V> Iterable<V> iterable(Object[] btree, Dir dir) {
        return () -> BTree.iterator(btree, dir);
    }

    public static <V> Iterable<V> iterable(Object[] btree, int lb, int ub, Dir dir) {
        return () -> BTree.iterator(btree, lb, ub, dir);
    }

    public static <K, V> BTreeSearchIterator<K, V> slice(Object[] btree, Comparator<? super K> comparator, Dir dir) {
        return new BTreeSearchIterator(btree, comparator, dir);
    }

    public static <K, V extends K> BTreeSearchIterator<K, V> slice(Object[] btree, Comparator<? super K> comparator, K start, K end, Dir dir) {
        return BTree.slice(btree, comparator, start, true, end, false, dir);
    }

    public static <K, V extends K> BTreeSearchIterator<K, V> slice(Object[] btree, Comparator<? super K> comparator, K start, boolean startInclusive, K end, boolean endInclusive, Dir dir) {
        int inclusiveLowerBound = Math.max(0, start == null ? Integer.MIN_VALUE : (startInclusive ? BTree.ceilIndex(btree, comparator, start) : BTree.higherIndex(btree, comparator, start)));
        int inclusiveUpperBound = Math.min(BTree.size(btree) - 1, end == null ? Integer.MAX_VALUE : (endInclusive ? BTree.floorIndex(btree, comparator, end) : BTree.lowerIndex(btree, comparator, end)));
        return new BTreeSearchIterator(btree, comparator, dir, inclusiveLowerBound, inclusiveUpperBound);
    }

    public static <V> V find(Object[] node, Comparator<? super V> comparator, V find) {
        int keyEnd;
        int i;
        while ((i = Arrays.binarySearch(node, 0, keyEnd = BTree.getKeyEnd(node), find, comparator)) < 0) {
            if (BTree.isLeaf(node)) {
                return null;
            }
            i = -1 - i;
            node = (Object[])node[keyEnd + i];
        }
        return (V)node[i];
    }

    public static <V> void replaceInSitu(Object[] tree, int index, V replace) {
        if (index < 0 | index >= BTree.size(tree)) {
            throw new IndexOutOfBoundsException(index + " not in range [0.." + BTree.size(tree) + ")");
        }
        while (!BTree.isLeaf(tree)) {
            int[] sizeMap = BTree.getSizeMap(tree);
            int boundary = Arrays.binarySearch(sizeMap, index);
            if (boundary >= 0) {
                assert (boundary < sizeMap.length - 1);
                tree[boundary] = replace;
                return;
            }
            if ((boundary = -1 - boundary) > 0) {
                assert (boundary < sizeMap.length);
                index -= 1 + sizeMap[boundary - 1];
            }
            tree = (Object[])tree[BTree.getChildStart(tree) + boundary];
        }
        assert (index < BTree.getLeafKeyEnd(tree));
        tree[index] = replace;
    }

    public static <V> void replaceInSitu(Object[] node, Comparator<? super V> comparator, V find, V replace) {
        while (true) {
            int keyEnd;
            int i;
            if ((i = Arrays.binarySearch(node, 0, keyEnd = BTree.getKeyEnd(node), find, comparator)) >= 0) {
                assert (find == node[i]);
                node[i] = replace;
                return;
            }
            if (BTree.isLeaf(node)) {
                throw new NoSuchElementException();
            }
            i = -1 - i;
            node = (Object[])node[keyEnd + i];
        }
    }

    public static <V> int findIndex(Object[] node, Comparator<? super V> comparator, V find) {
        int lb = 0;
        while (true) {
            int keyEnd;
            int i;
            boolean exact;
            boolean bl = exact = (i = Arrays.binarySearch(node, 0, keyEnd = BTree.getKeyEnd(node), find, comparator)) >= 0;
            if (BTree.isLeaf(node)) {
                return exact ? lb + i : i - lb;
            }
            if (!exact) {
                i = -1 - i;
            }
            int[] sizeMap = BTree.getSizeMap(node);
            if (exact) {
                return lb + sizeMap[i];
            }
            if (i > 0) {
                lb += sizeMap[i - 1] + 1;
            }
            node = (Object[])node[keyEnd + i];
        }
    }

    public static <V> V findByIndex(Object[] tree, int index) {
        if (index < 0 | index >= BTree.size(tree)) {
            throw new IndexOutOfBoundsException(index + " not in range [0.." + BTree.size(tree) + ")");
        }
        Object[] node = tree;
        while (true) {
            if (BTree.isLeaf(node)) {
                int keyEnd = BTree.getLeafKeyEnd(node);
                assert (index < keyEnd);
                return (V)node[index];
            }
            int[] sizeMap = BTree.getSizeMap(node);
            int boundary = Arrays.binarySearch(sizeMap, index);
            if (boundary >= 0) {
                assert (boundary < sizeMap.length - 1);
                return (V)node[boundary];
            }
            if ((boundary = -1 - boundary) > 0) {
                assert (boundary < sizeMap.length);
                index -= 1 + sizeMap[boundary - 1];
            }
            node = (Object[])node[BTree.getChildStart(node) + boundary];
        }
    }

    public static <V> int lowerIndex(Object[] btree, Comparator<? super V> comparator, V find) {
        int i = BTree.findIndex(btree, comparator, find);
        if (i < 0) {
            i = -1 - i;
        }
        return i - 1;
    }

    public static <V> V lower(Object[] btree, Comparator<? super V> comparator, V find) {
        int i = BTree.lowerIndex(btree, comparator, find);
        return i >= 0 ? (V)BTree.findByIndex(btree, i) : null;
    }

    public static <V> int floorIndex(Object[] btree, Comparator<? super V> comparator, V find) {
        int i = BTree.findIndex(btree, comparator, find);
        if (i < 0) {
            i = -2 - i;
        }
        return i;
    }

    public static <V> V floor(Object[] btree, Comparator<? super V> comparator, V find) {
        int i = BTree.floorIndex(btree, comparator, find);
        return i >= 0 ? (V)BTree.findByIndex(btree, i) : null;
    }

    public static <V> int higherIndex(Object[] btree, Comparator<? super V> comparator, V find) {
        int i = BTree.findIndex(btree, comparator, find);
        i = i < 0 ? -1 - i : ++i;
        return i;
    }

    public static <V> V higher(Object[] btree, Comparator<? super V> comparator, V find) {
        int i = BTree.higherIndex(btree, comparator, find);
        return i < BTree.size(btree) ? (V)BTree.findByIndex(btree, i) : null;
    }

    public static <V> int ceilIndex(Object[] btree, Comparator<? super V> comparator, V find) {
        int i = BTree.findIndex(btree, comparator, find);
        if (i < 0) {
            i = -1 - i;
        }
        return i;
    }

    public static <V> V ceil(Object[] btree, Comparator<? super V> comparator, V find) {
        int i = BTree.ceilIndex(btree, comparator, find);
        return i < BTree.size(btree) ? (V)BTree.findByIndex(btree, i) : null;
    }

    static int getKeyEnd(Object[] node) {
        if (BTree.isLeaf(node)) {
            return BTree.getLeafKeyEnd(node);
        }
        return BTree.getBranchKeyEnd(node);
    }

    static int getLeafKeyEnd(Object[] node) {
        int len = node.length;
        return node[len - 1] == null ? len - 1 : len;
    }

    static int getBranchKeyEnd(Object[] branchNode) {
        return branchNode.length / 2 - 1;
    }

    static int getChildStart(Object[] branchNode) {
        return BTree.getBranchKeyEnd(branchNode);
    }

    static int getChildEnd(Object[] branchNode) {
        return branchNode.length - 1;
    }

    static int getChildCount(Object[] branchNode) {
        return branchNode.length / 2;
    }

    static int[] getSizeMap(Object[] branchNode) {
        return (int[])branchNode[BTree.getChildEnd(branchNode)];
    }

    static int lookupSizeMap(Object[] branchNode, int index) {
        return BTree.getSizeMap(branchNode)[index];
    }

    public static int size(Object[] tree) {
        if (BTree.isLeaf(tree)) {
            return BTree.getLeafKeyEnd(tree);
        }
        int length = tree.length;
        return ((int[])tree[length - 1])[length / 2 - 1];
    }

    public static long sizeOfStructureOnHeap(Object[] tree) {
        long size = ObjectSizes.sizeOfArray(tree);
        if (BTree.isLeaf(tree)) {
            return size;
        }
        for (int i = BTree.getChildStart(tree); i < BTree.getChildEnd(tree); ++i) {
            size += BTree.sizeOfStructureOnHeap((Object[])tree[i]);
        }
        return size;
    }

    static boolean isLeaf(Object[] node) {
        return (node.length & 1) == 1;
    }

    public static boolean isEmpty(Object[] tree) {
        return tree == EMPTY_LEAF;
    }

    public static int depth(Object[] tree) {
        int depth = 1;
        while (!BTree.isLeaf(tree)) {
            ++depth;
            tree = (Object[])tree[BTree.getKeyEnd(tree)];
        }
        return depth;
    }

    public static int toArray(Object[] tree, Object[] target, int targetOffset) {
        return BTree.toArray(tree, 0, BTree.size(tree), target, targetOffset);
    }

    public static int toArray(Object[] tree, int treeStart, int treeEnd, Object[] target, int targetOffset) {
        if (BTree.isLeaf(tree)) {
            int count = treeEnd - treeStart;
            System.arraycopy(tree, treeStart, target, targetOffset, count);
            return count;
        }
        int newTargetOffset = targetOffset;
        int childCount = BTree.getChildCount(tree);
        int childOffset = BTree.getChildStart(tree);
        for (int i = 0; i < childCount; ++i) {
            int childStart = BTree.treeIndexOffsetOfChild(tree, i);
            int childEnd = BTree.treeIndexOfBranchKey(tree, i);
            if (childStart > treeEnd || childEnd < treeStart) continue;
            newTargetOffset += BTree.toArray((Object[])tree[childOffset + i], Math.max(0, treeStart - childStart), Math.min(childEnd, treeEnd) - childStart, target, newTargetOffset);
            if (treeStart > childEnd || treeEnd <= childEnd) continue;
            target[newTargetOffset++] = tree[i];
        }
        return newTargetOffset - targetOffset;
    }

    public static <V> Object[] transformAndFilter(Object[] btree, Function<? super V, ? extends V> function) {
        if (BTree.isEmpty(btree)) {
            return btree;
        }
        FiltrationTracker wrapped = new FiltrationTracker(function);
        Object[] result = BTree.transformAndFilter(btree, wrapped);
        if (!wrapped.failed) {
            return result;
        }
        Iterable<V> head = BTree.iterable(result, 0, wrapped.index - 1, Dir.ASC);
        Iterable remainder = BTree.iterable(btree, wrapped.index + 1, BTree.size(btree) - 1, Dir.ASC);
        remainder = Iterables.filter((Iterable)Iterables.transform(remainder, function), x -> x != null);
        Iterable build = Iterables.concat(head, (Iterable)remainder);
        return BTree.buildInternal(build, -1, UpdateFunction.noOp());
    }

    private static <V> Object[] transformAndFilter(Object[] btree, FiltrationTracker<V> function) {
        Object[] result = btree;
        boolean isLeaf = BTree.isLeaf(btree);
        int childOffset = isLeaf ? Integer.MAX_VALUE : BTree.getChildStart(btree);
        int limit = isLeaf ? BTree.getLeafKeyEnd(btree) : btree.length - 1;
        for (int i = 0; i < limit; ++i) {
            Object[] updated;
            int idx = isLeaf ? i : i / 2 + (i % 2 == 0 ? childOffset : 0);
            Object current = btree[idx];
            Object[] objectArray = updated = idx < childOffset ? function.apply(current) : BTree.transformAndFilter((Object[])current, function);
            if (updated != current) {
                if (result == btree) {
                    result = (Object[])btree.clone();
                }
                result[idx] = updated;
            }
            if (!function.failed) continue;
            return result;
        }
        return result;
    }

    public static boolean equals(Object[] a, Object[] b) {
        return BTree.size(a) == BTree.size(b) && Iterators.elementsEqual(BTree.iterator(a), BTree.iterator(b));
    }

    public static int hashCode(Object[] btree) {
        int result = 1;
        for (Object v : BTree.iterable(btree)) {
            result = 31 * result + Objects.hashCode(v);
        }
        return result;
    }

    public static int treeIndexOfKey(Object[] root, int keyIndex) {
        int[] sizeMap;
        if (BTree.isLeaf(root)) {
            return keyIndex;
        }
        if (keyIndex >= 0 & keyIndex < (sizeMap = BTree.getSizeMap(root)).length) {
            return sizeMap[keyIndex];
        }
        if (keyIndex < 0) {
            return -1;
        }
        return sizeMap[keyIndex - 1] + 1;
    }

    public static int treeIndexOfLeafKey(int keyIndex) {
        return keyIndex;
    }

    public static int treeIndexOfBranchKey(Object[] root, int keyIndex) {
        return BTree.lookupSizeMap(root, keyIndex);
    }

    public static int treeIndexOffsetOfChild(Object[] root, int childIndex) {
        if (childIndex == 0) {
            return 0;
        }
        return 1 + BTree.lookupSizeMap(root, childIndex - 1);
    }

    public static <V> Builder<V> builder(Comparator<? super V> comparator) {
        Builder builder = (Builder)builderRecycler.get();
        builder.reuse(comparator);
        return builder;
    }

    public static <V> Builder<V> builder(Comparator<? super V> comparator, int initialCapacity) {
        return BTree.builder(comparator);
    }

    static <V> int compare(Comparator<V> cmp, Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == NEGATIVE_INFINITY | b == POSITIVE_INFINITY) {
            return -1;
        }
        if (b == NEGATIVE_INFINITY | a == POSITIVE_INFINITY) {
            return 1;
        }
        return cmp.compare(a, b);
    }

    public static boolean isWellFormed(Object[] btree, Comparator<? extends Object> cmp) {
        return BTree.isWellFormed(cmp, btree, true, NEGATIVE_INFINITY, POSITIVE_INFINITY);
    }

    private static boolean isWellFormed(Comparator<?> cmp, Object[] node, boolean isRoot, Object min, Object max) {
        if (cmp != null && !BTree.isNodeWellFormed(cmp, node, min, max)) {
            return false;
        }
        if (BTree.isLeaf(node)) {
            if (isRoot) {
                return node.length <= FAN_FACTOR + 1;
            }
            return node.length >= FAN_FACTOR / 2 && node.length <= FAN_FACTOR + 1;
        }
        int keyCount = BTree.getBranchKeyEnd(node);
        if (!isRoot && keyCount < FAN_FACTOR / 2 || keyCount > FAN_FACTOR + 1) {
            return false;
        }
        int type = 0;
        int size = -1;
        int[] sizeMap = BTree.getSizeMap(node);
        for (int i = BTree.getChildStart(node); i < BTree.getChildEnd(node); ++i) {
            Object localmax;
            Object[] child = (Object[])node[i];
            if (sizeMap[i - BTree.getChildStart(node)] != (size += BTree.size(child) + 1)) {
                return false;
            }
            Object object = localmax = i < node.length - 2 ? node[i - BTree.getChildStart(node)] : max;
            if (!BTree.isWellFormed(cmp, child, false, min, localmax)) {
                return false;
            }
            type |= BTree.isLeaf(child) ? 1 : 2;
            min = localmax;
        }
        return type < 3;
    }

    private static boolean isNodeWellFormed(Comparator<?> cmp, Object[] node, Object min, Object max) {
        Object previous = min;
        int end = BTree.getKeyEnd(node);
        for (int i = 0; i < end; ++i) {
            Object current = node[i];
            if (BTree.compare(cmp, previous, current) >= 0) {
                return false;
            }
            previous = current;
        }
        return BTree.compare(cmp, previous, max) < 0;
    }

    static {
        int fanfactor = 32;
        if (System.getProperty("cassandra.btree.fanfactor") != null) {
            fanfactor = Integer.parseInt(System.getProperty("cassandra.btree.fanfactor"));
        }
        int shift = 1;
        while (1 << shift < fanfactor) {
            ++shift;
        }
        FAN_SHIFT = shift;
        FAN_FACTOR = 1 << FAN_SHIFT;
        MINIMAL_NODE_SIZE = FAN_FACTOR >> 1;
        EMPTY_LEAF = new Object[1];
        EMPTY_BRANCH = new Object[]{null, new int[0]};
        builderRecycler = new Recycler<Builder>(){

            protected Builder newObject(Recycler.Handle handle) {
                return new Builder(handle);
            }
        };
        POSITIVE_INFINITY = new Object();
        NEGATIVE_INFINITY = new Object();
    }

    public static class Builder<V> {
        Comparator<? super V> comparator;
        Object[] values;
        int count;
        boolean detected = true;
        boolean auto = true;
        QuickResolver<V> quickResolver;
        final Recycler.Handle recycleHandle;

        private Builder(Recycler.Handle handle) {
            this.recycleHandle = handle;
            this.values = new Object[16];
        }

        public Builder<V> setQuickResolver(QuickResolver<V> quickResolver) {
            this.quickResolver = quickResolver;
            return this;
        }

        public void recycle() {
            if (this.recycleHandle != null) {
                this.cleanup();
                builderRecycler.recycle((Object)this, this.recycleHandle);
            }
        }

        private void cleanup() {
            this.quickResolver = null;
            Arrays.fill(this.values, 0, this.count, null);
            this.count = 0;
            this.detected = true;
            this.auto = true;
        }

        private void reuse(Comparator<? super V> comparator) {
            this.comparator = comparator;
        }

        public Builder<V> auto(boolean auto) {
            this.auto = auto;
            return this;
        }

        public Builder<V> add(V v) {
            if (this.count == this.values.length) {
                this.values = Arrays.copyOf(this.values, this.count * 2);
            }
            Object[] values = this.values;
            int prevCount = this.count++;
            values[prevCount] = v;
            if (this.auto && this.detected && prevCount > 0) {
                Object prev = values[prevCount - 1];
                int c = this.comparator.compare(prev, v);
                if (c == 0 && this.auto) {
                    this.count = prevCount;
                    if (this.quickResolver != null) {
                        values[prevCount - 1] = this.quickResolver.resolve(prev, v);
                    }
                } else if (c > 0) {
                    this.detected = false;
                }
            }
            return this;
        }

        public Builder<V> addAll(Collection<V> add) {
            if (this.auto && add instanceof SortedSet && Builder.equalComparators(this.comparator, ((SortedSet)add).comparator())) {
                return this.mergeAll(add, add.size());
            }
            this.detected = false;
            if (this.values.length < this.count + add.size()) {
                this.values = Arrays.copyOf(this.values, Math.max(this.count + add.size(), this.count * 2));
            }
            for (V v : add) {
                this.values[this.count++] = v;
            }
            return this;
        }

        private static boolean equalComparators(Comparator<?> a, Comparator<?> b) {
            return a == b || Builder.isNaturalComparator(a) && Builder.isNaturalComparator(b);
        }

        private static boolean isNaturalComparator(Comparator<?> a) {
            return a == null || a == Comparator.naturalOrder() || a == Ordering.natural();
        }

        private Builder<V> mergeAll(Iterable<V> add, int addCount) {
            assert (this.auto);
            this.autoEnforce();
            int curCount = this.count;
            if (this.values.length < curCount * 2 + addCount) {
                this.values = Arrays.copyOf(this.values, Math.max(curCount * 2 + addCount, curCount * 3));
            }
            if (add instanceof BTreeSet) {
                ((BTreeSet)add).toArray(this.values, curCount);
            } else {
                int i = curCount;
                for (V v : add) {
                    this.values[i++] = v;
                }
            }
            return this.mergeAll(addCount);
        }

        private Builder<V> mergeAll(int addCount) {
            int i;
            Object[] a = this.values;
            int addOffset = this.count;
            int j = addOffset;
            int curEnd = addOffset;
            int addEnd = addOffset + addCount;
            for (i = 0; i < curEnd && j < addEnd; ++i) {
                int c;
                Object ai = a[i];
                Object aj = a[j];
                int n = c = ai == aj ? 0 : this.comparator.compare(ai, aj);
                if (c > 0) break;
                if (c != 0) continue;
                if (this.quickResolver != null) {
                    a[i] = this.quickResolver.resolve(ai, aj);
                }
                ++j;
            }
            if (j == addEnd) {
                return this;
            }
            int newCount = i;
            System.arraycopy(a, i, a, addEnd, this.count - i);
            curEnd = addEnd + (this.count - i);
            i = addEnd;
            while (i < curEnd && j < addEnd) {
                Object ai = a[i];
                Object aj = a[j];
                int c = this.comparator.compare(ai, aj);
                if (c == 0) {
                    Object newValue = this.quickResolver == null ? ai : this.quickResolver.resolve(ai, aj);
                    a[newCount++] = newValue;
                    ++i;
                    ++j;
                    continue;
                }
                a[newCount++] = c < 0 ? a[i++] : a[j++];
            }
            if (i < curEnd) {
                System.arraycopy(a, i, a, newCount, curEnd - i);
                newCount += curEnd - i;
            } else if (j < addEnd) {
                if (j != newCount) {
                    System.arraycopy(a, j, a, newCount, addEnd - j);
                }
                newCount += addEnd - j;
            }
            this.count = newCount;
            return this;
        }

        public boolean isEmpty() {
            return this.count == 0;
        }

        public Builder<V> reverse() {
            assert (!this.auto);
            int mid = this.count / 2;
            for (int i = 0; i < mid; ++i) {
                Object t = this.values[i];
                this.values[i] = this.values[this.count - (1 + i)];
                this.values[this.count - (1 + i)] = t;
            }
            return this;
        }

        public Builder<V> sort() {
            Arrays.sort(this.values, 0, this.count, this.comparator);
            return this;
        }

        private void autoEnforce() {
            if (!this.detected && this.count > 1) {
                this.sort();
                int prevIdx = 0;
                Object prev = this.values[0];
                for (int i = 1; i < this.count; ++i) {
                    Object next = this.values[i];
                    if (this.comparator.compare(prev, next) != 0) {
                        this.values[++prevIdx] = prev = next;
                        continue;
                    }
                    if (this.quickResolver == null) continue;
                    this.values[prevIdx] = prev = this.quickResolver.resolve(prev, next);
                }
                this.count = prevIdx + 1;
            }
            this.detected = true;
        }

        public Builder<V> resolve(Resolver resolver) {
            if (this.count > 0) {
                int c = 0;
                int prev = 0;
                for (int i = 1; i < this.count; ++i) {
                    if (this.comparator.compare(this.values[i], this.values[prev]) == 0) continue;
                    this.values[c++] = resolver.resolve(this.values, prev, i);
                    prev = i;
                }
                this.values[c++] = resolver.resolve(this.values, prev, this.count);
                this.count = c;
            }
            return this;
        }

        public Object[] build() {
            try {
                if (this.auto) {
                    this.autoEnforce();
                }
                Object[] objectArray = BTree.build(Arrays.asList(this.values).subList(0, this.count), UpdateFunction.noOp());
                return objectArray;
            }
            finally {
                this.recycle();
            }
        }

        public static interface QuickResolver<V> {
            public V resolve(V var1, V var2);
        }

        public static interface Resolver {
            public Object resolve(Object[] var1, int var2, int var3);
        }
    }

    private static class FiltrationTracker<V>
    implements Function<V, V> {
        final Function<? super V, ? extends V> wrapped;
        int index;
        boolean failed;

        private FiltrationTracker(Function<? super V, ? extends V> wrapped) {
            this.wrapped = wrapped;
        }

        public V apply(V i) {
            Object o = this.wrapped.apply(i);
            if (o != null) {
                ++this.index;
            } else {
                this.failed = true;
            }
            return (V)o;
        }
    }

    public static enum Dir {
        ASC,
        DESC;


        public Dir invert() {
            return this == ASC ? DESC : ASC;
        }

        public static Dir asc(boolean asc) {
            return asc ? ASC : DESC;
        }

        public static Dir desc(boolean desc) {
            return desc ? DESC : ASC;
        }
    }
}

