/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.util.concurrent.RateLimiter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.compress.CompressedSequentialWriter;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.IndexSummary;
import org.apache.cassandra.io.sstable.IndexSummaryBuilder;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.util.BufferedSegmentedFile;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.CompressedSegmentedFile;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.MmappedSegmentedFile;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.ReaderFileProxy;
import org.apache.cassandra.io.util.RebuffererFactory;
import org.apache.cassandra.utils.CLibrary;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.concurrent.RefCounted;
import org.apache.cassandra.utils.concurrent.SharedCloseableImpl;

public abstract class SegmentedFile
extends SharedCloseableImpl {
    public final ChannelProxy channel;
    public final long onDiskLength;
    private final RebuffererFactory rebufferer;

    protected SegmentedFile(Cleanup cleanup, ChannelProxy channel, RebuffererFactory rebufferer, long onDiskLength) {
        super(cleanup);
        this.rebufferer = rebufferer;
        this.channel = channel;
        this.onDiskLength = onDiskLength;
    }

    protected SegmentedFile(SegmentedFile copy) {
        super(copy);
        this.channel = copy.channel;
        this.rebufferer = copy.rebufferer;
        this.onDiskLength = copy.onDiskLength;
    }

    public String path() {
        return this.channel.filePath();
    }

    public long dataLength() {
        return this.rebufferer.fileLength();
    }

    public RebuffererFactory rebuffererFactory() {
        return this.rebufferer;
    }

    @Override
    public abstract SegmentedFile sharedCopy();

    public RandomAccessReader createReader() {
        return RandomAccessReader.build(this, null);
    }

    public RandomAccessReader createReader(RateLimiter limiter) {
        return RandomAccessReader.build(this, limiter);
    }

    public FileDataInput createReader(long position) {
        RandomAccessReader reader = this.createReader();
        reader.seek(position);
        return reader;
    }

    public void dropPageCache(long before) {
        CLibrary.trySkipCache(this.channel.getFileDescriptor(), 0L, before, this.path());
    }

    public static Builder getBuilder(Config.DiskAccessMode mode, boolean compressed) {
        return compressed ? new CompressedSegmentedFile.Builder(null) : (mode == Config.DiskAccessMode.mmap ? new MmappedSegmentedFile.Builder() : new BufferedSegmentedFile.Builder());
    }

    public static Builder getCompressedBuilder(CompressedSequentialWriter writer) {
        return new CompressedSegmentedFile.Builder(writer);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(path='" + this.path() + '\'' + ", length=" + this.rebufferer.fileLength() + ')';
    }

    public static abstract class Builder
    implements AutoCloseable {
        private ChannelProxy channel;

        protected abstract SegmentedFile complete(ChannelProxy var1, int var2, long var3);

        private SegmentedFile complete(String path, int bufferSize, long overrideLength) {
            ChannelProxy channelCopy = this.getChannel(path);
            try {
                return this.complete(channelCopy, bufferSize, overrideLength);
            }
            catch (Throwable t) {
                channelCopy.close();
                throw t;
            }
        }

        public SegmentedFile buildData(Descriptor desc, StatsMetadata stats, IndexSummaryBuilder.ReadableBoundary boundary) {
            return this.complete(desc.filenameFor(Component.DATA), Builder.bufferSize(stats), boundary.dataLength);
        }

        public SegmentedFile buildData(Descriptor desc, StatsMetadata stats) {
            return this.complete(desc.filenameFor(Component.DATA), Builder.bufferSize(stats), -1L);
        }

        public SegmentedFile buildIndex(Descriptor desc, IndexSummary indexSummary, IndexSummaryBuilder.ReadableBoundary boundary) {
            return this.complete(desc.filenameFor(Component.PRIMARY_INDEX), Builder.bufferSize(desc, indexSummary), boundary.indexLength);
        }

        public SegmentedFile buildIndex(Descriptor desc, IndexSummary indexSummary) {
            return this.complete(desc.filenameFor(Component.PRIMARY_INDEX), Builder.bufferSize(desc, indexSummary), -1L);
        }

        private static int bufferSize(StatsMetadata stats) {
            return Builder.bufferSize(stats.estimatedPartitionSize.percentile(DatabaseDescriptor.getDiskOptimizationEstimatePercentile()));
        }

        private static int bufferSize(Descriptor desc, IndexSummary indexSummary) {
            File file = new File(desc.filenameFor(Component.PRIMARY_INDEX));
            return Builder.bufferSize(file.length() / (long)indexSummary.size());
        }

        static int bufferSize(long recordSize) {
            Config.DiskOptimizationStrategy strategy = DatabaseDescriptor.getDiskOptimizationStrategy();
            if (strategy == Config.DiskOptimizationStrategy.ssd) {
                double pageCrossProbability = (double)(recordSize % 4096L) / 4096.0;
                if (pageCrossProbability - DatabaseDescriptor.getDiskOptimizationPageCrossChance() > -1.0E-16) {
                    recordSize += 4096L;
                }
                return Builder.roundBufferSize(recordSize);
            }
            if (strategy == Config.DiskOptimizationStrategy.spinning) {
                return Builder.roundBufferSize(recordSize + 4096L);
            }
            throw new IllegalStateException("Unsupported disk optimization strategy: " + (Object)((Object)strategy));
        }

        static int roundBufferSize(long size) {
            if (size <= 0L) {
                return 4096;
            }
            size = size + 4095L & 0xFFFFFFFFFFFFF000L;
            return (int)Math.min(size, 65536L);
        }

        public void serializeBounds(DataOutput out, Version version) throws IOException {
            if (!version.hasBoundaries()) {
                return;
            }
            out.writeUTF(DatabaseDescriptor.getDiskAccessMode().name());
        }

        public void deserializeBounds(DataInput in, Version version) throws IOException {
            if (!version.hasBoundaries()) {
                return;
            }
            if (!in.readUTF().equals(DatabaseDescriptor.getDiskAccessMode().name())) {
                throw new IOException("Cannot deserialize SSTable Summary component because the DiskAccessMode was changed!");
            }
        }

        public Throwable close(Throwable accumulate) {
            if (this.channel != null) {
                return this.channel.close(accumulate);
            }
            return accumulate;
        }

        @Override
        public void close() {
            Throwables.maybeFail(this.close(null));
        }

        private ChannelProxy getChannel(String path) {
            if (this.channel != null) {
                if (this.channel.filePath().equals(path)) {
                    return this.channel.sharedCopy();
                }
                this.channel.close();
            }
            this.channel = new ChannelProxy(path);
            return this.channel.sharedCopy();
        }
    }

    protected static class Cleanup
    implements RefCounted.Tidy {
        final ChannelProxy channel;
        final ReaderFileProxy rebufferer;

        protected Cleanup(ChannelProxy channel, ReaderFileProxy rebufferer) {
            this.channel = channel;
            this.rebufferer = rebufferer;
        }

        @Override
        public String name() {
            return this.channel.filePath();
        }

        @Override
        public void tidy() {
            try {
                this.channel.close();
            }
            finally {
                this.rebufferer.close();
            }
        }
    }
}

