/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import org.apache.cassandra.io.util.AbstractReaderFileProxy;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.MmappedRegions;
import org.apache.cassandra.io.util.Rebufferer;
import org.apache.cassandra.io.util.RebuffererFactory;

class MmapRebufferer
extends AbstractReaderFileProxy
implements Rebufferer,
RebuffererFactory {
    protected final MmappedRegions regions;

    public MmapRebufferer(ChannelProxy channel, long fileLength, MmappedRegions regions) {
        super(channel, fileLength);
        this.regions = regions;
    }

    @Override
    public Rebufferer.BufferHolder rebuffer(long position) {
        return this.regions.floor(position);
    }

    @Override
    public Rebufferer instantiateRebufferer() {
        return this;
    }

    @Override
    public void close() {
        this.regions.closeQuietly();
    }

    @Override
    public void closeReader() {
    }

    @Override
    public String toString() {
        return String.format("%s(%s - data length %d)", this.getClass().getSimpleName(), this.channel.filePath(), this.fileLength());
    }
}

